/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.compat.jei.dynamo;

import cofh.lib.fluid.FluidIngredient;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.compat.jei.TCoreJeiPlugin;
import cofh.thermal.core.util.recipes.dynamo.MagmaticFuel;
import cofh.thermal.expansion.client.gui.dynamo.DynamoMagmaticScreen;
import cofh.thermal.lib.compat.jei.Drawables;
import cofh.thermal.lib.compat.jei.ThermalFuelCategory;
import cofh.thermal.lib.util.recipes.ThermalFuel;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;

public class MagmaticFuelCategory
extends ThermalFuelCategory<MagmaticFuel> {
    protected IDrawableStatic tankBackground;
    protected IDrawableStatic tankOverlay;

    public MagmaticFuelCategory(IGuiHelper guiHelper, ItemStack icon, RecipeType<MagmaticFuel> type) {
        super(guiHelper, icon, type);
        this.background = guiHelper.drawableBuilder(DynamoMagmaticScreen.TEXTURE, 26, 11, 70, 62).addPadding(0, 0, 16, 78).build();
        this.name = StringHelper.getTextComponent((String)((Block)ThermalCore.BLOCKS.get("dynamo_magmatic")).m_7705_());
        this.durationBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getScale(4);
        this.tankBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getTank(1);
        this.tankOverlay = Drawables.getDrawables((IGuiHelper)guiHelper).getTankOverlay(1);
        this.duration = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getScaleFill(4), 400, IDrawableAnimated.StartDirection.TOP, true);
    }

    public RecipeType<MagmaticFuel> getRecipeType() {
        return this.type;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, MagmaticFuel fuel, IFocusGroup focuses) {
        List inputs = fuel.getInputFluids();
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 34, 11).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, List.of(((FluidIngredient)inputs.get(0)).getFluids()))).setFluidRenderer((long)TCoreJeiPlugin.tankSize((int)8000), false, 16, 40).setOverlay((IDrawable)this.tankOverlay, 0, 0).addTooltipCallback(TCoreJeiPlugin.defaultFluidTooltip());
    }

    public void draw(MagmaticFuel recipe, IRecipeSlotsView recipeSlotsView, PoseStack matrixStack, double mouseX, double mouseY) {
        super.draw((ThermalFuel)recipe, recipeSlotsView, matrixStack, mouseX, mouseY);
        this.tankBackground.draw(matrixStack, 33, 10);
    }
}

