/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.block.entity.machine;

import cofh.core.util.helpers.FluidHelper;
import cofh.lib.api.StorageGroup;
import cofh.lib.client.sounds.ConditionalSoundInstance;
import cofh.lib.fluid.FluidStorageCoFH;
import cofh.lib.inventory.ItemStorageCoFH;
import cofh.thermal.core.config.ThermalCoreConfig;
import cofh.thermal.core.util.managers.machine.CrucibleRecipeManager;
import cofh.thermal.expansion.init.TExpSounds;
import cofh.thermal.expansion.init.TExpTileEntities;
import cofh.thermal.expansion.inventory.container.machine.MachineCrucibleContainer;
import cofh.thermal.lib.block.entity.MachineBlockEntity;
import cofh.thermal.lib.util.recipes.IMachineInventory;
import cofh.thermal.lib.util.recipes.IThermalInventory;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;

public class MachineCrucibleTile
extends MachineBlockEntity {
    protected ItemStorageCoFH inputSlot = new ItemStorageCoFH(item -> this.filter.valid(item) && CrucibleRecipeManager.instance().validRecipe(item));
    protected FluidStorageCoFH outputTank = new FluidStorageCoFH(8000);

    public MachineCrucibleTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TExpTileEntities.MACHINE_CRUCIBLE_TILE.get(), pos, state);
        this.inventory.addSlot(this.inputSlot, StorageGroup.INPUT);
        this.inventory.addSlot(this.chargeSlot, StorageGroup.INTERNAL);
        this.tankInv.addTank(this.outputTank, StorageGroup.OUTPUT);
        this.addAugmentSlots(ThermalCoreConfig.machineAugments);
        this.initHandlers();
    }

    protected int getBaseProcessTick() {
        return CrucibleRecipeManager.instance().getBasePower();
    }

    protected boolean cacheRecipe() {
        this.curRecipe = CrucibleRecipeManager.instance().getRecipe((IThermalInventory)this);
        if (this.curRecipe != null) {
            this.itemInputCounts = this.curRecipe.getInputItemCounts((IMachineInventory)this);
        }
        return this.curRecipe != null;
    }

    protected boolean cacheRenderFluid() {
        if (this.curRecipe == null) {
            return false;
        }
        FluidStack prevFluid = this.renderFluid;
        this.renderFluid = new FluidStack((FluidStack)this.curRecipe.getOutputFluids((IMachineInventory)this).get(0), 1000);
        return !FluidHelper.fluidsEqual((FluidStack)this.renderFluid, (FluidStack)prevFluid);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new MachineCrucibleContainer(i, this.f_58857_, this.f_58858_, inventory, player);
    }

    protected Object getSound() {
        return new ConditionalSoundInstance((SoundEvent)TExpSounds.SOUND_MACHINE_CRUCIBLE.get(), SoundSource.AMBIENT, (BlockEntity)this, () -> !this.f_58859_ && this.isActive);
    }

    protected boolean validateInputs() {
        if (!this.cacheRecipe()) {
            return false;
        }
        return this.inputSlot.getCount() >= (Integer)this.itemInputCounts.get(0);
    }

    protected boolean validateOutputs() {
        if (this.curRecipe == null && !this.cacheRecipe()) {
            return false;
        }
        if (this.outputTank.isEmpty()) {
            return true;
        }
        FluidStack output = this.outputTank.getFluidStack();
        FluidStack recipeOutput = (FluidStack)this.curRecipe.getOutputFluids((IMachineInventory)this).get(0);
        if (this.outputTank.getSpace() < recipeOutput.getAmount()) {
            return false;
        }
        return FluidHelper.fluidsEqual((FluidStack)output, (FluidStack)recipeOutput);
    }
}

