/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironchest.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import com.progwml6.ironchest.IronChestsClientEvents;
import com.progwml6.ironchest.client.model.IronChestsModels;
import com.progwml6.ironchest.client.model.inventory.ModelItem;
import com.progwml6.ironchest.common.block.IronChestsTypes;
import com.progwml6.ironchest.common.block.entity.ICrystalChest;
import com.progwml6.ironchest.common.block.regular.AbstractIronChestBlock;
import com.progwml6.ironchest.common.block.regular.entity.AbstractIronChestBlockEntity;
import com.progwml6.ironchest.common.block.trapped.entity.AbstractTrappedIronChestBlockEntity;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class IronChestRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    private final ModelPart lid;
    private final ModelPart bottom;
    private final ModelPart lock;
    private final BlockEntityRenderDispatcher renderer;
    private static final List<ModelItem> MODEL_ITEMS = Arrays.asList(new ModelItem(new Vector3f(0.3f, 0.45f, 0.3f), 3.0f), new ModelItem(new Vector3f(0.7f, 0.45f, 0.3f), 3.0f), new ModelItem(new Vector3f(0.3f, 0.45f, 0.7f), 3.0f), new ModelItem(new Vector3f(0.7f, 0.45f, 0.7f), 3.0f), new ModelItem(new Vector3f(0.3f, 0.1f, 0.3f), 3.0f), new ModelItem(new Vector3f(0.7f, 0.1f, 0.3f), 3.0f), new ModelItem(new Vector3f(0.3f, 0.1f, 0.7f), 3.0f), new ModelItem(new Vector3f(0.7f, 0.1f, 0.7f), 3.0f), new ModelItem(new Vector3f(0.5f, 0.32f, 0.5f), 3.0f));

    public IronChestRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart modelPart = context.m_173582_(IronChestsClientEvents.IRON_CHEST);
        this.renderer = context.m_173581_();
        this.bottom = modelPart.m_171324_("iron_bottom");
        this.lid = modelPart.m_171324_("iron_lid");
        this.lock = modelPart.m_171324_("iron_lock");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_("iron_bottom", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171481_(1.0f, 0.0f, 1.0f, 14.0f, 10.0f, 14.0f), PartPose.f_171404_);
        partDefinition.m_171599_("iron_lid", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(1.0f, 0.0f, 0.0f, 14.0f, 5.0f, 14.0f), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)1.0f));
        partDefinition.m_171599_("iron_lock", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(7.0f, -1.0f, 15.0f, 2.0f, 4.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public void m_6922_(T tileEntityIn, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLightIn, int combinedOverlayIn) {
        AbstractIronChestBlockEntity tileEntity = (AbstractIronChestBlockEntity)((Object)tileEntityIn);
        Level level = tileEntity.m_58904_();
        boolean useTileEntityBlockState = level != null;
        BlockState blockState = useTileEntityBlockState ? tileEntity.m_58900_() : (BlockState)tileEntity.getBlockToUse().m_49966_().m_61124_((Property)AbstractIronChestBlock.FACING, (Comparable)Direction.SOUTH);
        Block block = blockState.m_60734_();
        IronChestsTypes chestType = IronChestsTypes.IRON;
        IronChestsTypes actualType = AbstractIronChestBlock.getTypeFromBlock(block);
        if (actualType != null) {
            chestType = actualType;
        }
        if (block instanceof AbstractIronChestBlock) {
            AbstractIronChestBlock abstractChestBlock = (AbstractIronChestBlock)block;
            poseStack.m_85836_();
            float f = ((Direction)blockState.m_61143_((Property)AbstractIronChestBlock.FACING)).m_122435_();
            poseStack.m_85837_(0.5, 0.5, 0.5);
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(-f));
            poseStack.m_85837_(-0.5, -0.5, -0.5);
            DoubleBlockCombiner.NeighborCombineResult<? extends AbstractIronChestBlockEntity> neighborCombineResult = useTileEntityBlockState ? abstractChestBlock.combine(blockState, level, tileEntityIn.m_58899_(), true) : DoubleBlockCombiner.Combiner::m_6502_;
            float openness = ((Float2FloatFunction)neighborCombineResult.m_5649_(AbstractIronChestBlock.opennessCombiner(tileEntity))).get(partialTicks);
            openness = 1.0f - openness;
            openness = 1.0f - openness * openness * openness;
            int brightness = ((Int2IntFunction)neighborCombineResult.m_5649_((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).applyAsInt(combinedLightIn);
            boolean trapped = tileEntityIn instanceof AbstractTrappedIronChestBlockEntity;
            Material material = new Material(Sheets.f_110740_, IronChestsModels.chooseChestTexture(chestType, trapped));
            VertexConsumer vertexConsumer = material.m_119194_(bufferSource, RenderType::m_110452_);
            this.render(poseStack, vertexConsumer, this.lid, this.lock, this.bottom, openness, brightness, combinedOverlayIn);
            poseStack.m_85849_();
            if (chestType.isTransparent() && tileEntity instanceof ICrystalChest) {
                ICrystalChest crystalChest = (ICrystalChest)((Object)tileEntity);
                if (Vec3.m_82512_((Vec3i)tileEntityIn.m_58899_()).m_82509_((Position)this.renderer.f_112249_.m_90583_(), 128.0)) {
                    float rotation = (float)(360.0 * (double)(System.currentTimeMillis() & 0x3FFFL) / 16383.0) - partialTicks;
                    for (int j = 0; j < MODEL_ITEMS.size() - 1; ++j) {
                        IronChestRenderer.renderItem(poseStack, bufferSource, (ItemStack)crystalChest.getTopItems().get(j), MODEL_ITEMS.get(j), rotation, combinedLightIn);
                    }
                }
            }
        }
    }

    private void render(PoseStack poseStack, VertexConsumer vertexConsumer, ModelPart lid, ModelPart lock, ModelPart bottom, float openness, int brightness, int combinedOverlayIn) {
        lock.f_104203_ = lid.f_104203_ = -(openness * 1.5707964f);
        lid.m_104301_(poseStack, vertexConsumer, brightness, combinedOverlayIn);
        lock.m_104301_(poseStack, vertexConsumer, brightness, combinedOverlayIn);
        bottom.m_104301_(poseStack, vertexConsumer, brightness, combinedOverlayIn);
    }

    public static void renderItem(PoseStack matrices, MultiBufferSource buffer, ItemStack item, ModelItem modelItem, float rotation, int light) {
        if (item.m_41619_()) {
            return;
        }
        matrices.m_85836_();
        Vector3f center = modelItem.getCenter();
        matrices.m_85837_((double)center.m_122239_(), (double)center.m_122260_(), (double)center.m_122269_());
        matrices.m_85845_(Vector3f.f_122225_.m_122240_(rotation));
        float scale = modelItem.getSizeScaled();
        matrices.m_85841_(scale, scale, scale);
        Minecraft.m_91087_().m_91291_().m_174269_(item, ItemTransforms.TransformType.NONE, light, OverlayTexture.f_118083_, matrices, buffer, 0);
        matrices.m_85849_();
    }
}

