/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.tileentities;

import com.ldtteam.structurize.api.util.IRotatableBlockEntity;
import com.ldtteam.structurize.blockentities.interfaces.IBlueprintDataProviderBE;
import com.ldtteam.structurize.storage.StructurePacks;
import com.minecolonies.api.compatibility.newstruct.BlueprintMapping;
import com.minecolonies.api.tileentities.MinecoloniesTileEntities;
import com.minecolonies.api.util.Utils;
import com.minecolonies.api.util.WorldUtil;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class TileEntityDecorationController
extends BlockEntity
implements IBlueprintDataProviderBE,
IRotatableBlockEntity {
    private String schematicName = "";
    private String schematicPath = "";
    private String packName = "";
    private BlockPos corner1 = BlockPos.f_121853_;
    private BlockPos corner2 = BlockPos.f_121853_;
    private Rotation rotation = Rotation.NONE;
    private boolean mirror;
    private Map<BlockPos, List<String>> tagPosMap = new HashMap<BlockPos, List<String>>();

    public TileEntityDecorationController(BlockPos pos, BlockState state) {
        super((BlockEntityType)MinecoloniesTileEntities.DECO_CONTROLLER.get(), pos, state);
    }

    public String getSchematicPath() {
        return this.schematicPath;
    }

    public String getPackName() {
        return this.packName;
    }

    public String getBlueprintPath() {
        return this.schematicPath;
    }

    public String getSchematicName() {
        return this.schematicName;
    }

    public void setSchematicName(String s) {
        this.schematicName = s;
        this.m_6596_();
    }

    private void update() {
        this.m_6596_();
    }

    public void m_6596_() {
        if (this.f_58857_ != null) {
            WorldUtil.markChunkDirty(this.f_58857_, this.f_58858_);
        }
    }

    public Map<BlockPos, List<String>> getPositionedTags() {
        return this.tagPosMap;
    }

    public void setPositionedTags(Map<BlockPos, List<String>> positionedTags) {
        this.tagPosMap = positionedTags;
        this.m_6596_();
    }

    public Tuple<BlockPos, BlockPos> getSchematicCorners() {
        if (this.corner1 == BlockPos.f_121853_ || this.corner2 == BlockPos.f_121853_) {
            return new Tuple((Object)this.f_58858_, (Object)this.f_58858_);
        }
        return new Tuple((Object)this.corner1, (Object)this.corner2);
    }

    public void setSchematicCorners(BlockPos pos1, BlockPos pos2) {
        this.corner1 = pos1;
        this.corner2 = pos2;
        this.m_6596_();
    }

    public void readSchematicDataFromNBT(CompoundTag compound) {
        super.readSchematicDataFromNBT(compound);
        CompoundTag blueprintDataProvider = compound.m_128469_("blueprintDataProvider");
        if (compound.m_128441_("pack")) {
            String path = blueprintDataProvider.m_128461_("name");
            this.schematicPath = path + File.separator + this.schematicName + ".blueprint";
        } else {
            String[] split;
            if (compound.m_128441_("name")) {
                this.schematicPath = compound.m_128461_("name");
                split = Utils.splitPath(this.schematicPath);
                this.schematicName = split[split.length - 1].replace(".blueprint", "");
            }
            if ((split = Utils.splitPath(this.schematicPath)).length >= 4) {
                this.packName = BlueprintMapping.getStyleMapping(split[2]);
            }
            if (this.packName == null || this.packName.isEmpty()) {
                this.packName = "Minecolonies Original";
            }
            if (this.schematicName.contains("/") || this.schematicName.contains("\\")) {
                String[] splitName = Utils.splitPath(this.schematicPath);
                this.schematicName = splitName[splitName.length - 1].replace(".blueprint", "");
            }
            if (compound.m_128441_("level")) {
                this.schematicName = this.schematicName + compound.m_128451_("level");
            }
            this.schematicPath = StructurePacks.hasPack((String)this.packName) ? StructurePacks.getStructurePack((String)this.packName).getSubPath(StructurePacks.findBlueprint((String)this.packName, (String)this.schematicName)) : this.schematicName;
            if (!this.schematicPath.endsWith(".blueprint")) {
                this.schematicPath = this.schematicPath + ".blueprint";
            }
        }
        if (blueprintDataProvider.m_128441_("pack")) {
            this.packName = blueprintDataProvider.m_128461_("pack");
        }
        if (this.packName == null) {
            this.packName = "Minecolonies Original";
        }
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        super.readSchematicDataFromNBT(compound);
        this.rotation = Rotation.values()[compound.m_128451_("rotation")];
        this.mirror = compound.m_128471_("mirror");
        if (compound.m_128441_("path")) {
            this.schematicPath = compound.m_128461_("path");
        }
        if (compound.m_128441_("name")) {
            this.schematicName = compound.m_128461_("name");
            if (this.schematicPath == null || this.schematicPath.isEmpty()) {
                this.schematicPath = this.schematicName;
                this.schematicName = "";
            }
        }
        this.packName = compound.m_128461_("pack");
        if (!this.schematicPath.endsWith(".blueprint")) {
            this.schematicPath = this.schematicPath + ".blueprint";
        }
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        this.writeSchematicDataToNBT(compound);
        compound.m_128405_("rotation", this.rotation.ordinal());
        compound.m_128379_("mirror", this.mirror);
        compound.m_128359_("name", this.schematicName == null ? "" : this.schematicName);
        compound.m_128359_("path", this.schematicPath == null ? "" : this.schematicPath);
        compound.m_128359_("pack", this.packName == null || this.packName.isEmpty() ? "" : this.packName);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void setBlueprintPath(String filePath) {
        this.schematicPath = filePath;
        if (!this.schematicPath.endsWith(".blueprint")) {
            this.schematicPath = this.schematicPath + ".blueprint";
        }
        this.m_6596_();
    }

    public void setPackName(String packName) {
        this.packName = packName;
        this.m_6596_();
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187481_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        CompoundTag compound = packet.m_131708_();
        this.m_142466_(compound);
    }

    public BlockPos getTilePos() {
        return this.f_58858_;
    }

    public void rotate(Rotation rotationIn) {
        this.rotation = rotationIn;
    }

    public void mirror(Mirror mirror) {
        this.mirror = mirror != Mirror.NONE;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public boolean getMirror() {
        return this.mirror;
    }
}

