/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.recipes;

import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlock;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockComponent;
import com.ldtteam.domumornamentum.recipe.ModRecipeTypes;
import com.ldtteam.domumornamentum.recipe.architectscutter.ArchitectsCutterRecipe;
import com.minecolonies.api.crafting.GenericRecipe;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.ModCraftingTypes;
import com.minecolonies.api.crafting.RecipeCraftingType;
import com.minecolonies.api.util.constant.ToolType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArchitectsCutterCraftingType
extends RecipeCraftingType<Container, ArchitectsCutterRecipe> {
    public ArchitectsCutterCraftingType() {
        super(ModCraftingTypes.ARCHITECTS_CUTTER_ID, (RecipeType)ModRecipeTypes.ARCHITECTS_CUTTER.get(), null);
    }

    @Override
    @NotNull
    public List<IGenericRecipe> findRecipes(@NotNull RecipeManager recipeManager, @Nullable Level world) {
        Random rnd = new Random();
        ArrayList<IGenericRecipe> recipes = new ArrayList<IGenericRecipe>();
        for (ArchitectsCutterRecipe recipe : recipeManager.m_44013_((RecipeType)ModRecipeTypes.ARCHITECTS_CUTTER.get())) {
            Block generatedBlock = (Block)ForgeRegistries.BLOCKS.getValue(recipe.getBlockName());
            if (!(generatedBlock instanceof IMateriallyTexturedBlock)) continue;
            IMateriallyTexturedBlock materiallyTexturedBlock = (IMateriallyTexturedBlock)generatedBlock;
            ArrayList<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>();
            for (IMateriallyTexturedBlockComponent component : materiallyTexturedBlock.getComponents()) {
                List blocks = ForgeRegistries.BLOCKS.tags().getTag(component.getValidSkins()).stream().collect(Collectors.toCollection(ArrayList::new));
                Collections.shuffle(blocks, rnd);
                inputs.add(blocks.stream().map(ItemStack::new).collect(Collectors.toList()));
            }
            ItemStack output = recipe.m_8043_().m_41777_();
            output.m_41764_(Math.max(recipe.getCount(), inputs.size()));
            if (!output.m_41784_().m_128441_("textureData")) {
                assert (output.m_41783_() != null);
                output.m_41783_().m_128365_("textureData", (Tag)new CompoundTag());
            }
            recipes.add(new GenericRecipe(recipe.m_6423_(), output, new ArrayList<ItemStack>(), inputs, 3, Blocks.f_50016_, null, ToolType.NONE, new ArrayList<Component>(), -1));
        }
        return recipes;
    }
}

