/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.items;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.entity.ai.statemachine.AIOneTimeEventTarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.tileentities.TileEntityColonyBuilding;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.colony.buildings.modules.settings.FollowModeSetting;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.entity.ai.citizen.guard.AbstractEntityAIGuard;
import com.minecolonies.coremod.items.AbstractItemScroll;
import com.minecolonies.coremod.network.messages.client.VanillaParticleMessage;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class ItemScrollGuardHelp
extends AbstractItemScroll {
    public ItemScrollGuardHelp(Item.Properties properties) {
        super("scroll_guard_help", properties);
    }

    @Override
    protected ItemStack onItemUseSuccess(ItemStack itemStack, Level world, ServerPlayer player) {
        IColony colony = this.getColony(itemStack);
        BlockPos buildingPos = BlockPosUtil.read(itemStack.m_41783_(), "building_pos");
        IBuilding building = colony.getBuildingManager().getBuilding(buildingPos);
        if (!(building instanceof AbstractBuildingGuards)) {
            MessageUtils.format("minecolonies.scroll.noguardbuilding", new Object[0]).sendTo(new Player[]{player});
            return itemStack;
        }
        itemStack.m_41774_(1);
        ArrayList<ICitizenData> guards = new ArrayList<ICitizenData>(building.getAllAssignedCitizen());
        if (world.f_46441_.m_188503_(10) == 0 || colony.getWorld() != world) {
            Llama entity = (Llama)EntityType.f_20466_.m_20615_(world);
            entity.m_6034_(player.m_20185_(), player.m_20186_(), player.m_20189_());
            world.m_7967_((Entity)entity);
            player.m_5661_((Component)Component.m_237115_((String)("minecolonies.scroll.failed" + (world.f_46441_.m_188503_(10) + 1))).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), true);
            SoundUtils.playSoundForPlayer(player, SoundEvents.f_11862_, 0.5f, 1.0f);
            return itemStack;
        }
        for (ICitizenData citizenData : guards) {
            AbstractJobGuard job = citizenData.getJob(AbstractJobGuard.class);
            if (job != null && job.getWorkerAI() != null && !((AbstractEntityAIGuard)job.getWorkerAI()).hasTool()) continue;
            if (citizenData.getEntity().isPresent()) {
                if (citizenData.getEntity().get().getCitizenDiseaseHandler().isSick()) continue;
                citizenData.getEntity().get().m_142687_(Entity.RemovalReason.DISCARDED);
            }
            colony.getCitizenManager().spawnOrCreateCivilian(citizenData, world, player.m_20183_(), true);
            citizenData.setNextRespawnPosition(buildingPos);
            ((AbstractBuildingGuards)building).getSetting(AbstractBuildingGuards.GUARD_TASK).set("com.minecolonies.core.guard.setting.follow");
            ((AbstractBuildingGuards)building).setPlayerToFollow((Player)player);
            FollowModeSetting grouping = ((AbstractBuildingGuards)building).getSetting(AbstractBuildingGuards.FOLLOW_MODE);
            if (grouping.getValue().equals(FollowModeSetting.LOOSE)) {
                grouping.trigger();
            }
            citizenData.setSaturation(100.0);
            colony.getPackageManager().addCloseSubscriber(player);
            if (job == null || job.getWorkerAI() == null) continue;
            long spawnTime = world.m_46467_() + 18000L;
            job.getWorkerAI().registerTarget(new AIOneTimeEventTarget(() -> {
                if (world.m_46467_() - spawnTime > 0L) {
                    ((AbstractBuildingGuards)building).getSetting(AbstractBuildingGuards.GUARD_TASK).set("com.minecolonies.core.guard.setting.patrol");
                    citizenData.getEntity().ifPresent(e -> e.m_142687_(Entity.RemovalReason.DISCARDED));
                    colony.getPackageManager().removeCloseSubscriber(player);
                    return true;
                }
                return false;
            }, AIWorkerState.DECIDE));
        }
        SoundUtils.playSoundForPlayer(player, SoundEvents.f_12496_, 0.3f, 1.0f);
        return itemStack;
    }

    @Override
    protected boolean needsColony() {
        return true;
    }

    @Override
    @NotNull
    public InteractionResult m_6225_(UseOnContext ctx) {
        IBuilding building;
        InteractionResult result = super.m_6225_(ctx);
        if (ctx.m_43725_().f_46443_) {
            return result;
        }
        BlockEntity te = ctx.m_43725_().m_7702_(ctx.m_8083_());
        if (te instanceof TileEntityColonyBuilding && ctx.m_43723_() != null && !((building = ((TileEntityColonyBuilding)te).getColony().getBuildingManager().getBuilding(ctx.m_8083_())) instanceof AbstractBuildingGuards)) {
            MessageUtils.format("minecolonies.scroll.noguardbuilding", new Object[0]).sendTo(ctx.m_43723_());
        }
        return result;
    }

    public void m_5929_(Level worldIn, LivingEntity entity, ItemStack stack, int count) {
        if (!worldIn.f_46443_ && worldIn.m_46467_() % 5L == 0L) {
            Network.getNetwork().sendToTrackingEntity(new VanillaParticleMessage(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), ParticleTypes.f_123809_), (Entity)entity);
            Network.getNetwork().sendToPlayer(new VanillaParticleMessage(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), ParticleTypes.f_123809_), (ServerPlayer)entity);
        }
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        MutableComponent guiHint = Component.m_237115_((String)"item.minecolonies.scroll_guard_help.tip");
        guiHint.m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN));
        tooltip.add((Component)guiHint);
        String colonyDesc = Component.m_237115_((String)"item.minecolonies.scroll.colony.none").getString();
        IColony colony = this.getColonyView(stack);
        if (colony != null) {
            colonyDesc = colony.getName();
        }
        MutableComponent guiHint2 = Component.m_237110_((String)"item.minecolonies.scroll.colony.tip", (Object[])new Object[]{colonyDesc});
        guiHint2.m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD));
        tooltip.add((Component)guiHint2);
    }
}

