/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.event;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.crafting.CustomRecipeManager;
import com.minecolonies.coremod.compatibility.CraftingTagAuditor;
import com.minecolonies.coremod.network.messages.client.UpdateClientWithCompatibilityMessage;
import com.minecolonies.coremod.util.FurnaceRecipes;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

public class DataPackSyncEventHandler {

    public static class ClientEvents {
        @SubscribeEvent
        public static void onRecipesLoaded(@NotNull RecipesUpdatedEvent event) {
            if (Minecraft.m_91087_().m_91091_()) {
                return;
            }
            FurnaceRecipes.getInstance().loadRecipes(event.getRecipeManager());
        }
    }

    public static class ServerEvents {
        private static void loadRecipes(@NotNull MinecraftServer server) {
            FurnaceRecipes.getInstance().loadRecipes(server.m_129894_());
            IMinecoloniesAPI.getInstance().getColonyManager().getCompatibilityManager().discover(server.m_129894_());
            CustomRecipeManager.getInstance().buildLootData(server.m_129898_());
        }

        private static void sendPackets(@NotNull ServerPlayer player, @NotNull UpdateClientWithCompatibilityMessage compatMsg) {
            Network.getNetwork().sendToPlayer(compatMsg, player);
            CustomRecipeManager.getInstance().sendCustomRecipeManagerPackets(player);
            IGlobalResearchTree.getInstance().sendGlobalResearchTreePackets(player);
        }

        @SubscribeEvent
        public static void onDataPackSync(OnDatapackSyncEvent event) {
            CustomRecipeManager recipeManager = CustomRecipeManager.getInstance();
            MinecraftServer server = event.getPlayerList().m_7873_();
            if (event.getPlayer() == null) {
                ServerEvents.loadRecipes(server);
                if (!server.m_129792_()) {
                    UpdateClientWithCompatibilityMessage compatMsg = new UpdateClientWithCompatibilityMessage(true);
                    for (ServerPlayer player : event.getPlayerList().m_11314_()) {
                        ServerEvents.sendPackets(player, compatMsg);
                    }
                }
            } else if (!server.m_129792_()) {
                ServerEvents.sendPackets(event.getPlayer(), new UpdateClientWithCompatibilityMessage(true));
            }
            if (((Boolean)MineColonies.getConfig().getServer().auditCraftingTags.get()).booleanValue() && (event.getPlayer() == null || event.getPlayerList().m_11314_().isEmpty())) {
                CraftingTagAuditor.doRecipeAudit(server, recipeManager);
            }
        }

        @SubscribeEvent
        public static void onServerStarted(@NotNull ServerStartedEvent event) {
            ServerEvents.loadRecipes(event.getServer());
        }
    }
}

