/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.minimal;

import com.ldtteam.structurize.blockentities.interfaces.IBlueprintDataProviderBE;
import com.minecolonies.api.entity.ai.DesiredActivity;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.pathfinding.AbstractAdvancedPathNavigate;
import com.minecolonies.api.tileentities.TileEntityColonyBuilding;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingLibrary;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.entity.SittingEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;

public class EntityAICitizenWander
extends Goal {
    private static final int LEISURE_CHANCE = 5;
    protected final AbstractEntityCitizen citizen;
    protected final double speed;
    private final TickRateStateMachine<WanderState> stateMachine;
    private BlockPos walkTo;
    private BlockPos leisureSite;

    public EntityAICitizenWander(AbstractEntityCitizen citizen, double speed) {
        this.citizen = citizen;
        this.speed = speed;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        this.stateMachine = new TickRateStateMachine<WanderState>(WanderState.IDLE, e -> Log.getLogger().warn("Wandering AI threw exception:", (Throwable)e));
        this.stateMachine.addTransition(new TickingTransition<WanderState>(WanderState.IDLE, () -> true, this::decide, 100));
        this.stateMachine.addTransition(new TickingTransition<WanderState>(WanderState.GO_TO_LEISURE_SITE, () -> true, this::goToLeisureSite, 20));
        this.stateMachine.addTransition(new TickingTransition<WanderState>(WanderState.WANDER_AT_LEISURE_SITE, () -> true, this::wanderAtLeisureSite, 20));
        this.stateMachine.addTransition(new TickingTransition<WanderState>(WanderState.READ_A_BOOK, () -> true, this::readABook, 20));
    }

    private WanderState readABook() {
        if (this.leisureSite == null) {
            this.walkTo = null;
            return WanderState.IDLE;
        }
        if (this.walkTo != null) {
            if (!this.citizen.isWorkerAtSiteWithMove(this.walkTo, 3)) {
                return WanderState.READ_A_BOOK;
            }
            if (this.citizen.m_217043_().m_188503_(100) < 5) {
                this.citizen.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                this.walkTo = null;
                this.leisureSite = null;
                this.citizen.getCitizenData().getCitizenSkillHandler().tryLevelUpIntelligence(this.citizen.getCitizenData().getRandom(), 8.0, this.citizen.getCitizenData());
                return WanderState.IDLE;
            }
            this.citizen.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42517_));
            return WanderState.READ_A_BOOK;
        }
        BlockEntity blockEntity = this.citizen.f_19853_.m_7702_(this.leisureSite);
        if (blockEntity instanceof TileEntityColonyBuilding && ((TileEntityColonyBuilding)blockEntity).getBuilding() instanceof BuildingLibrary) {
            this.walkTo = ((BuildingLibrary)((TileEntityColonyBuilding)blockEntity).getBuilding()).getRandomBookShelf();
        }
        return WanderState.READ_A_BOOK;
    }

    private WanderState goToLeisureSite() {
        if (this.leisureSite == null) {
            this.walkTo = null;
            return WanderState.IDLE;
        }
        if (!this.citizen.isWorkerAtSiteWithMove(this.leisureSite, 3)) {
            return WanderState.GO_TO_LEISURE_SITE;
        }
        return WanderState.WANDER_AT_LEISURE_SITE;
    }

    private WanderState wanderAtLeisureSite() {
        if (this.leisureSite == null || this.citizen.m_217043_().m_188503_(300) < 1) {
            this.leisureSite = null;
            this.walkTo = null;
            return WanderState.IDLE;
        }
        if (this.walkTo != null && !this.citizen.isWorkerAtSiteWithMove(this.walkTo, 3)) {
            return WanderState.WANDER_AT_LEISURE_SITE;
        }
        if (this.citizen.m_20159_()) {
            return WanderState.WANDER_AT_LEISURE_SITE;
        }
        BlockEntity blockEntity = this.citizen.f_19853_.m_7702_(this.leisureSite);
        if (blockEntity instanceof IBlueprintDataProviderBE) {
            if (this.walkTo == null && this.citizen.m_217043_().m_188499_()) {
                this.citizen.getNavigation().moveToRandomPos(10, 0.6, (Tuple<BlockPos, BlockPos>)((IBlueprintDataProviderBE)blockEntity).getInWorldCorners(), AbstractAdvancedPathNavigate.RestrictionType.XYZ);
            }
            if (this.walkTo == null && blockEntity instanceof TileEntityColonyBuilding && ((TileEntityColonyBuilding)blockEntity).getBuilding() instanceof BuildingLibrary && this.citizen.m_217043_().m_188503_(100) < 5) {
                return WanderState.READ_A_BOOK;
            }
            if (this.walkTo == null) {
                Map map = ((IBlueprintDataProviderBE)blockEntity).getWorldTagNamePosMap();
                ArrayList sittingPos = new ArrayList(map.getOrDefault("sit", Collections.emptySet()));
                if (!sittingPos.isEmpty()) {
                    this.walkTo = (BlockPos)sittingPos.get(this.citizen.m_217043_().m_188503_(sittingPos.size()));
                    return WanderState.WANDER_AT_LEISURE_SITE;
                }
            } else {
                SittingEntity.sitDown(this.walkTo, (Mob)this.citizen, 1200);
                this.walkTo = null;
            }
            return WanderState.WANDER_AT_LEISURE_SITE;
        }
        return WanderState.IDLE;
    }

    private WanderState decide() {
        int randomBit = this.citizen.m_217043_().m_188503_(100);
        if (randomBit < 5) {
            this.leisureSite = this.citizen.getCitizenColonyHandler().getColony().getBuildingManager().getRandomLeisureSite();
            if (this.leisureSite != null) {
                return WanderState.GO_TO_LEISURE_SITE;
            }
        }
        this.citizen.getNavigation().moveToRandomPos(10.0, this.speed);
        return WanderState.IDLE;
    }

    public boolean m_8036_() {
        if (this.citizen.getDesiredActivity() == DesiredActivity.SLEEP) {
            return false;
        }
        return this.citizen.getDesiredActivity() != DesiredActivity.SLEEP && this.citizen.getNavigation().m_26571_() && !this.citizen.m_6162_() && !(this.citizen.getCitizenData().getJob() instanceof AbstractJobGuard);
    }

    public void m_8037_() {
        this.stateMachine.tick();
    }

    public boolean m_8045_() {
        return !this.citizen.getNavigation().m_26571_() || this.stateMachine.getState() != WanderState.IDLE;
    }

    public void m_8041_() {
        this.stateMachine.reset();
        this.citizen.getCitizenData().setVisibleStatus(null);
    }

    public static enum WanderState implements IState
    {
        IDLE,
        GO_TO_LEISURE_SITE,
        WANDER_AT_LEISURE_SITE,
        READ_A_BOOK;

    }
}

