/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.trainingcamps;

import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingCombatAcademy;
import com.minecolonies.coremod.colony.jobs.JobCombatTraining;
import com.minecolonies.coremod.entity.ai.citizen.trainingcamps.AbstractEntityAITraining;
import com.minecolonies.coremod.util.NamedDamageSource;
import com.minecolonies.coremod.util.WorkerUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Items;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EntityAICombatTraining
extends AbstractEntityAITraining<JobCombatTraining, BuildingCombatAcademy> {
    private static final int ACTIONS_PER_BUILDING_LEVEL = 5;
    private static final double XP_BASE_RATE = 2.0;
    private static final int PARTNER_TRAINING_CHANCE = 25;
    private static final int TRAININGS_DELAY = 60;
    private static final int MIN_DISTANCE_TO_TRAIN = 5;
    private BlockPos currentCombatTarget;
    private AbstractEntityCitizen trainingPartner;
    private int targetCounter;

    public EntityAICombatTraining(@NotNull JobCombatTraining job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.COMBAT_TRAINING, this::decideOnTrainingType, 20), new AITarget((IAIState)AIWorkerState.FIND_TRAINING_PARTNER, this::findTrainingPartner, 20), new AITarget((IAIState)AIWorkerState.KNIGHT_TRAIN_WITH_PARTNER, this::trainWithPartner, 20), new AITarget((IAIState)AIWorkerState.FIND_DUMMY_PARTNER, this::findDummyPartner, 20), new AITarget((IAIState)AIWorkerState.KNIGHT_ATTACK_DUMMY, this::attackDummy, 20), new AITarget((IAIState)AIWorkerState.KNIGHT_ATTACK_PROTECT, this::attack, 60));
    }

    private IAIState decideOnTrainingType() {
        if (((BuildingCombatAcademy)this.building).hasCombatPartner(this.worker) || this.worker.m_217043_().m_188503_(100) < 25) {
            return AIWorkerState.FIND_TRAINING_PARTNER;
        }
        return AIWorkerState.FIND_DUMMY_PARTNER;
    }

    @Override
    public IAIState decide() {
        if (((BuildingCombatAcademy)this.building).hasCombatPartner(this.worker)) {
            return AIWorkerState.KNIGHT_TRAIN_WITH_PARTNER;
        }
        return super.decide();
    }

    private IAIState findTrainingPartner() {
        BuildingCombatAcademy academy = (BuildingCombatAcademy)this.building;
        this.trainingPartner = academy.hasCombatPartner(this.worker) ? academy.getCombatPartner(this.worker) : academy.getRandomCombatPartner(this.worker);
        if (this.trainingPartner == null) {
            return AIWorkerState.COMBAT_TRAINING;
        }
        return AIWorkerState.KNIGHT_TRAIN_WITH_PARTNER;
    }

    private IAIState trainWithPartner() {
        if (this.trainingPartner == null || !this.getModuleForJob().getAssignedCitizen().contains(this.trainingPartner.getCitizenData())) {
            this.trainingPartner = null;
            return AIWorkerState.COMBAT_TRAINING;
        }
        if (BlockPosUtil.getDistance2D(this.worker.m_20183_(), this.trainingPartner.m_20183_()) > 5L && this.walkToBlock(this.trainingPartner.m_20183_())) {
            return AIWorkerState.KNIGHT_TRAIN_WITH_PARTNER;
        }
        return AIWorkerState.KNIGHT_ATTACK_PROTECT;
    }

    private IAIState attack() {
        if (this.trainingPartner == null) {
            return AIWorkerState.START_WORKING;
        }
        if (BlockPosUtil.getDistance2D(this.worker.m_20183_(), this.trainingPartner.m_20183_()) > 5L) {
            this.currentPathingTarget = this.trainingPartner.m_20183_();
            this.stateAfterPathing = AIWorkerState.KNIGHT_TRAIN_WITH_PARTNER;
            return AIWorkerState.GO_TO_TARGET;
        }
        if (this.currentAttackDelay <= 0) {
            this.worker.getCitizenExperienceHandler().addExperience(2.0);
            this.worker.decreaseSaturationForAction();
            this.worker.m_21391_((Entity)this.trainingPartner, 180.0f, 180.0f);
            WorkerUtil.faceBlock(this.trainingPartner.m_20183_().m_7494_(), this.worker);
            this.worker.m_5810_();
            if (this.worker.m_217043_().m_188499_()) {
                int shieldSlot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.getInventory(), Items.f_42740_);
                if (shieldSlot != -1) {
                    this.worker.m_5496_(SoundEvents.f_12346_, 1.0f, (float)SoundUtils.getRandomPitch(this.worker.m_217043_()));
                    this.worker.getCitizenItemHandler().setHeldItem(InteractionHand.OFF_HAND, shieldSlot);
                    this.worker.m_6672_(InteractionHand.OFF_HAND);
                    this.worker.m_21563_().m_24960_((Entity)this.trainingPartner, 180.0f, 180.0f);
                }
            } else {
                this.worker.m_6674_(InteractionHand.MAIN_HAND);
                this.worker.m_5496_(SoundEvents.f_12317_, 1.0f, (float)SoundUtils.getRandomPitch(this.worker.m_217043_()));
                this.trainingPartner.m_6469_((DamageSource)new NamedDamageSource("death.attack.entity.minecolonies.training", (Entity)this.worker), 0.0f);
                this.worker.getCitizenItemHandler().damageItemInHand(InteractionHand.MAIN_HAND, 1);
            }
            this.worker.getNavigation().moveAwayFromXYZ(this.trainingPartner.m_20183_(), 4.0, 1.0, true);
            ++this.targetCounter;
            if (this.targetCounter > ((BuildingCombatAcademy)this.building).getBuildingLevel() * 5) {
                ((BuildingCombatAcademy)this.building).resetPartner(this.worker);
                this.targetCounter = 0;
                return AIWorkerState.START_WORKING;
            }
        } else {
            this.reduceAttackDelay();
            return AIWorkerState.KNIGHT_ATTACK_PROTECT;
        }
        this.currentAttackDelay = 60;
        return AIWorkerState.KNIGHT_ATTACK_PROTECT;
    }

    private IAIState findDummyPartner() {
        BuildingCombatAcademy academy = (BuildingCombatAcademy)this.building;
        if (this.targetCounter >= academy.getBuildingLevel() * 5) {
            this.worker.m_5810_();
            this.targetCounter = 0;
            return AIWorkerState.DECIDE;
        }
        if (((BuildingCombatAcademy)this.building).hasCombatPartner(this.worker)) {
            return AIWorkerState.KNIGHT_TRAIN_WITH_PARTNER;
        }
        BlockPos targetPos = academy.getRandomCombatTarget(this.worker.m_217043_());
        if (targetPos == null) {
            this.worker.m_5810_();
            return AIWorkerState.DECIDE;
        }
        this.currentCombatTarget = targetPos;
        ++this.targetCounter;
        this.currentPathingTarget = targetPos;
        this.stateAfterPathing = AIWorkerState.KNIGHT_ATTACK_DUMMY;
        return AIWorkerState.GO_TO_TARGET;
    }

    private IAIState attackDummy() {
        if (this.currentCombatTarget == null) {
            return AIWorkerState.START_WORKING;
        }
        if (this.currentAttackDelay <= 0) {
            this.worker.getCitizenExperienceHandler().addExperience(2.0);
            this.worker.decreaseSaturationForAction();
            WorkerUtil.faceBlock(this.currentCombatTarget, this.worker);
            this.worker.m_5810_();
            if (this.worker.m_217043_().m_188499_()) {
                int shieldSlot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.getInventory(), Items.f_42740_);
                if (shieldSlot != -1) {
                    this.worker.m_5496_(SoundEvents.f_12346_, 1.0f, (float)SoundUtils.getRandomPitch(this.worker.m_217043_()));
                    this.worker.getCitizenItemHandler().setHeldItem(InteractionHand.OFF_HAND, shieldSlot);
                    this.worker.m_6672_(InteractionHand.OFF_HAND);
                }
            } else {
                this.worker.m_6674_(InteractionHand.MAIN_HAND);
                this.worker.m_5496_(SoundEvents.f_12317_, 1.0f, (float)SoundUtils.getRandomPitch(this.worker.m_217043_()));
                this.worker.getCitizenItemHandler().damageItemInHand(InteractionHand.MAIN_HAND, 1);
            }
        } else {
            this.reduceAttackDelay();
            return AIWorkerState.KNIGHT_ATTACK_DUMMY;
        }
        this.currentAttackDelay = 60;
        return AIWorkerState.FIND_DUMMY_PARTNER;
    }

    @Override
    protected boolean isSetup() {
        if (this.checkForToolOrWeapon(ToolType.SWORD)) {
            return false;
        }
        if (this.checkForToolOrWeapon(ToolType.SHIELD)) {
            return false;
        }
        int weaponSlot = InventoryUtils.getFirstSlotOfItemHandlerContainingTool((IItemHandler)this.getInventory(), ToolType.SWORD, 0, ((BuildingCombatAcademy)this.building).getMaxToolLevel());
        if (weaponSlot != -1) {
            this.worker.getCitizenItemHandler().setHeldItem(InteractionHand.MAIN_HAND, weaponSlot);
        }
        return true;
    }

    @Override
    public Class<BuildingCombatAcademy> getExpectedBuildingClass() {
        return BuildingCombatAcademy.class;
    }
}

