/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.herders;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingCowboy;
import com.minecolonies.coremod.colony.jobs.JobCowboy;
import com.minecolonies.coremod.entity.ai.citizen.herders.AbstractEntityAIHerder;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EntityAIWorkCowboy
extends AbstractEntityAIHerder<JobCowboy, BuildingCowboy, Cow> {
    private static final int MAX_ANIMALS_PER_LEVEL = 2;
    public static final String RENDER_META_BUCKET = "bucket";
    private static final VisibleCitizenStatus HERD_COW = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/work/cowboy.png"), "com.minecolonies.gui.visiblestatus.cowboy");

    public EntityAIWorkCowboy(@NotNull JobCowboy job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.COWBOY_MILK, this::milkCows, 1));
    }

    @Override
    protected void updateRenderMetaData() {
        Object renderMeta;
        Object object = renderMeta = this.getState() == AIWorkerState.IDLE ? "" : "working";
        if (this.worker.getCitizenInventoryHandler().hasItemInInventory(Items.f_42446_)) {
            renderMeta = (String)renderMeta + RENDER_META_BUCKET;
        }
        this.worker.setRenderMetadata((String)renderMeta);
    }

    @Override
    public Class<BuildingCowboy> getExpectedBuildingClass() {
        return BuildingCowboy.class;
    }

    @Override
    public ItemStack getBreedingItem() {
        ItemStack stack = new ItemStack((ItemLike)Items.f_42405_);
        stack.m_41764_(2);
        return stack;
    }

    @Override
    public int getMaxAnimalMultiplier() {
        return 2;
    }

    @Override
    public Class<Cow> getAnimalClass() {
        return Cow.class;
    }

    @Override
    public IAIState decideWhatToDo() {
        IAIState result = super.decideWhatToDo();
        boolean hasBucket = InventoryUtils.hasItemInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), Items.f_42446_);
        if (this.building != null && ((BuildingCowboy)this.building).getSetting(BuildingCowboy.MILKING).getValue() && result.equals(AIWorkerState.START_WORKING) && hasBucket) {
            return AIWorkerState.COWBOY_MILK;
        }
        return result;
    }

    @Override
    @NotNull
    public List<ItemStack> getExtraItemsNeeded() {
        List<ItemStack> list = super.getExtraItemsNeeded();
        if (((BuildingCowboy)this.building).getSetting(BuildingCowboy.MILKING).getValue()) {
            list.add(new ItemStack((ItemLike)Items.f_42446_));
        }
        return list;
    }

    private IAIState milkCows() {
        Cow cow;
        this.worker.getCitizenStatusHandler().setLatestStatus(new Component[]{Component.m_237115_((String)"com.minecolonies.coremod.status.cowboy.milking")});
        this.worker.getCitizenData().setVisibleStatus(HERD_COW);
        if (!this.worker.getCitizenInventoryHandler().hasItemInInventory(this.getBreedingItem().m_41720_()) && InventoryUtils.hasBuildingEnoughElseCount((IBuilding)this.building, new ItemStorage(new ItemStack((ItemLike)Items.f_42446_, 1)), 2) > 1) {
            if (!this.walkToBuilding()) {
                this.checkAndTransferFromHut(new ItemStack((ItemLike)Items.f_42446_, 1));
            } else {
                return AIWorkerState.DECIDE;
            }
        }
        if ((cow = (Cow)this.searchForAnimals().stream().findFirst().orElse(null)) == null) {
            return AIWorkerState.DECIDE;
        }
        if (!this.walkingToAnimal((Animal)cow) && this.equipItem(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42446_, 1))) {
            if (InventoryUtils.addItemStackToItemHandler((IItemHandler)this.worker.getInventoryCitizen(), new ItemStack((ItemLike)Items.f_42455_))) {
                this.worker.getCitizenItemHandler().removeHeldItem();
                this.equipItem(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42455_));
                InventoryUtils.tryRemoveStackFromItemHandler((IItemHandler)this.worker.getInventoryCitizen(), new ItemStack((ItemLike)Items.f_42446_, 1));
            }
            this.incrementActionsDoneAndDecSaturation();
            this.worker.getCitizenExperienceHandler().addExperience(1.0);
        }
        return AIWorkerState.DECIDE;
    }

    @Override
    public double getButcheringAttackDamage() {
        return Math.max(1.0, (double)this.getPrimarySkillLevel() / 10.0);
    }

    @Override
    protected IAIState breedAnimals() {
        this.worker.getCitizenData().setVisibleStatus(HERD_COW);
        return super.breedAnimals();
    }

    @Override
    protected IAIState butcherAnimals() {
        this.worker.getCitizenData().setVisibleStatus(HERD_COW);
        return super.butcherAnimals();
    }
}

