/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.concrete;

import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.PublicCrafting;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingConcreteMixer;
import com.minecolonies.coremod.colony.jobs.JobConcreteMixer;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAICrafting;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ConcretePowderBlock;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EntityAIConcreteMixer
extends AbstractEntityAICrafting<JobConcreteMixer, BuildingConcreteMixer> {
    private static final Predicate<ItemStack> CONCRETE = stack -> !stack.m_41619_() && stack.m_41720_() instanceof BlockItem && ((BlockItem)stack.m_41720_()).m_40614_() instanceof ConcretePowderBlock;

    public EntityAIConcreteMixer(@NotNull JobConcreteMixer job) {
        super(job);
    }

    @Override
    public Class<BuildingConcreteMixer> getExpectedBuildingClass() {
        return BuildingConcreteMixer.class;
    }

    @Override
    protected IAIState decide() {
        if (((JobConcreteMixer)this.job).getCurrentTask() == null) {
            return AIWorkerState.START_WORKING;
        }
        if (this.walkTo == null && this.walkToBuilding()) {
            return AIWorkerState.START_WORKING;
        }
        if (((JobConcreteMixer)this.job).getActionsDone() > 0) {
            return this.getState();
        }
        if (this.currentRequest != null && this.currentRecipeStorage != null) {
            return AIWorkerState.QUERY_ITEMS;
        }
        return AIWorkerState.GET_RECIPE;
    }

    @Override
    protected int getExtendedCount(ItemStack primaryOutput) {
        return ((BuildingConcreteMixer)this.building).outputBlockCountInWorld(primaryOutput);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IAIState mixConcrete() {
        BlockPos pos;
        int slot = -1;
        if (this.currentRequest != null && this.currentRecipeStorage != null) {
            ItemStack inputStack = this.currentRecipeStorage.getCleanedInput().get(0).getItemStack();
            if (!CONCRETE.test(inputStack)) return AIWorkerState.START_WORKING;
            slot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.worker.getInventoryCitizen(), s -> ItemStackUtils.compareItemStacksIgnoreStackSize(s, inputStack));
        } else {
            slot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.worker.getInventoryCitizen(), CONCRETE);
        }
        if (slot != -1) {
            ItemStack stack = this.worker.getInventoryCitizen().getStackInSlot(slot);
            Block block = ((BlockItem)stack.m_41720_()).m_40614_();
            BlockPos posToPlace = ((BuildingConcreteMixer)this.building).getBlockToPlace();
            if (posToPlace != null) {
                if (this.walkToBlock(posToPlace)) {
                    this.walkTo = posToPlace;
                    return AIWorkerState.START_WORKING;
                }
                this.walkTo = null;
                if (!InventoryUtils.attemptReduceStackInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), stack, 1)) return AIWorkerState.START_WORKING;
                this.world.m_7731_(posToPlace, block.m_49966_().m_60728_(Direction.DOWN, block.m_49966_(), (LevelAccessor)this.world, posToPlace, posToPlace), 3);
                return AIWorkerState.START_WORKING;
            }
        }
        if ((pos = ((BuildingConcreteMixer)this.building).getBlockToMine()) != null) {
            if (this.walkToBlock(pos)) {
                this.walkTo = pos;
                return AIWorkerState.START_WORKING;
            }
            this.walkTo = null;
            if (!this.mineBlock(pos)) return AIWorkerState.START_WORKING;
            this.resetActionsDone();
            return AIWorkerState.CRAFT;
        }
        if (InventoryUtils.hasItemInItemHandler((IItemHandler)((BuildingConcreteMixer)this.building).getCapability(ForgeCapabilities.ITEM_HANDLER).orElseGet(null), CONCRETE)) {
            this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(CONCRETE, 64);
            return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
        }
        this.incrementActionsDone();
        return AIWorkerState.START_WORKING;
    }

    @Override
    protected IAIState craft() {
        if (this.currentRecipeStorage == null) {
            return AIWorkerState.START_WORKING;
        }
        if (this.currentRequest == null && ((JobConcreteMixer)this.job).getCurrentTask() != null) {
            return AIWorkerState.GET_RECIPE;
        }
        if (this.walkTo == null && this.walkToBuilding()) {
            return this.getState();
        }
        this.currentRequest = ((JobConcreteMixer)this.job).getCurrentTask();
        if (this.currentRequest != null && (this.currentRequest.getState() == RequestState.CANCELLED || this.currentRequest.getState() == RequestState.FAILED)) {
            this.currentRequest = null;
            this.incrementActionsDone(this.getActionRewardForCraftingSuccess());
            this.currentRecipeStorage = null;
            return AIWorkerState.START_WORKING;
        }
        ItemStack concrete = this.currentRecipeStorage.getPrimaryOutput();
        if (concrete.m_41720_() instanceof BlockItem && ((BlockItem)concrete.m_41720_()).m_40614_() instanceof ConcretePowderBlock) {
            return super.craft();
        }
        IAIState mixState = this.mixConcrete();
        if (mixState == this.getState()) {
            this.currentRequest.addDelivery(new ItemStack((ItemLike)concrete.m_41720_(), 1));
            ((JobConcreteMixer)this.job).setCraftCounter(((JobConcreteMixer)this.job).getCraftCounter() + 1);
            if (((JobConcreteMixer)this.job).getCraftCounter() >= ((JobConcreteMixer)this.job).getMaxCraftingCount()) {
                this.incrementActionsDone(this.getActionRewardForCraftingSuccess());
                this.currentRecipeStorage = null;
                this.resetValues();
                if (this.inventoryNeedsDump() && ((JobConcreteMixer)this.job).getMaxCraftingCount() == 0 && ((JobConcreteMixer)this.job).getCraftCounter() == 0 && this.currentRequest != null) {
                    ((JobConcreteMixer)this.job).finishRequest(true);
                    this.worker.getCitizenExperienceHandler().addExperience((double)((PublicCrafting)this.currentRequest.getRequest()).getCount() / 2.0);
                }
            }
        }
        return mixState;
    }
}

