/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.compatibility.jei.transfer;

import com.google.common.collect.ImmutableSet;
import com.minecolonies.api.inventory.container.ContainerCrafting;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.network.messages.server.TransferRecipeCraftingTeachingMessage;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import org.jetbrains.annotations.NotNull;

public class PrivateCraftingTeachingTransferHandler
implements IRecipeTransferHandler<ContainerCrafting, CraftingRecipe> {
    private final IRecipeTransferHandlerHelper handlerHelper;

    public PrivateCraftingTeachingTransferHandler(@NotNull IRecipeTransferHandlerHelper handlerHelper) {
        this.handlerHelper = handlerHelper;
    }

    @NotNull
    public Optional<MenuType<ContainerCrafting>> getMenuType() {
        return Optional.empty();
    }

    @NotNull
    public Class<ContainerCrafting> getContainerClass() {
        return ContainerCrafting.class;
    }

    @NotNull
    public RecipeType<CraftingRecipe> getRecipeType() {
        return RecipeTypes.CRAFTING;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(@NotNull ContainerCrafting craftingGUIBuilding, @NotNull CraftingRecipe recipe, @NotNull IRecipeSlotsView recipeSlots, @NotNull Player player, boolean maxTransfer, boolean doTransfer) {
        ImmutableSet badIndexes;
        HashMap<Integer, ItemStack> guiIngredients = new HashMap<Integer, ItemStack>();
        guiIngredients.put(0, ItemStackUtils.EMPTY);
        guiIngredients.put(1, ItemStackUtils.EMPTY);
        guiIngredients.put(3, ItemStackUtils.EMPTY);
        guiIngredients.put(4, ItemStackUtils.EMPTY);
        if (craftingGUIBuilding.isComplete()) {
            guiIngredients.put(2, ItemStackUtils.EMPTY);
            guiIngredients.put(5, ItemStackUtils.EMPTY);
            guiIngredients.put(6, ItemStackUtils.EMPTY);
            guiIngredients.put(7, ItemStackUtils.EMPTY);
            guiIngredients.put(8, ItemStackUtils.EMPTY);
            badIndexes = ImmutableSet.of();
        } else {
            badIndexes = ImmutableSet.of((Object)2, (Object)5, (Object)6, (Object)7, (Object)8);
        }
        int inputIndex = 0;
        List slots = recipeSlots.getSlotViews(RecipeIngredientRole.INPUT);
        for (IRecipeSlotView slot : slots) {
            if (slot.getAllIngredients().findAny().isPresent()) {
                if (badIndexes.contains(inputIndex)) {
                    MutableComponent tooltipMessage = Component.m_237115_((String)"jei.tooltip.error.recipe.transfer.too.large.player.getInventory()");
                    List<IRecipeSlotView> badSlots = badIndexes.stream().map(index -> (IRecipeSlotView)slots.get((int)index)).toList();
                    return this.handlerHelper.createUserErrorForMissingSlots((Component)tooltipMessage, badSlots);
                }
                guiIngredients.put(inputIndex, slot.getDisplayedIngredient((IIngredientType)VanillaTypes.ITEM_STACK).orElse(ItemStack.f_41583_));
            }
            ++inputIndex;
        }
        if (doTransfer) {
            CraftingContainer craftMatrix = craftingGUIBuilding.getInv();
            if (craftingGUIBuilding.isComplete()) {
                craftMatrix.m_6836_(0, (ItemStack)guiIngredients.get(0));
                craftMatrix.m_6836_(1, (ItemStack)guiIngredients.get(1));
                craftMatrix.m_6836_(2, (ItemStack)guiIngredients.get(2));
                craftMatrix.m_6836_(3, (ItemStack)guiIngredients.get(3));
                craftMatrix.m_6836_(4, (ItemStack)guiIngredients.get(4));
                craftMatrix.m_6836_(5, (ItemStack)guiIngredients.get(5));
                craftMatrix.m_6836_(6, (ItemStack)guiIngredients.get(6));
                craftMatrix.m_6836_(7, (ItemStack)guiIngredients.get(7));
                craftMatrix.m_6836_(8, (ItemStack)guiIngredients.get(8));
            } else {
                craftMatrix.m_6836_(0, (ItemStack)guiIngredients.get(0));
                craftMatrix.m_6836_(1, (ItemStack)guiIngredients.get(1));
                craftMatrix.m_6836_(2, (ItemStack)guiIngredients.get(3));
                craftMatrix.m_6836_(3, (ItemStack)guiIngredients.get(4));
            }
            TransferRecipeCraftingTeachingMessage message = new TransferRecipeCraftingTeachingMessage(guiIngredients, craftingGUIBuilding.isComplete());
            Network.getNetwork().sendToServer(message);
        }
        return null;
    }
}

