/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.compatibility.jei;

import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.registry.CraftingType;
import com.minecolonies.api.util.constant.IToolType;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.colony.buildings.modules.AnimalHerdingModule;
import com.minecolonies.coremod.colony.crafting.LootTableAnalyzer;
import com.minecolonies.coremod.compatibility.jei.JobBasedRecipeCategory;
import com.minecolonies.coremod.compatibility.jei.RenderHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class HerderRecipeCategory
extends JobBasedRecipeCategory<HerdingRecipe> {
    private final AnimalHerdingModule herding;
    private final ITickTimer animalTimer;
    private static final int LOOT_SLOTS_X = 53;
    private static final int LOOT_SLOTS_W = 114;
    private static final int ANIMAL_W = 60;
    private static final int ANIMAL_H = 61;
    private static final int ANIMAL_X = 78;
    private static final int ANIMAL_Y = 26;

    public HerderRecipeCategory(@NotNull BuildingEntry building, @NotNull IJob<?> job, @NotNull AnimalHerdingModule herding, @NotNull IGuiHelper guiHelper) {
        super(job, HerderRecipeCategory.createRecipeType(job), HerderRecipeCategory.getCatalyst(building), guiHelper);
        this.herding = herding;
        this.animalTimer = guiHelper.createTickTimer(200, 359, false);
    }

    @NotNull
    private static RecipeType<HerdingRecipe> createRecipeType(@NotNull IJob<?> job) {
        ResourceLocation uid = job.getJobRegistryEntry().getKey();
        return RecipeType.create((String)uid.m_135827_(), (String)uid.m_135815_(), HerdingRecipe.class);
    }

    @Override
    @NotNull
    protected List<Component> generateInfoBlocks(@NotNull HerdingRecipe recipe) {
        return Collections.emptyList();
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull HerdingRecipe recipe, @NotNull IFocusGroup focuses) {
        this.addToolSlot(builder, recipe.getRequiredTool(), 149, 46, true);
        builder.addSlot(RecipeIngredientRole.INPUT, 51, 46).setBackground((IDrawable)this.slot, -1, -1).addItemStacks(recipe.getBreedingItems());
        if (!recipe.getDrops().isEmpty()) {
            int startX;
            int initialColumns = 114 / this.slot.getWidth();
            int rows = (recipe.getDrops().size() + initialColumns - 1) / initialColumns;
            int columns = (recipe.getDrops().size() + rows - 1) / rows;
            int x = startX = 53 + (114 - columns * this.slot.getWidth()) / 2;
            int y = 117 - rows * this.slot.getHeight() + 1;
            int c = 0;
            for (LootTableAnalyzer.LootDrop drop : recipe.getDrops()) {
                ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, x, y).setBackground((IDrawable)this.chanceSlot, -1, -1).addItemStacks(drop.getItemStacks())).addTooltipCallback((IRecipeSlotTooltipCallback)new JobBasedRecipeCategory.LootTableTooltipCallback(drop, recipe.getId()));
                if (++c >= columns) {
                    c = 0;
                    x = startX;
                    y += this.slot.getHeight();
                    continue;
                }
                x += this.slot.getWidth();
            }
        }
    }

    @Override
    public void draw(@NotNull HerdingRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull PoseStack stack, double mouseX, double mouseY) {
        super.draw(recipe, recipeSlotsView, stack, mouseX, mouseY);
        LivingEntity animal = recipe.getAnimal();
        if (animal != null) {
            float scale = 25.416666f;
            int animal_cx = 108;
            int animal_cy = 56;
            int animal_by = 87;
            int offsetY = 16;
            float yaw = this.animalTimer.getValue();
            float headYaw = (float)Math.atan((108.0 - mouseX) / 40.0) * 40.0f + yaw;
            float pitch = (float)Math.atan((40.0 - mouseY) / 40.0) * 20.0f;
            RenderHelper.scissor(stack, 78, 26, 60, 61);
            RenderHelper.renderEntity(stack, 108, 71, 25.41666603088379, headYaw, yaw, pitch, animal);
            RenderHelper.stopScissor();
        }
    }

    @Override
    @NotNull
    public List<HerdingRecipe> findRecipes(@NotNull Map<CraftingType, List<IGenericRecipe>> vanilla) {
        List<ItemStack> breedingItems = this.herding.getBreedingItems();
        List<LootTableAnalyzer.LootDrop> drops = this.herding.getExpectedLoot();
        drops.sort(Comparator.comparing(LootTableAnalyzer.LootDrop::getProbability).reversed());
        HerdingRecipe recipe = new HerdingRecipe(this.herding.getDefaultLootTable(), this.herding.getAnimalType(), breedingItems, drops);
        return Collections.singletonList(recipe);
    }

    public static class HerdingRecipe {
        @NotNull
        private final ResourceLocation id;
        @Nullable
        private final LivingEntity animal;
        @NotNull
        private final List<ItemStack> breedingItems;
        @NotNull
        private final List<LootTableAnalyzer.LootDrop> drops;

        public HerdingRecipe(@NotNull ResourceLocation id, @NotNull EntityType<?> animalType, @NotNull List<ItemStack> breedingItems, @NotNull List<LootTableAnalyzer.LootDrop> drops) {
            this.id = id;
            this.animal = (LivingEntity)animalType.m_20615_((Level)Minecraft.m_91087_().f_91073_);
            this.breedingItems = breedingItems;
            this.drops = drops.size() > 18 ? LootTableAnalyzer.consolidate(drops) : drops;
        }

        @NotNull
        public ResourceLocation getId() {
            return this.id;
        }

        @Nullable
        public LivingEntity getAnimal() {
            return this.animal;
        }

        @NotNull
        public List<ItemStack> getBreedingItems() {
            return this.breedingItems;
        }

        @NotNull
        public IToolType getRequiredTool() {
            return ToolType.AXE;
        }

        @NotNull
        public List<LootTableAnalyzer.LootDrop> getDrops() {
            return this.drops;
        }
    }
}

