/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.workorders.IWorkOrder;
import com.minecolonies.api.colony.workorders.WorkOrderType;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.client.gui.huts.WindowHutBuilderModule;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingStructureBuilder;
import com.minecolonies.coremod.colony.buildings.modules.WorkerBuildingModule;
import com.minecolonies.coremod.colony.buildings.modules.settings.BuilderModeSetting;
import com.minecolonies.coremod.colony.buildings.modules.settings.SettingKey;
import com.minecolonies.coremod.colony.buildings.modules.settings.StringSetting;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingBuilderView;
import com.minecolonies.coremod.colony.jobs.JobBuilder;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuilding;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class BuildingBuilder
extends AbstractBuildingStructureBuilder {
    public static final ISettingKey<StringSetting> MODE = new SettingKey<StringSetting>(StringSetting.class, new ResourceLocation("minecolonies", "mode"));
    public static final ISettingKey<BuilderModeSetting> BUILDING_MODE = new SettingKey<BuilderModeSetting>(BuilderModeSetting.class, new ResourceLocation("minecolonies", "buildmode"));
    public static final String MANUAL_SETTING = "com.minecolonies.core.builder.setting.manual";
    public static final String AUTO_SETTING = "com.minecolonies.core.builder.setting.automatic";
    private static final String BUILDER = "builder";
    private boolean purgedMobsToday = false;

    public BuildingBuilder(IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.PICKAXE, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.SHOVEL, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.AXE, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.HOE, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.SHEARS, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return BUILDER;
    }

    @Override
    public void onWakeUp() {
        this.purgedMobsToday = false;
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        this.purgedMobsToday = compound.m_128471_("purgedMobs");
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        compound.m_128379_("purgedMobs", this.purgedMobsToday);
        return compound;
    }

    public void setPurgedMobsToday(boolean purgedMobsToday) {
        this.purgedMobsToday = purgedMobsToday;
    }

    public boolean hasPurgedMobsToday() {
        return this.purgedMobsToday;
    }

    public boolean getManualMode() {
        return this.getSetting(MODE).getValue().equals(MANUAL_SETTING);
    }

    @Override
    public void searchWorkOrder() {
        ICitizenData citizen = this.getFirstModuleOccurance(WorkerBuildingModule.class).getFirstCitizen();
        if (citizen == null) {
            return;
        }
        List<IWorkOrder> list = this.getColony().getWorkManager().getOrderedList(wo -> wo.canBeMadeBy(citizen.getJob()), this.getPosition());
        list.sort((a, b) -> {
            if (a.getWorkOrderType() == WorkOrderType.REMOVE) {
                return -1;
            }
            if (b.getWorkOrderType() == WorkOrderType.REMOVE) {
                return 1;
            }
            return 0;
        });
        IWorkOrder order = list.stream().filter(w -> w.getClaimedBy() != null && w.getClaimedBy().equals((Object)this.getPosition())).findFirst().orElse(null);
        if (order != null) {
            citizen.getJob(JobBuilder.class).setWorkOrder(order);
            order.setClaimedBy(citizen);
            return;
        }
        if (this.getManualMode()) {
            return;
        }
        for (IWorkOrder wo2 : list) {
            double distanceToBuilder = Double.MAX_VALUE;
            if (wo2 instanceof WorkOrderBuilding && wo2.getWorkOrderType() != WorkOrderType.REMOVE && !wo2.canBuild(citizen)) continue;
            for (ICitizenData otherBuilder : this.getColony().getCitizenManager().getCitizens()) {
                double distance;
                JobBuilder job = otherBuilder.getJob(JobBuilder.class);
                if (job == null || otherBuilder.getWorkBuilding() == null || citizen.getId() == otherBuilder.getId() || job.hasWorkOrder() || !(wo2 instanceof WorkOrderBuilding) || !wo2.canBuild(otherBuilder) || !((distance = otherBuilder.getWorkBuilding().getID().m_123331_((Vec3i)wo2.getLocation())) < distanceToBuilder)) continue;
                distanceToBuilder = distance;
            }
            if (!(citizen.getWorkBuilding().getID().m_123331_((Vec3i)wo2.getLocation()) < distanceToBuilder)) continue;
            citizen.getJob(JobBuilder.class).setWorkOrder(wo2);
            wo2.setClaimedBy(citizen);
            return;
        }
    }

    public void setWorkOrder(int orderId) {
        ICitizenData citizen = this.getFirstModuleOccurance(WorkerBuildingModule.class).getFirstCitizen();
        if (citizen == null) {
            return;
        }
        IWorkOrder wo = this.getColony().getWorkManager().getWorkOrder(orderId);
        if (wo == null || wo.getClaimedBy() != null && !wo.getClaimedBy().equals((Object)this.getPosition())) {
            return;
        }
        if (citizen.getJob(JobBuilder.class).hasWorkOrder()) {
            wo.setClaimedBy(citizen);
            this.getColony().getWorkManager().setDirty(true);
            return;
        }
        if (wo.canBeMadeBy(citizen.getJob())) {
            citizen.getJob(JobBuilder.class).setWorkOrder(wo);
            wo.setClaimedBy(citizen);
            this.getColony().getWorkManager().setDirty(true);
            this.markDirty();
        }
    }

    @Override
    public boolean canBeBuiltByBuilder(int newLevel) {
        return this.getBuildingLevel() + 1 == newLevel;
    }

    @Override
    public boolean canEat(ItemStack stack) {
        if (this.requiresResourceForBuilding(stack)) {
            return false;
        }
        return super.canEat(stack);
    }

    public static class View
    extends AbstractBuildingBuilderView {
        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public BOWindow getWindow() {
            return new WindowHutBuilderModule(this);
        }

        @Override
        public boolean allowsAssignment() {
            return true;
        }
    }
}

