/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity.ai.statemachine.tickratestatemachine;

import com.minecolonies.api.entity.ai.statemachine.basestatemachine.BasicStateMachine;
import com.minecolonies.api.entity.ai.statemachine.states.AIBlockingEventType;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickingTransition;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class TickRateStateMachine<S extends IState>
extends BasicStateMachine<ITickingTransition<S>, S>
implements ITickRateStateMachine<S> {
    private int tickCounter = 0;
    private int tickRate = 1;
    private int tickRateCounter = 0;
    private final List<ITickingTransition<S>> aiBlockingTransitions = new ArrayList<ITickingTransition<S>>();
    private final List<ITickingTransition<S>> stateBlockingTransitions;
    private final List<ITickingTransition<S>> eventTransitions;

    public TickRateStateMachine(@NotNull S initialState, @NotNull Consumer<RuntimeException> exceptionHandler) {
        super(initialState, exceptionHandler);
        this.eventTransitionMap.put(AIBlockingEventType.AI_BLOCKING, this.aiBlockingTransitions);
        this.stateBlockingTransitions = new ArrayList<ITickingTransition<S>>();
        this.eventTransitionMap.put(AIBlockingEventType.STATE_BLOCKING, this.stateBlockingTransitions);
        this.eventTransitions = new ArrayList<ITickingTransition<S>>();
        this.eventTransitionMap.put(AIBlockingEventType.EVENT, this.eventTransitions);
    }

    @Override
    public void tick() {
        ++this.tickRateCounter;
        if (this.tickRateCounter < this.tickRate) {
            return;
        }
        this.tickRateCounter = 0;
        ++this.tickCounter;
        if (this.tickCounter > 500) {
            this.tickCounter = 1;
        }
        for (ITickingTransition<Object> transition : this.aiBlockingTransitions) {
            if (!this.checkTransition(transition)) continue;
            return;
        }
        for (ITickingTransition<Object> transition : this.eventTransitions) {
            if (!this.checkTransition(transition)) continue;
            return;
        }
        for (ITickingTransition<Object> transition : this.stateBlockingTransitions) {
            if (!this.checkTransition(transition)) continue;
            return;
        }
        for (ITickingTransition<Object> transition : this.currentStateTransitions) {
            if (!this.checkTransition(transition)) continue;
            return;
        }
    }

    @Override
    public boolean checkTransition(@NotNull ITickingTransition<S> transition) {
        if (this.tickCounter % transition.getTickRate() != transition.getTickOffset()) {
            return false;
        }
        return super.checkTransition(transition);
    }

    @Override
    public int getTickRate() {
        return this.tickRate;
    }

    @Override
    public void setTickRate(int tickRate) {
        this.tickRate = tickRate;
        this.tickRateCounter = new Random().nextInt(tickRate);
    }
}

