/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.shader;

import codechicken.lib.render.shader.ICCUniform;
import codechicken.lib.render.shader.UniformType;
import com.mojang.blaze3d.shaders.Shader;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL21;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL40;
import org.lwjgl.system.MemoryUtil;

public abstract class CCUniform
extends Uniform
implements ICCUniform {
    protected final UniformType f_85587_;

    protected CCUniform(String name, UniformType type, int count, @Nullable Shader parent) {
        super(name, type.getVanillaType(), count, parent);
        this.f_85587_ = type;
        if (this.f_85588_ != null) {
            MemoryUtil.memFree((Buffer)this.f_85588_);
            this.f_85588_ = null;
        }
        if (this.f_85589_ != null) {
            MemoryUtil.memFree((Buffer)this.f_85589_);
            this.f_85589_ = null;
        }
    }

    static CCUniform makeUniform(String name, UniformType type, @Nullable Shader parent) {
        return switch (type.getCarrier()) {
            default -> throw new IncompatibleClassChangeError();
            case UniformType.Carrier.INT, UniformType.Carrier.U_INT -> new IntUniform(name, type, type.getSize(), parent);
            case UniformType.Carrier.FLOAT, UniformType.Carrier.MATRIX -> new FloatUniform(name, type, type.getSize(), parent);
            case UniformType.Carrier.DOUBLE, UniformType.Carrier.D_MATRIX -> new DoubleUniform(name, type, type.getSize(), parent);
        };
    }

    public IntBuffer m_166760_() {
        throw new NotImplementedException("TODO");
    }

    public FloatBuffer m_166761_() {
        throw new NotImplementedException("TODO");
    }

    private static class IntUniform
    extends UniformEntry<int[]> {
        public IntUniform(String name, UniformType type, int count, @Nullable Shader parent) {
            super(name, type, count, parent);
            assert (type.getCarrier() == UniformType.Carrier.INT || type.getCarrier() == UniformType.Carrier.U_INT);
        }

        @Override
        public void flush() {
            assert (this.cache != null);
            block0 : switch (this.f_85587_.getCarrier()) {
                case INT: {
                    switch (this.f_85587_.getSize()) {
                        case 1: {
                            GL20.glUniform1i((int)this.m_166752_(), (int)((int[])this.cache)[0]);
                            break block0;
                        }
                        case 2: {
                            GL20.glUniform2i((int)this.m_166752_(), (int)((int[])this.cache)[0], (int)((int[])this.cache)[1]);
                            break block0;
                        }
                        case 3: {
                            GL20.glUniform3i((int)this.m_166752_(), (int)((int[])this.cache)[0], (int)((int[])this.cache)[1], (int)((int[])this.cache)[2]);
                            break block0;
                        }
                        case 4: {
                            GL20.glUniform4i((int)this.m_166752_(), (int)((int[])this.cache)[0], (int)((int[])this.cache)[1], (int)((int[])this.cache)[2], (int)((int[])this.cache)[3]);
                            break block0;
                        }
                    }
                    throw new IllegalStateException("Invalid size for Int type." + this.f_85587_.getSize());
                }
                case U_INT: {
                    switch (this.f_85587_.getSize()) {
                        case 1: {
                            GL30.glUniform1ui((int)this.m_166752_(), (int)((int[])this.cache)[0]);
                            break block0;
                        }
                        case 2: {
                            GL30.glUniform2ui((int)this.m_166752_(), (int)((int[])this.cache)[0], (int)((int[])this.cache)[1]);
                            break block0;
                        }
                        case 3: {
                            GL30.glUniform3ui((int)this.m_166752_(), (int)((int[])this.cache)[0], (int)((int[])this.cache)[1], (int)((int[])this.cache)[2]);
                            break block0;
                        }
                        case 4: {
                            GL30.glUniform4ui((int)this.m_166752_(), (int)((int[])this.cache)[0], (int)((int[])this.cache)[1], (int)((int[])this.cache)[2], (int)((int[])this.cache)[3]);
                            break block0;
                        }
                    }
                    throw new IllegalStateException("Invalid size for Int type." + this.f_85587_.getSize());
                }
                default: {
                    throw new IllegalStateException("Invalid type for IntUniform: " + this.f_85587_.getCarrier());
                }
            }
        }

        @Override
        public int[] make(int len) {
            return new int[len];
        }

        @Override
        public int len(int[] cache) {
            return cache.length;
        }

        @Override
        public boolean equals(int @Nullable [] a, int[] b) {
            return Arrays.equals(a, b);
        }
    }

    private static class FloatUniform
    extends UniformEntry<float[]> {
        public FloatUniform(String name, UniformType type, int count, @Nullable Shader parent) {
            super(name, type, count, parent);
            assert (type.getCarrier() == UniformType.Carrier.FLOAT || type.getCarrier() == UniformType.Carrier.MATRIX);
        }

        @Override
        public void flush() {
            assert (this.cache != null);
            block0 : switch (this.f_85587_.getCarrier()) {
                case FLOAT: {
                    switch (this.f_85587_.getSize()) {
                        case 1: {
                            GL20.glUniform1f((int)this.m_166752_(), (float)((float[])this.cache)[0]);
                            break block0;
                        }
                        case 2: {
                            GL20.glUniform2f((int)this.m_166752_(), (float)((float[])this.cache)[0], (float)((float[])this.cache)[1]);
                            break block0;
                        }
                        case 3: {
                            GL20.glUniform3f((int)this.m_166752_(), (float)((float[])this.cache)[0], (float)((float[])this.cache)[1], (float)((float[])this.cache)[2]);
                            break block0;
                        }
                        case 4: {
                            GL20.glUniform4f((int)this.m_166752_(), (float)((float[])this.cache)[0], (float)((float[])this.cache)[1], (float)((float[])this.cache)[2], (float)((float[])this.cache)[3]);
                            break block0;
                        }
                    }
                    throw new IllegalStateException("Invalid size for Float type." + this.f_85587_.getSize());
                }
                case MATRIX: {
                    switch (this.f_85587_) {
                        case MAT2: {
                            GL20.glUniformMatrix2fv((int)this.m_166752_(), (boolean)this.transpose, (float[])((float[])this.cache));
                            break block0;
                        }
                        case MAT3: {
                            GL20.glUniformMatrix3fv((int)this.m_166752_(), (boolean)this.transpose, (float[])((float[])this.cache));
                            break block0;
                        }
                        case MAT4: {
                            GL20.glUniformMatrix4fv((int)this.m_166752_(), (boolean)this.transpose, (float[])((float[])this.cache));
                            break block0;
                        }
                        case MAT2x3: {
                            GL21.glUniformMatrix2x3fv((int)this.m_166752_(), (boolean)this.transpose, (float[])((float[])this.cache));
                            break block0;
                        }
                        case MAT2x4: {
                            GL21.glUniformMatrix2x4fv((int)this.m_166752_(), (boolean)this.transpose, (float[])((float[])this.cache));
                            break block0;
                        }
                        case MAT3x2: {
                            GL21.glUniformMatrix3x2fv((int)this.m_166752_(), (boolean)this.transpose, (float[])((float[])this.cache));
                            break block0;
                        }
                        case MAT3x4: {
                            GL21.glUniformMatrix3x4fv((int)this.m_166752_(), (boolean)this.transpose, (float[])((float[])this.cache));
                            break block0;
                        }
                        case MAT4x2: {
                            GL21.glUniformMatrix4x2fv((int)this.m_166752_(), (boolean)this.transpose, (float[])((float[])this.cache));
                            break block0;
                        }
                        case MAT4x3: {
                            GL21.glUniformMatrix4x3fv((int)this.m_166752_(), (boolean)this.transpose, (float[])((float[])this.cache));
                            break block0;
                        }
                    }
                    throw new IllegalStateException("Invalid Matrix type: " + this.f_85587_);
                }
                default: {
                    throw new IllegalStateException("Invalid type for FloatUniform: " + this.f_85587_.getCarrier());
                }
            }
        }

        @Override
        public float[] make(int len) {
            return new float[len];
        }

        @Override
        public int len(float[] cache) {
            return cache.length;
        }

        @Override
        public boolean equals(float @Nullable [] a, float[] b) {
            return Arrays.equals(a, b);
        }
    }

    private static class DoubleUniform
    extends UniformEntry<double[]> {
        public DoubleUniform(String name, UniformType type, int count, @Nullable Shader parent) {
            super(name, type, count, parent);
            assert (type.getCarrier() == UniformType.Carrier.DOUBLE || type.getCarrier() == UniformType.Carrier.D_MATRIX);
        }

        @Override
        public void flush() {
            assert (this.cache != null);
            block0 : switch (this.f_85587_.getCarrier()) {
                case DOUBLE: {
                    switch (this.f_85587_.getSize()) {
                        case 1: {
                            GL40.glUniform1d((int)this.m_166752_(), (double)((double[])this.cache)[0]);
                            break block0;
                        }
                        case 2: {
                            GL40.glUniform2d((int)this.m_166752_(), (double)((double[])this.cache)[0], (double)((double[])this.cache)[1]);
                            break block0;
                        }
                        case 3: {
                            GL40.glUniform3d((int)this.m_166752_(), (double)((double[])this.cache)[0], (double)((double[])this.cache)[1], (double)((double[])this.cache)[2]);
                            break block0;
                        }
                        case 4: {
                            GL40.glUniform4d((int)this.m_166752_(), (double)((double[])this.cache)[0], (double)((double[])this.cache)[1], (double)((double[])this.cache)[2], (double)((double[])this.cache)[3]);
                            break block0;
                        }
                    }
                    throw new IllegalStateException("Invalid size for Double type." + this.f_85587_.getSize());
                }
                case D_MATRIX: {
                    switch (this.f_85587_) {
                        case D_MAT2: {
                            GL40.glUniformMatrix2dv((int)this.m_166752_(), (boolean)this.transpose, (double[])((double[])this.cache));
                            break block0;
                        }
                        case D_MAT3: {
                            GL40.glUniformMatrix3dv((int)this.m_166752_(), (boolean)this.transpose, (double[])((double[])this.cache));
                            break block0;
                        }
                        case D_MAT4: {
                            GL40.glUniformMatrix4dv((int)this.m_166752_(), (boolean)this.transpose, (double[])((double[])this.cache));
                            break block0;
                        }
                        case D_MAT2x3: {
                            GL40.glUniformMatrix2x3dv((int)this.m_166752_(), (boolean)this.transpose, (double[])((double[])this.cache));
                            break block0;
                        }
                        case D_MAT2x4: {
                            GL40.glUniformMatrix2x4dv((int)this.m_166752_(), (boolean)this.transpose, (double[])((double[])this.cache));
                            break block0;
                        }
                        case D_MAT3x2: {
                            GL40.glUniformMatrix3x2dv((int)this.m_166752_(), (boolean)this.transpose, (double[])((double[])this.cache));
                            break block0;
                        }
                        case D_MAT3x4: {
                            GL40.glUniformMatrix3x4dv((int)this.m_166752_(), (boolean)this.transpose, (double[])((double[])this.cache));
                            break block0;
                        }
                        case D_MAT4x2: {
                            GL40.glUniformMatrix4x2dv((int)this.m_166752_(), (boolean)this.transpose, (double[])((double[])this.cache));
                            break block0;
                        }
                        case D_MAT4x3: {
                            GL40.glUniformMatrix4x3dv((int)this.m_166752_(), (boolean)this.transpose, (double[])((double[])this.cache));
                            break block0;
                        }
                    }
                    throw new IllegalStateException("Invalid Matrix type: " + this.f_85587_);
                }
                default: {
                    throw new IllegalStateException("Invalid type for DoubleUniform: " + this.f_85587_.getCarrier());
                }
            }
        }

        @Override
        public double[] make(int len) {
            return new double[len];
        }

        @Override
        public int len(double[] cache) {
            return cache.length;
        }

        @Override
        public boolean equals(double @Nullable [] a, double[] b) {
            return Arrays.equals(a, b);
        }
    }

    private static abstract class UniformEntry<T>
    extends CCUniform {
        @Nullable
        protected T cache;
        protected boolean transpose;

        public UniformEntry(String name, UniformType type, int count, @Nullable Shader parent) {
            super(name, type, count, parent);
        }

        public void m_5985_(float f0) {
            this.glUniformF(false, f0);
        }

        public void m_7971_(float f0, float f1) {
            this.glUniformF(false, f0, f1);
        }

        public void m_166700_(int i, float f) {
            throw new UnsupportedOperationException("Unable to set specific index.");
        }

        public void m_5889_(float f0, float f1, float f2) {
            this.glUniformF(false, f0, f1, f2);
        }

        public void m_142276_(Vector3f vec) {
            this.glUniformF(false, vec.m_122239_(), vec.m_122260_(), vec.m_122269_());
        }

        public void m_5805_(float f0, float f1, float f2, float f3) {
            this.glUniformF(false, f0, f1, f2, f3);
        }

        public void m_142558_(Vector4f vec) {
            this.glUniformF(false, vec.m_123601_(), vec.m_123615_(), vec.m_123616_(), vec.m_123617_());
        }

        public void m_142617_(int i0) {
            this.glUniformI(i0);
        }

        public void m_142326_(int i0, int i1) {
            this.glUniformI(i0, i1);
        }

        public void m_142693_(int i0, int i1, int i2) {
            this.glUniformI(i0, i1, i2);
        }

        public void m_142492_(int i0, int i1, int i2, int i3) {
            this.glUniformI(i0, i1, i2, i3);
        }

        public void m_5941_(float[] p_85632_) {
            this.glUniformF(false, p_85632_);
        }

        public void m_142588_(float m00, float m01, float m10, float m11) {
            this.glUniformF(true, m00, m01, m10, m11);
        }

        public void m_141964_(float m00, float m01, float m02, float m10, float m11, float m12) {
            this.glUniformF(true, m00, m01, m02, m10, m11, m12);
        }

        public void m_142005_(float m00, float m01, float m02, float m03, float m10, float m11, float m12, float m13) {
            this.glUniformF(true, m00, m01, m02, m03, m10, m11, m12, m13);
        }

        public void m_141963_(float m00, float m01, float m10, float m11, float m20, float m21) {
            this.glUniformF(true, m00, m01, m10, m11, m20, m21);
        }

        public void m_142217_(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
            this.glUniformF(true, m00, m01, m02, m10, m11, m12, m20, m21, m22);
        }

        public void m_142604_(float m00, float m01, float m02, float m03, float m10, float m11, float m12, float m13, float m20, float m21, float m22, float m23) {
            this.glUniformF(true, m00, m01, m02, m03, m10, m11, m12, m13, m20, m21, m22, m23);
        }

        public void m_142004_(float m00, float m01, float m10, float m11, float m20, float m21, float m30, float m31) {
            this.glUniformF(true, m00, m01, m10, m11, m20, m21, m30, m31);
        }

        public void m_142605_(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m23, float m30, float m31, float m32) {
            this.glUniformF(true, m00, m01, m02, m10, m11, m12, m20, m21, m23, m30, m31, m32);
        }

        public void m_141978_(float m00, float m01, float m02, float m03, float m10, float m11, float m12, float m13, float m20, float m21, float m22, float m23, float m30, float m31, float m32, float m33) {
            this.glUniformF(true, m00, m01, m02, m03, m10, m11, m12, m13, m20, m21, m22, m23, m30, m31, m32, m33);
        }

        public void m_5679_(Matrix4f mat) {
            this.glUniformMatrix4f(mat);
        }

        public void m_200759_(Matrix3f mat) {
            this.glUniformMatrix3f(mat);
        }

        public void m_5808_(float f0, float f1, float f2, float f3) {
            assert (this.f_85587_.getCarrier() == UniformType.Carrier.FLOAT);
            switch (this.f_85587_.getSize()) {
                case 1: {
                    this.glUniform1f(f0);
                    break;
                }
                case 2: {
                    this.glUniform2f(f0, f1);
                    break;
                }
                case 3: {
                    this.glUniform3f(f0, f1, f2);
                    break;
                }
                case 4: {
                    this.glUniform4f(f0, f1, f2, f3);
                }
            }
            throw new IllegalStateException("Unexpected type size: " + this.f_85587_);
        }

        public void m_7401_(int i0, int i1, int i2, int i3) {
            assert (this.f_85587_.getCarrier() == UniformType.Carrier.INT || this.f_85587_.getCarrier() == UniformType.Carrier.U_INT);
            switch (this.f_85587_.getSize()) {
                case 1: {
                    this.glUniform1i(i0);
                    break;
                }
                case 2: {
                    this.glUniform2i(i0, i1);
                    break;
                }
                case 3: {
                    this.glUniform3i(i0, i1, i2);
                    break;
                }
                case 4: {
                    this.glUniform4i(i0, i1, i2, i3);
                }
            }
            throw new IllegalStateException("Unexpected type size: " + this.f_85587_);
        }

        @Override
        public void glUniformI(int ... values) {
            if (this.f_85587_.getCarrier() != UniformType.Carrier.INT && this.f_85587_.getCarrier() != UniformType.Carrier.U_INT) {
                throw new IllegalArgumentException("Uniform '%s' isn't registered with the carrier of INT or U_INT, Got type '%s' with carrier '%s'.".formatted(new Object[]{this.m_85599_(), this.f_85587_, this.f_85587_.getCarrier()}));
            }
            this.set(values, false);
        }

        @Override
        public void glUniformF(boolean transpose, float ... values) {
            if (this.f_85587_.getCarrier() != UniformType.Carrier.FLOAT && this.f_85587_.getCarrier() != UniformType.Carrier.MATRIX) {
                throw new IllegalArgumentException("Uniform '%s' isn't registered with the carrier of FLOAT or MATRIX, Got type '%s' with carrier '%s'.".formatted(new Object[]{this.m_85599_(), this.f_85587_, this.f_85587_.getCarrier()}));
            }
            this.set(values, transpose);
        }

        @Override
        public void glUniformD(boolean transpose, double ... values) {
            if (this.f_85587_.getCarrier() != UniformType.Carrier.DOUBLE && this.f_85587_.getCarrier() != UniformType.Carrier.D_MATRIX) {
                throw new IllegalArgumentException("Uniform '%s' isn't registered with the carrier of DOUBLE or D_MATRIX, Got type '%s' with carrier '%s'.".formatted(new Object[]{this.m_85599_(), this.f_85587_, this.f_85587_.getCarrier()}));
            }
            this.set(values, transpose);
        }

        public void set(T values, boolean transpose) {
            assert (!transpose || this.f_85587_.getCarrier() == UniformType.Carrier.MATRIX || this.f_85587_.getCarrier() == UniformType.Carrier.D_MATRIX);
            if (this.len(values) != this.f_85587_.getSize()) {
                throw new IllegalArgumentException("Invalid size for uniform '%s', Expected: '%s', Got: '%s'.".formatted(this.m_85599_(), this.f_85587_.getSize(), this.len(values)));
            }
            if (!this.equals(this.cache, values) || this.transpose != transpose) {
                this.cache = values;
                this.transpose = transpose;
                this.f_85591_ = true;
            }
        }

        public void m_85633_() {
            if (!this.f_85591_) {
                return;
            }
            this.flush();
            this.f_85591_ = false;
        }

        public abstract void flush();

        public abstract T make(int var1);

        public abstract int len(T var1);

        public abstract boolean equals(@Nullable T var1, T var2);
    }
}

