/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import twilightforest.advancements.TFAdvancements;
import twilightforest.block.TFChestBlock;
import twilightforest.entity.ai.control.NoClipMoveControl;
import twilightforest.entity.ai.goal.GhastguardHomedFlightGoal;
import twilightforest.entity.ai.goal.UrGhastFlightGoal;
import twilightforest.entity.monster.CarminiteGhastguard;
import twilightforest.entity.monster.CarminiteGhastling;
import twilightforest.entity.projectile.UrGhastFireball;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFDamageSources;
import twilightforest.init.TFEntities;
import twilightforest.init.TFLandmark;
import twilightforest.init.TFParticleType;
import twilightforest.init.TFSounds;
import twilightforest.loot.TFLootTables;
import twilightforest.util.EntityUtil;
import twilightforest.world.registration.TFGenerationSettings;

public class UrGhast
extends CarminiteGhastguard {
    private static final EntityDataAccessor<Boolean> DATA_TANTRUM = SynchedEntityData.m_135353_(UrGhast.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private List<BlockPos> trapLocations;
    private int nextTantrumCry;
    private float damageUntilNextPhase = 10.0f;
    private boolean noTrapMode;
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS);
    private final List<ServerPlayer> hurtBy = new ArrayList<ServerPlayer>();

    public UrGhast(EntityType<? extends UrGhast> type, Level world) {
        super(type, world);
        this.wanderFactor = 32.0f;
        this.f_19794_ = true;
        this.setInTantrum(false);
        this.f_21364_ = 317;
        this.f_21342_ = new NoClipMoveControl((Mob)this);
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.bossInfo.m_6456_(this.m_5446_());
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return CarminiteGhastguard.registerAttributes().m_22268_(Attributes.f_22276_, 250.0).m_22268_(Attributes.f_22277_, 128.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_TANTRUM, (Object)false);
    }

    public List<BlockPos> getTrapLocations() {
        return this.trapLocations;
    }

    public boolean isInNoTrapMode() {
        return this.noTrapMode;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.trapLocations = new ArrayList<BlockPos>();
        this.f_21345_.f_25345_.removeIf(e -> e.m_26015_() instanceof GhastguardHomedFlightGoal);
        this.f_21345_.m_25352_(5, (Goal)new UrGhastFlightGoal(this));
    }

    public boolean m_6785_(double dist) {
        return false;
    }

    public void m_6043_() {
        if (this.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
            if (this.m_21534_() != BlockPos.f_121853_) {
                this.m_9236_().m_46597_(this.m_21534_(), ((Block)TFBlocks.UR_GHAST_BOSS_SPAWNER.get()).m_49966_());
            }
            this.m_146870_();
        } else {
            super.m_6043_();
        }
    }

    @Override
    protected SoundEvent m_7515_() {
        return (SoundEvent)TFSounds.URGHAST_AMBIENT.get();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)TFSounds.URGHAST_HURT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)TFSounds.URGHAST_DEATH.get();
    }

    @Override
    public SoundEvent getFireSound() {
        return (SoundEvent)TFSounds.URGHAST_SHOOT.get();
    }

    @Override
    public SoundEvent getWarnSound() {
        return (SoundEvent)TFSounds.URGHAST_WARN.get();
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().m_5776_()) {
            this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
        } else {
            if (this.isInTantrum()) {
                this.m_9236_().m_7106_((ParticleOptions)TFParticleType.BOSS_TEAR.get(), this.m_20185_() + (this.m_217043_().m_188500_() - 0.5) * (double)this.m_20205_() * 0.75, this.m_20186_() + this.m_217043_().m_188500_() * (double)this.m_20206_() * 0.5, this.m_20189_() + (this.m_217043_().m_188500_() - 0.5) * (double)this.m_20205_() * 0.75, 0.0, 0.0, 0.0);
            }
            if (this.f_20919_ > 0) {
                for (int k = 0; k < 5; ++k) {
                    double d = this.m_217043_().m_188583_() * 0.02;
                    double d1 = this.m_217043_().m_188583_() * 0.02;
                    double d2 = this.m_217043_().m_188583_() * 0.02;
                    this.m_9236_().m_7106_((ParticleOptions)(this.m_217043_().m_188499_() ? ParticleTypes.f_123813_ : ParticleTypes.f_123759_), this.m_20185_() + (double)(this.m_217043_().m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + (double)(this.m_217043_().m_188501_() * this.m_20206_()), this.m_20189_() + (double)(this.m_217043_().m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), d, d1, d2);
                }
            }
        }
    }

    public boolean m_6673_(DamageSource src) {
        return src == DamageSource.f_19310_ || src == DamageSource.f_19305_ || src == DamageSource.f_19307_ || super.m_6673_(src);
    }

    public void m_147240_(double strength, double xRatio, double zRatio) {
    }

    public boolean m_6469_(DamageSource source, float damage) {
        ServerPlayer player;
        if (this.isInTantrum()) {
            damage /= 10.0f;
        }
        float oldHealth = this.m_21223_();
        boolean attackSuccessful = "fireball".equals(source.m_19385_()) && source.m_7639_() instanceof Player ? super.m_6469_(DamageSource.m_19361_((Entity)source.m_7639_(), (Entity)source.m_7640_()), damage) : super.m_6469_(source, damage);
        float lastDamage = oldHealth - this.m_21223_();
        Entity entity = source.m_7639_();
        if (entity instanceof ServerPlayer && !this.hurtBy.contains(player = (ServerPlayer)entity)) {
            this.hurtBy.add(player);
        }
        if (!this.m_9236_().m_5776_() && this.f_20916_ == this.f_20917_) {
            this.damageUntilNextPhase -= lastDamage;
            if (this.damageUntilNextPhase <= 0.0f) {
                this.switchPhase();
            }
        }
        return attackSuccessful;
    }

    private void switchPhase() {
        if (this.isInTantrum()) {
            this.setInTantrum(false);
        } else {
            this.startTantrum();
        }
        this.resetDamageUntilNextPhase();
    }

    public void resetDamageUntilNextPhase() {
        this.damageUntilNextPhase = 18.0f;
    }

    private void startTantrum() {
        this.setInTantrum(true);
        this.spawnGhastsAtTraps();
    }

    public void spawnGhastsAtTraps() {
        ArrayList<BlockPos> ghastSpawns = new ArrayList<BlockPos>(this.trapLocations);
        Collections.shuffle(ghastSpawns);
        int numSpawns = Math.min(2, ghastSpawns.size());
        for (int i = 0; i < numSpawns; ++i) {
            BlockPos spawnCoord = (BlockPos)ghastSpawns.get(i);
            this.spawnMinionGhastsAt(spawnCoord.m_123341_(), spawnCoord.m_123342_(), spawnCoord.m_123343_());
        }
    }

    private void spawnMinionGhastsAt(int x, int y, int z) {
        int tries = 24;
        int spawns = 0;
        int maxSpawns = 6;
        int rangeXZ = 4;
        int rangeY = 8;
        LightningBolt bolt = new LightningBolt(EntityType.f_20465_, this.m_9236_());
        bolt.m_6034_((double)x, (double)(y + 4), (double)z);
        bolt.m_20874_(true);
        this.m_9236_().m_7967_((Entity)bolt);
        for (int i = 0; i < tries; ++i) {
            CarminiteGhastling minion = (CarminiteGhastling)((EntityType)TFEntities.CARMINITE_GHASTLING.get()).m_20615_(this.m_9236_());
            double sx = (double)x + (this.m_217043_().m_188500_() - this.m_217043_().m_188500_()) * (double)rangeXZ;
            double sy = (double)y + this.m_217043_().m_188500_() * (double)rangeY;
            double sz = (double)z + (this.m_217043_().m_188500_() - this.m_217043_().m_188500_()) * (double)rangeXZ;
            minion.m_7678_(sx, sy, sz, this.m_9236_().m_213780_().m_188501_() * 360.0f, 0.0f);
            minion.makeBossMinion();
            if (minion.m_5545_((LevelAccessor)this.m_9236_(), MobSpawnType.MOB_SUMMONED)) {
                this.m_9236_().m_7967_((Entity)minion);
                minion.m_21373_();
            }
            if (++spawns >= maxSpawns) break;
        }
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        this.m_21536_();
        for (CarminiteGhastling ghast : this.m_9236_().m_45976_(CarminiteGhastling.class, this.m_20191_().m_82400_(1.0))) {
            ghast.m_21373_();
            ghast.m_146870_();
            this.m_5634_(2.0f);
        }
        if (this.getTrapLocations().isEmpty() && !this.isInNoTrapMode()) {
            this.scanForTrapsTwice();
            if (this.getTrapLocations().isEmpty()) {
                this.noTrapMode = true;
            }
        }
        if (this.isInTantrum()) {
            this.m_6710_(null);
            if (--this.nextTantrumCry <= 0) {
                this.m_5496_(this.m_7975_(null), this.m_6121_(), this.m_6100_());
                this.nextTantrumCry = 20 + this.m_217043_().m_188503_(30);
            }
            if (this.f_19797_ % 10 == 0) {
                this.doTantrumDamageEffects();
            }
        }
    }

    private void doTantrumDamageEffects() {
        AABB below = this.m_20191_().m_82386_(0.0, -16.0, 0.0).m_82377_(0.0, 16.0, 0.0);
        for (Player player : this.m_9236_().m_45976_(Player.class, below)) {
            if (!this.m_9236_().m_46861_(player.m_20183_())) continue;
            player.m_6469_(TFDamageSources.GHAST_TEAR, 3.0f);
        }
        for (CarminiteGhastling ghast : this.m_9236_().m_45976_(CarminiteGhastling.class, below)) {
            ghast.m_5997_(0.0, 1.0, 0.0);
        }
    }

    public boolean checkGhastsAtTraps() {
        int trapsWithEnoughGhasts = 0;
        for (BlockPos trap : this.getTrapLocations()) {
            AABB aabb = new AABB(trap, trap.m_7918_(1, 1, 1)).m_82377_(8.0, 16.0, 8.0);
            List nearbyGhasts = this.m_9236_().m_45976_(CarminiteGhastling.class, aabb);
            if (nearbyGhasts.size() < 4) continue;
            ++trapsWithEnoughGhasts;
        }
        return trapsWithEnoughGhasts >= 1;
    }

    @Override
    public void spitFireball() {
        double offsetX = this.m_5448_().m_20185_() - this.m_20185_();
        double offsetY = this.m_5448_().m_20191_().f_82289_ + (double)(this.m_5448_().m_20206_() / 2.0f) - (this.m_20186_() + (double)(this.m_20206_() / 2.0f));
        double offsetZ = this.m_5448_().m_20189_() - this.m_20189_();
        UrGhastFireball entityFireball = new UrGhastFireball(this.m_9236_(), this, offsetX, offsetY, offsetZ, 1);
        double shotSpawnDistance = 8.5;
        Vec3 lookVec = this.m_20252_(1.0f);
        entityFireball.m_6034_(this.m_20185_() + lookVec.m_7096_() * shotSpawnDistance, this.m_20186_() + (double)(this.m_20206_() / 2.0f) + lookVec.m_7098_() * shotSpawnDistance, this.m_20189_() + lookVec.m_7094_() * shotSpawnDistance);
        this.m_9236_().m_7967_((Entity)entityFireball);
        for (int i = 0; i < 2; ++i) {
            entityFireball = new UrGhastFireball(this.m_9236_(), this, offsetX + (double)((this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) * 8.0f), offsetY, offsetZ + (double)((this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) * 8.0f), 1);
            entityFireball.m_6034_(this.m_20185_() + lookVec.m_7096_() * shotSpawnDistance, this.m_20186_() + (double)(this.m_20206_() / 2.0f) + lookVec.m_7098_() * shotSpawnDistance, this.m_20189_() + lookVec.m_7094_() * shotSpawnDistance);
            this.m_9236_().m_7967_((Entity)entityFireball);
        }
    }

    private void scanForTrapsTwice() {
        int scanRangeXZ = 48;
        int scanRangeY = 32;
        this.scanForTraps(scanRangeXZ, scanRangeY, this.m_20183_());
        if (this.getTrapLocations().size() > 0) {
            int ax = 0;
            int ay = 0;
            int az = 0;
            for (BlockPos trapCoords : this.getTrapLocations()) {
                ax += trapCoords.m_123341_();
                ay += trapCoords.m_123342_();
                az += trapCoords.m_123343_();
            }
            this.scanForTraps(scanRangeXZ, scanRangeY, new BlockPos(ax /= this.getTrapLocations().size(), ay /= this.getTrapLocations().size(), az /= this.getTrapLocations().size()));
        }
    }

    private void scanForTraps(int scanRangeXZ, int scanRangeY, BlockPos pos) {
        for (int sx = -scanRangeXZ; sx <= scanRangeXZ; ++sx) {
            for (int sz = -scanRangeXZ; sz <= scanRangeXZ; ++sz) {
                for (int sy = -scanRangeY; sy <= scanRangeY; ++sy) {
                    BlockPos trapCoords = pos.m_7918_(sx, sy, sz);
                    if (!this.isTrapAt(trapCoords)) continue;
                    this.getTrapLocations().add(trapCoords);
                }
            }
        }
    }

    private boolean isTrapAt(BlockPos pos) {
        return this.m_9236_().m_46805_(pos) && this.m_9236_().m_8055_(pos).m_60713_((Block)TFBlocks.GHAST_TRAP.get());
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean isInTantrum() {
        return (Boolean)this.f_19804_.m_135370_(DATA_TANTRUM);
    }

    public void setInTantrum(boolean inTantrum) {
        this.f_19804_.m_135381_(DATA_TANTRUM, (Object)inTantrum);
        this.resetDamageUntilNextPhase();
    }

    @Override
    protected float m_6121_() {
        return 16.0f;
    }

    public float m_6100_() {
        return (this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) * 0.2f + 0.5f;
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        compound.m_128379_("inTantrum", this.isInTantrum());
        super.m_7380_(compound);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setInTantrum(compound.m_128471_("inTantrum"));
        if (this.m_8077_()) {
            this.bossInfo.m_6456_(this.m_5446_());
        }
    }

    public void m_6667_(DamageSource cause) {
        super.m_6667_(cause);
        if (!this.m_9236_().m_5776_()) {
            TFGenerationSettings.markStructureConquered(this.m_9236_(), this.findChestCoords(), TFLandmark.DARK_TOWER);
            for (ServerPlayer player : this.hurtBy) {
                TFAdvancements.HURT_BOSS.trigger(player, (Entity)this);
            }
            TFLootTables.entityDropsIntoContainer((LivingEntity)this, this.m_7771_(true, cause).m_78975_(LootContextParamSets.f_81415_), ((TFChestBlock)((Object)TFBlocks.DARKWOOD_CHEST.get())).m_49966_(), this.findChestCoords());
        }
    }

    protected boolean m_6125_() {
        return false;
    }

    private BlockPos findChestCoords() {
        if (this.getTrapLocations().size() > 0) {
            int ax = 0;
            int ay = 0;
            int az = 0;
            for (BlockPos trapCoords : this.getTrapLocations()) {
                ax += trapCoords.m_123341_();
                ay += trapCoords.m_123342_();
                az += trapCoords.m_123343_();
            }
            return new BlockPos(ax /= this.getTrapLocations().size(), (ay /= this.getTrapLocations().size()) + 2, az /= this.getTrapLocations().size());
        }
        return EntityUtil.bossChestLocation((Mob)this);
    }

    @Override
    public boolean shouldAttack(LivingEntity living) {
        return !this.isInTantrum();
    }

    @Override
    protected boolean m_7341_(Entity entityIn) {
        return false;
    }

    public boolean m_6072_() {
        return false;
    }
}

