/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.structurize.network.messages.IMessage;
import com.ldtteam.structurize.storage.rendering.RenderingCache;
import com.ldtteam.structurize.storage.rendering.types.BoxPreviewData;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowScanMessage
implements IMessage {
    private final BoxPreviewData box;

    public ShowScanMessage(@NotNull BoxPreviewData box) {
        this.box = box;
    }

    public ShowScanMessage(@NotNull FriendlyByteBuf buf) {
        BlockPos from = buf.m_130135_();
        BlockPos to = buf.m_130135_();
        BlockPos anchor = buf.readBoolean() ? buf.m_130135_() : null;
        this.box = new BoxPreviewData(from, to, Optional.ofNullable(anchor));
    }

    @Override
    public void toBytes(@NotNull FriendlyByteBuf buf) {
        buf.m_130064_(this.box.getPos1());
        buf.m_130064_(this.box.getPos2());
        if (this.box.getAnchor().isPresent()) {
            buf.writeBoolean(true);
            buf.m_130064_(this.box.getAnchor().get());
        } else {
            buf.writeBoolean(false);
        }
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    public void onExecute(@NotNull NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        RenderingCache.queue("scan", this.box);
    }
}

