/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.client.gui;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.Image;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.util.resloc.OutOfJarResourceLocation;
import com.ldtteam.blockui.views.BOWindow;
import com.ldtteam.blockui.views.ScrollingList;
import com.ldtteam.structurize.client.gui.AbstractWindowSkeleton;
import com.ldtteam.structurize.storage.StructurePackMeta;
import com.ldtteam.structurize.storage.StructurePacks;
import com.ldtteam.structurize.util.IOPool;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class WindowSwitchPack
extends AbstractWindowSkeleton {
    private static final String WINDOW_TAG_TOOL = ":gui/windowswitchpack.xml";
    private final Supplier<BOWindow> prevWindow;
    private final Predicate<StructurePackMeta> packPredicate;
    private ScrollingList packList;
    private List<StructurePackMeta> packMetas;
    private Future<List<StructurePackMeta>> packMetasFuture;
    private static int randomSeed = new Random().nextInt();

    public WindowSwitchPack(Supplier<BOWindow> prevWindow) {
        this(prevWindow, pack -> true);
    }

    public WindowSwitchPack(Supplier<BOWindow> prevWindow, Predicate<StructurePackMeta> packPredicate) {
        super("structurize:gui/windowswitchpack.xml");
        this.registerButton("select1", this::selectClicked);
        this.registerButton("select2", this::selectClicked);
        this.registerButton("cancel", this::cancelClicked);
        this.prevWindow = prevWindow;
        this.packPredicate = packPredicate;
    }

    public void cancelClicked() {
        if (this.prevWindow == null) {
            this.close();
            return;
        }
        this.prevWindow.get().open();
    }

    public void selectClicked(Button button) {
        if (this.prevWindow == null) {
            this.close();
            return;
        }
        int index = this.packList.getListElementIndexByPane((Pane)button);
        if (button.getID().contains("1")) {
            StructurePacks.selectedPack = this.packMetas.get(index * 2);
            this.prevWindow.get().open();
        } else {
            StructurePacks.selectedPack = this.packMetas.get(index * 2 + 1);
            this.prevWindow.get().open();
        }
    }

    public void onOpened() {
        this.packMetas = Collections.emptyList();
        this.packMetasFuture = IOPool.submit(() -> {
            if (!StructurePacks.waitUntilFinishedLoading()) {
                return Collections.emptyList();
            }
            return new ArrayList<StructurePackMeta>(StructurePacks.getPackMetas().stream().filter(this.packPredicate).toList());
        });
        this.packList = (ScrollingList)this.findPaneOfTypeByID("packs", ScrollingList.class);
        super.onOpened();
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.packMetasFuture != null && this.packMetasFuture.isDone()) {
            try {
                this.packMetas = this.packMetasFuture.get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
            this.packMetasFuture = null;
            if (!this.packMetas.isEmpty()) {
                Collections.shuffle(this.packMetas, new Random(randomSeed));
            }
            this.updatePacks();
        }
    }

    public void updatePacks() {
        this.packList.enable();
        this.packList.show();
        this.packList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return (int)Math.ceil((double)WindowSwitchPack.this.packMetas.size() / 2.0);
            }

            public void updateElement(int index, Pane rowPane) {
                int metaStart = index * 2;
                StructurePackMeta packMeta = WindowSwitchPack.this.packMetas.get(metaStart);
                WindowSwitchPack.fillForMeta(rowPane, packMeta, "1");
                if (WindowSwitchPack.this.packMetas.size() > metaStart + 1) {
                    WindowSwitchPack.fillForMeta(rowPane, WindowSwitchPack.this.packMetas.get(metaStart + 1), "2");
                    rowPane.findPaneByID("box2").show();
                } else {
                    rowPane.findPaneByID("box2").hide();
                }
            }
        });
    }

    private static void fillForMeta(Pane rowPane, StructurePackMeta packMeta, String side) {
        ((Text)rowPane.findPaneOfTypeByID("name" + side, Text.class)).setText(Component.m_237113_((String)packMeta.getName()));
        ((Text)rowPane.findPaneOfTypeByID("desc" + side, Text.class)).setText(Component.m_237113_((String)packMeta.getDesc()));
        StringBuilder author = new StringBuilder("Authors: ");
        for (int i = 0; i < packMeta.getAuthors().size(); ++i) {
            author.append(packMeta.getAuthors().get(i));
            if (i + 1 >= packMeta.getAuthors().size()) continue;
            author.append(", ");
        }
        ((Text)rowPane.findPaneOfTypeByID("authors" + side, Text.class)).setText(Component.m_237113_((String)author.toString()));
        if (!packMeta.getIconPath().isEmpty()) {
            ((Image)rowPane.findPaneOfTypeByID("icon" + side, Image.class)).setImage((ResourceLocation)OutOfJarResourceLocation.of((String)"structurize", (Path)packMeta.getPath().resolve(packMeta.getIconPath())), false);
        }
        ((Button)rowPane.findPaneOfTypeByID("select" + side, Button.class)).setTextColor(ChatFormatting.BLACK.m_126665_().intValue());
    }
}

