/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.client.gui;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.Image;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.ScrollingList;
import com.ldtteam.structurize.Network;
import com.ldtteam.structurize.api.util.Utils;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.client.ModKeyMappings;
import com.ldtteam.structurize.client.gui.AbstractWindowSkeleton;
import com.ldtteam.structurize.config.BlueprintRenderSettings;
import com.ldtteam.structurize.network.messages.BuildToolPlacementMessage;
import com.ldtteam.structurize.network.messages.SyncSettingsToServer;
import com.ldtteam.structurize.storage.ISurvivalBlueprintHandler;
import com.ldtteam.structurize.storage.SurvivalBlueprintHandlers;
import com.ldtteam.structurize.storage.rendering.RenderingCache;
import com.ldtteam.structurize.storage.rendering.types.BlueprintPreviewData;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBlueprintManipulationWindow
extends AbstractWindowSkeleton {
    private final String bluePrintId;
    protected ScrollingList settingsList;
    private ScrollingList placementOptionsList;
    protected int groundstyle;
    private int openTicks = 0;

    public AbstractBlueprintManipulationWindow(@NotNull String resourceId, @Nullable BlockPos pos, int groundstyle, String blueprintId) {
        super(resourceId);
        this.groundstyle = groundstyle;
        this.bluePrintId = blueprintId;
        if (pos != null && RenderingCache.getOrCreateBlueprintPreviewData(blueprintId).getPos() == null) {
            RenderingCache.getOrCreateBlueprintPreviewData(blueprintId).setPos(pos);
            this.adjustToGroundOffset();
        }
        this.registerButton("confirm", this::confirmClicked);
        this.registerButton("cancel", this::cancelClicked);
        this.registerButton("left", this::moveLeftClicked);
        this.registerButton("mirror", this::mirrorClicked);
        this.registerButton("right", this::moveRightClicked);
        this.registerButton("down", this::moveBackClicked);
        this.registerButton("up", this::moveForwardClicked);
        this.registerButton("plus", this::moveUpClicked);
        this.registerButton("minus", this::moveDownClicked);
        this.registerButton("rotateRight", this::rotateRightClicked);
        this.registerButton("rotateLeft", this::rotateLeftClicked);
        this.registerButton("settings", this::settingsClicked);
        this.settingsList = (ScrollingList)this.findPaneOfTypeByID("settinglist", ScrollingList.class);
        this.placementOptionsList = (ScrollingList)this.findPaneOfTypeByID("placement", ScrollingList.class);
        this.updateRotationState();
        ((Text)this.findPaneOfTypeByID("tip", Text.class)).setVisible(pos != null);
    }

    public void onOpened() {
        super.onOpened();
        if (RenderingCache.getOrCreateBlueprintPreviewData(this.bluePrintId).getPos() == null) {
            Utils.playErrorSound((Player)Minecraft.m_91087_().f_91074_);
            Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237115_((String)"structurize.gui.missing.pos"), false);
            this.cancelClicked();
        }
    }

    protected abstract void cancelClicked();

    protected void confirmClicked() {
        BlueprintPreviewData previewData = RenderingCache.getOrCreateBlueprintPreviewData(this.bluePrintId);
        if (previewData.getBlueprint() != null) {
            if (!Minecraft.m_91087_().f_91074_.m_7500_()) {
                List<ISurvivalBlueprintHandler> handlers = SurvivalBlueprintHandlers.getMatchingHandlers(previewData.getBlueprint(), Minecraft.m_91087_().f_91073_, (Player)Minecraft.m_91087_().f_91074_, previewData.getPos(), previewData.getPlacementSettings());
                if (handlers.isEmpty()) {
                    Utils.playErrorSound((Player)Minecraft.m_91087_().f_91074_);
                    if (SurvivalBlueprintHandlers.getHandlers().isEmpty()) {
                        Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237115_((String)"structurize.gui.no.survival.handler"), false);
                    }
                    return;
                }
                if (handlers.size() == 1) {
                    this.handlePlacement(BuildToolPlacementMessage.HandlerType.Survival, handlers.get(0).getId());
                    return;
                }
            }
            this.updatePlacementOptions();
        }
    }

    protected abstract void handlePlacement(BuildToolPlacementMessage.HandlerType var1, String var2);

    protected void hideOtherGuiForPlacement() {
        this.settingsList.hide();
        this.settingsList.disable();
    }

    protected void hidePlacementGui() {
        this.placementOptionsList.hide();
        this.placementOptionsList.disable();
        this.settingsList.hide();
        this.settingsList.disable();
    }

    public void updatePlacementOptions() {
        BlueprintPreviewData previewData;
        this.placementOptionsList.enable();
        this.placementOptionsList.show();
        this.hideOtherGuiForPlacement();
        final ArrayList<Tuple> categories = new ArrayList<Tuple>();
        if (Minecraft.m_91087_().f_91074_.m_7500_()) {
            categories.add(new Tuple((Object)Component.m_237115_((String)"structurize.gui.buildtool.complete"), () -> this.handlePlacement(BuildToolPlacementMessage.HandlerType.Complete, "")));
            categories.add(new Tuple((Object)Component.m_237115_((String)"structurize.gui.buildtool.pretty"), () -> this.handlePlacement(BuildToolPlacementMessage.HandlerType.Pretty, "")));
        }
        if ((previewData = RenderingCache.getOrCreateBlueprintPreviewData(this.bluePrintId)).getBlueprint() != null) {
            for (ISurvivalBlueprintHandler handler : SurvivalBlueprintHandlers.getMatchingHandlers(previewData.getBlueprint(), Minecraft.m_91087_().f_91073_, (Player)Minecraft.m_91087_().f_91074_, previewData.getPos(), previewData.getPlacementSettings())) {
                categories.add(new Tuple((Object)handler.getDisplayName(), () -> this.handlePlacement(BuildToolPlacementMessage.HandlerType.Survival, handler.getId())));
            }
        }
        this.placementOptionsList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return categories.size();
            }

            public void updateElement(int index, Pane rowPane) {
                ButtonImage buttonImage = (ButtonImage)rowPane.findPaneOfTypeByID("type", ButtonImage.class);
                buttonImage.setText((Component)((Tuple)categories.get(index)).m_14418_());
                buttonImage.setTextColor(ChatFormatting.BLACK.m_126665_().intValue());
                buttonImage.setHandler(button -> ((Runnable)((Tuple)categories.get(index)).m_14419_()).run());
            }
        });
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.openTicks++ >= 200) {
            ((Text)this.findPaneOfTypeByID("tip", Text.class)).setVisible(false);
        }
    }

    public boolean onUnhandledKeyTyped(int ch, int key) {
        if (ch != 0 || AbstractBlueprintManipulationWindow.getFocus() != null) {
            return super.onUnhandledKeyTyped(ch, key);
        }
        InputConstants.Key inputKey = InputConstants.Type.KEYSYM.m_84895_(key);
        if (((KeyMapping)ModKeyMappings.MOVE_FORWARD.get()).isActiveAndMatches(inputKey)) {
            this.moveForwardClicked();
        } else if (((KeyMapping)ModKeyMappings.MOVE_BACK.get()).isActiveAndMatches(inputKey)) {
            this.moveBackClicked();
        } else if (((KeyMapping)ModKeyMappings.MOVE_LEFT.get()).isActiveAndMatches(inputKey)) {
            this.moveLeftClicked();
        } else if (((KeyMapping)ModKeyMappings.MOVE_RIGHT.get()).isActiveAndMatches(inputKey)) {
            this.moveRightClicked();
        } else if (((KeyMapping)ModKeyMappings.MOVE_UP.get()).isActiveAndMatches(inputKey)) {
            this.moveUpClicked();
        } else if (((KeyMapping)ModKeyMappings.MOVE_DOWN.get()).isActiveAndMatches(inputKey)) {
            this.moveDownClicked();
        } else if (((KeyMapping)ModKeyMappings.ROTATE_CW.get()).isActiveAndMatches(inputKey)) {
            this.rotateRightClicked();
        } else if (((KeyMapping)ModKeyMappings.ROTATE_CCW.get()).isActiveAndMatches(inputKey)) {
            this.rotateLeftClicked();
        } else if (((KeyMapping)ModKeyMappings.MIRROR.get()).isActiveAndMatches(inputKey)) {
            this.mirrorClicked();
        } else if (((KeyMapping)ModKeyMappings.PLACE.get()).isActiveAndMatches(inputKey)) {
            this.confirmClicked();
        } else {
            return super.onUnhandledKeyTyped(ch, key);
        }
        return true;
    }

    protected void settingsClicked() {
        if (this.settingsList.isVisible()) {
            this.settingsList.hide();
            this.settingsList.disable();
            return;
        }
        this.settingsList.show();
        this.settingsList.enable();
        final ArrayList<Map.Entry<String, Boolean>> settings = new ArrayList<Map.Entry<String, Boolean>>(BlueprintRenderSettings.instance.renderSettings.entrySet());
        this.settingsList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return settings.size();
            }

            public void updateElement(int index, Pane rowPane) {
                ((Text)rowPane.findPaneOfTypeByID("label", Text.class)).setText(Component.m_237115_((String)((String)((Map.Entry)settings.get(index)).getKey())));
                ButtonImage buttonImage = (ButtonImage)rowPane.findPaneOfTypeByID("switch", ButtonImage.class);
                if (((Boolean)((Map.Entry)settings.get(index)).getValue()).booleanValue()) {
                    buttonImage.setText(Component.m_237115_((String)"options.on"));
                } else {
                    buttonImage.setText(Component.m_237115_((String)"options.off"));
                }
                buttonImage.setTextColor(ChatFormatting.BLACK.m_126665_().intValue());
                buttonImage.setHandler(button -> {
                    ((Map.Entry)settings.get(index)).setValue((Boolean)((Map.Entry)settings.get(index)).getValue() == false);
                    Network.getNetwork().sendToServer(new SyncSettingsToServer());
                    RenderingCache.getOrCreateBlueprintPreviewData(AbstractBlueprintManipulationWindow.this.bluePrintId).scheduleRefresh();
                });
            }
        });
    }

    private void mirrorClicked() {
        RenderingCache.getOrCreateBlueprintPreviewData(this.bluePrintId).mirror();
        this.updateRotationState();
    }

    private void moveUpClicked() {
        RenderingCache.getOrCreateBlueprintPreviewData(this.bluePrintId).move(new BlockPos(0, 1, 0));
    }

    private void moveDownClicked() {
        RenderingCache.getOrCreateBlueprintPreviewData(this.bluePrintId).move(new BlockPos(0, -1, 0));
    }

    private void moveLeftClicked() {
        RenderingCache.getOrCreateBlueprintPreviewData(this.bluePrintId).move(new BlockPos(0, 0, 0).m_121945_(this.mc.f_91074_.m_6350_().m_122428_()));
    }

    private void moveRightClicked() {
        RenderingCache.getOrCreateBlueprintPreviewData(this.bluePrintId).move(new BlockPos(0, 0, 0).m_121945_(this.mc.f_91074_.m_6350_().m_122427_()));
    }

    private void moveForwardClicked() {
        RenderingCache.getOrCreateBlueprintPreviewData(this.bluePrintId).move(new BlockPos(0, 0, 0).m_121945_(this.mc.f_91074_.m_6350_()));
    }

    private void moveBackClicked() {
        RenderingCache.getOrCreateBlueprintPreviewData(this.bluePrintId).move(new BlockPos(0, 0, 0).m_121945_(this.mc.f_91074_.m_6350_().m_122424_()));
    }

    private void rotateRightClicked() {
        RenderingCache.getOrCreateBlueprintPreviewData(this.bluePrintId).rotate(Rotation.CLOCKWISE_90);
        this.updateRotationState();
    }

    private void rotateLeftClicked() {
        RenderingCache.getOrCreateBlueprintPreviewData(this.bluePrintId).rotate(Rotation.COUNTERCLOCKWISE_90);
        this.updateRotationState();
    }

    protected void updateRotationState() {
        ((ButtonImage)this.findPaneOfTypeByID("mirror", ButtonImage.class)).setImage(new ResourceLocation("structurize", String.format("textures/gui/buildtool/%s.png", "mirror" + (RenderingCache.getOrCreateBlueprintPreviewData(this.bluePrintId).getMirror().equals((Object)Mirror.NONE) ? "" : "_green"))), false);
        ((Image)this.findPaneOfTypeByID("rotation", Image.class)).setImage(new ResourceLocation("structurize", String.format("textures/gui/buildtool/%s.png", switch (RenderingCache.getOrCreateBlueprintPreviewData(this.bluePrintId).getRotation()) {
            case Rotation.CLOCKWISE_90 -> "right_green";
            case Rotation.CLOCKWISE_180 -> "down_green";
            case Rotation.COUNTERCLOCKWISE_90 -> "left_green";
            default -> "up_green";
        })), false);
    }

    protected void adjustToGroundOffset() {
        Blueprint blueprint = RenderingCache.getOrCreateBlueprintPreviewData(this.bluePrintId).getBlueprint();
        if (blueprint != null) {
            RenderingCache.getOrCreateBlueprintPreviewData(this.bluePrintId).setGroundOffset(--groundOffset);
        }
    }
}

