/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import dan200.computercraft.ComputerCraft;
import java.util.concurrent.ThreadFactory;

public final class ThreadUtils {
    private static final ThreadGroup baseGroup = new ThreadGroup("ComputerCraft");

    private ThreadUtils() {
    }

    public static ThreadGroup group() {
        return baseGroup;
    }

    public static ThreadGroup group(String name) {
        return new ThreadGroup(baseGroup, baseGroup.getName() + "-" + name);
    }

    public static ThreadFactoryBuilder builder(String name) {
        ThreadGroup group = ThreadUtils.group(name);
        return new ThreadFactoryBuilder().setDaemon(true).setNameFormat(group.getName().replace("%", "%%") + "-%d").setUncaughtExceptionHandler((t, e) -> ComputerCraft.log.error("Exception in thread " + t.getName(), e)).setThreadFactory(x -> new Thread(group, x));
    }

    public static ThreadFactory factory(String name) {
        return ThreadUtils.builder(name).build();
    }
}

