/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix.socket.gem;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import shadows.apotheosis.Apoth;
import shadows.apotheosis.adventure.affix.socket.gem.Gem;
import shadows.apotheosis.adventure.loot.LootRarity;

public class GemItem
extends Item {
    public static final String MODIFIER = "modifier";

    public GemItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public void m_7373_(ItemStack pStack, Level pLevel, List<Component> tooltip, TooltipFlag pIsAdvanced) {
        Pair<Attribute, AttributeModifier> bonus = GemItem.getStoredBonus(pStack);
        if (bonus == null) {
            tooltip.add((Component)Component.m_237113_((String)"Errored gem with no bonus!").m_130940_(ChatFormatting.GRAY));
            return;
        }
        float purity = GemItem.getPurity(pStack);
        if (purity != 0.0f) {
            MutableComponent purityText = Component.m_237113_((String)(ItemStack.f_41584_.format((int)(purity * 100.0f)) + "%"));
            tooltip.add((Component)Component.m_237110_((String)"text.apotheosis.purity", (Object[])new Object[]{purityText}).m_130948_(Style.f_131099_.m_178520_(11444950)));
        }
        tooltip.add(CommonComponents.f_237098_);
        tooltip.add((Component)Component.m_237115_((String)"item.modifiers.socket").m_130940_(ChatFormatting.GOLD));
        tooltip.add(GemItem.toComponent((Attribute)bonus.getKey(), (AttributeModifier)bonus.getValue()));
    }

    public Component m_7626_(ItemStack pStack) {
        float purity = GemItem.getPurity(pStack);
        if (purity == 0.0f) {
            return super.m_7626_(pStack);
        }
        return Component.m_237115_((String)this.m_5671_(pStack)).m_130948_(Style.f_131099_.m_131148_(GemItem.getPurityColor(purity)));
    }

    private static TextColor getPurityColor(float purity) {
        if ((double)purity <= 0.2) {
            return LootRarity.COMMON.color();
        }
        if ((double)purity <= 0.4) {
            return LootRarity.UNCOMMON.color();
        }
        if ((double)purity <= 0.6) {
            return LootRarity.RARE.color();
        }
        if ((double)purity <= 0.8) {
            return LootRarity.EPIC.color();
        }
        if (purity <= 1.0f) {
            return LootRarity.MYTHIC.color();
        }
        return LootRarity.ANCIENT.color();
    }

    public String m_5671_(ItemStack pStack) {
        int variant = GemItem.getVariant(pStack);
        return super.m_5671_(pStack) + "." + variant;
    }

    @Nullable
    public static Pair<Attribute, AttributeModifier> getStoredBonus(ItemStack stack) {
        CompoundTag tag = stack.m_41737_(MODIFIER);
        if (tag == null) {
            return null;
        }
        Attribute attrib = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(tag.m_128461_("attribute")));
        if (attrib == null) {
            return null;
        }
        AttributeModifier modif = AttributeModifier.m_22212_((CompoundTag)tag);
        if (modif == null) {
            return null;
        }
        return Pair.of((Object)attrib, (Object)modif);
    }

    public static void setStoredBonus(ItemStack stack, Attribute attrib, AttributeModifier modif) {
        CompoundTag tag = modif.m_22219_();
        tag.m_128359_("attribute", ForgeRegistries.ATTRIBUTES.getKey((Object)attrib).toString());
        stack.m_41784_().m_128365_(MODIFIER, (Tag)tag);
    }

    public static void setVariant(ItemStack stack, int variant) {
        stack.m_41784_().m_128405_("variant", variant);
    }

    public static int getVariant(ItemStack stack) {
        return stack.m_41782_() ? stack.m_41783_().m_128451_("variant") : 0;
    }

    public static void setPurity(ItemStack stack, float purity) {
        stack.m_41784_().m_128350_("purity", purity);
    }

    public static float getPurity(ItemStack stack) {
        return stack.m_41782_() ? stack.m_41783_().m_128457_("purity") : 0.0f;
    }

    public static ItemStack fromGem(Gem gem, RandomSource rand) {
        ItemStack stack = new ItemStack((ItemLike)Apoth.Items.GEM.get());
        GemItem.setVariant(stack, gem.getVariant());
        float level = rand.m_188501_();
        float purity = gem.value.get(level) / gem.value.get(1.0f);
        GemItem.setStoredBonus(stack, gem.attribute, new AttributeModifier("GemBonus_" + gem.getId(), (double)gem.value.get(level), gem.operation));
        GemItem.setPurity(stack, purity);
        return stack;
    }

    public boolean m_41386_(DamageSource src) {
        return super.m_41386_(src) && src != DamageSource.f_19321_;
    }

    public static Component toComponent(Attribute attr, AttributeModifier modif) {
        int code;
        String key;
        double amt = modif.m_22218_();
        if (modif.m_22217_() == AttributeModifier.Operation.ADDITION) {
            if (attr == Attributes.f_22278_) {
                amt *= 10.0;
            }
        } else {
            amt *= 100.0;
        }
        String string = key = (code = modif.m_22217_().ordinal()) == 0 ? "attribute.modifier." : "attribute.modifier.apotheosis.";
        if (amt > 0.0) {
            return Component.m_237110_((String)(key + "plus." + code), (Object[])new Object[]{ItemStack.f_41584_.format(amt), Component.m_237115_((String)attr.m_22087_())}).m_130940_(ChatFormatting.BLUE);
        }
        return Component.m_237110_((String)(key + "take." + code), (Object[])new Object[]{ItemStack.f_41584_.format(amt *= -1.0), Component.m_237115_((String)attr.m_22087_())}).m_130940_(ChatFormatting.RED);
    }
}

