/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual;

import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualUtils;
import blusunrize.lib.manual.PositionedItemStack;
import blusunrize.lib.manual.SpecialManualElements;
import blusunrize.lib.manual.gui.GuiButtonManualNavigation;
import blusunrize.lib.manual.gui.ManualScreen;
import blusunrize.lib.manual.utils.ManualRecipeRef;
import blusunrize.lib.manual.utils.PrivateAccess;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.core.NonNullList;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.common.crafting.IShapedRecipe;

public class ManualElementCrafting
extends SpecialManualElements {
    private final ManualRecipeRef[][] recipeRows;
    private final List<PositionedItemStack[]>[] recipeLayout;
    private final int[] recipePage;
    private final int[] heightPixels;

    public ManualElementCrafting(ManualInstance manual, ManualRecipeRef[][] recipeRows) {
        super(manual);
        this.recipeRows = recipeRows;
        this.recipePage = new int[recipeRows.length];
        this.heightPixels = new int[recipeRows.length];
        this.recipeLayout = new List[recipeRows.length];
        for (int i = 0; i < recipeRows.length; ++i) {
            this.recipeLayout[i] = new ArrayList<PositionedItemStack[]>();
        }
        this.recalculateCraftingRecipes();
    }

    @Override
    public void recalculateCraftingRecipes() {
        if (Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        this.providedItems.clear();
        for (int iStack = 0; iStack < this.recipeRows.length; ++iStack) {
            ManualRecipeRef[] row;
            this.recipeLayout[iStack].clear();
            for (ManualRecipeRef recipe : row = this.recipeRows[iStack]) {
                if (recipe.isLayout()) {
                    this.addFixedRecipe(iStack, recipe.getLayout());
                    continue;
                }
                this.checkAllRecipesFor(recipe, iStack);
            }
        }
    }

    private void checkAllRecipesFor(ManualRecipeRef recipeToAdd, int recipeIndex) {
        RecipeManager recipeManager = Minecraft.m_91087_().f_91073_.m_7465_();
        Map recipes = PrivateAccess.getRecipes(recipeManager, RecipeType.f_44107_);
        if (recipeToAdd.isRecipeName()) {
            Recipe recipe = recipes.get(recipeToAdd.getRecipeName());
            if (recipe != null) {
                this.checkRecipe(recipe, recipeToAdd, recipeIndex);
            }
        } else {
            for (Recipe recipe : recipes.values()) {
                this.checkRecipe(recipe, recipeToAdd, recipeIndex);
            }
        }
    }

    private void checkRecipe(Recipe<CraftingContainer> rec, ManualRecipeRef recipeToAdd, int recipeIndex) {
        boolean matches;
        boolean bl = matches = recipeToAdd.isResult() && ManualUtils.stackMatchesObject(rec.m_8043_(), recipeToAdd.getResult());
        if (!matches && recipeToAdd.isRecipeName() && recipeToAdd.getRecipeName().equals((Object)rec.m_6423_())) {
            matches = true;
        }
        if (matches) {
            int recipeHeight;
            int recipeWidth;
            NonNullList ingredientsPre = rec.m_7527_();
            if (rec instanceof IShapedRecipe) {
                IShapedRecipe shaped = (IShapedRecipe)rec;
                recipeWidth = shaped.getRecipeWidth();
                recipeHeight = shaped.getRecipeHeight();
            } else {
                recipeWidth = Mth.m_14045_((int)ingredientsPre.size(), (int)1, (int)3);
                recipeHeight = (ingredientsPre.size() - 1) / 3 + 1;
            }
            int yOffset = (this.heightPixels[recipeIndex] - 18 * recipeHeight) / 2;
            if (yOffset < 0) {
                yOffset = 0;
            }
            PositionedItemStack[] pIngredients = new PositionedItemStack[ingredientsPre.size() + 1];
            int xBase = (120 - (recipeWidth + 2) * 18) / 2;
            for (int heightPos = 0; heightPos < recipeHeight; ++heightPos) {
                for (int widthPos = 0; widthPos < recipeWidth; ++widthPos) {
                    int index = heightPos * recipeWidth + widthPos;
                    if (index >= ingredientsPre.size()) continue;
                    pIngredients[index] = new PositionedItemStack((Ingredient)ingredientsPre.get(index), xBase + widthPos * 18, heightPos * 18 + yOffset);
                }
            }
            pIngredients[pIngredients.length - 1] = new PositionedItemStack(rec.m_8043_(), xBase + recipeWidth * 18 + 18, recipeHeight * 9 - 8 + yOffset);
            if (this.heightPixels[recipeIndex] < recipeHeight * 18) {
                this.heightPixels[recipeIndex] = recipeHeight * 18;
                for (int prevId = 0; prevId <= recipeIndex; ++prevId) {
                    for (PositionedItemStack[] oldStacks : this.recipeLayout[prevId]) {
                        ManualElementCrafting.moveBy(oldStacks, yOffset);
                    }
                }
            }
            this.recipeLayout[recipeIndex].add(pIngredients);
            this.addProvidedItem(rec.m_8043_());
        }
    }

    private void addFixedRecipe(int index, PositionedItemStack[] recipe) {
        int height = 0;
        for (PositionedItemStack stack : recipe) {
            if (stack.y() <= height) continue;
            height = stack.y();
        }
        if (this.heightPixels[index] < (height += 18)) {
            int offset = (height - this.heightPixels[index]) / 2;
            this.heightPixels[index] = height;
            for (int prevId = 0; prevId <= index; ++prevId) {
                for (PositionedItemStack[] oldStacks : this.recipeLayout[prevId]) {
                    ManualElementCrafting.moveBy(oldStacks, offset);
                }
            }
        } else {
            int offset = (this.heightPixels[index] - height) / 2;
            ManualElementCrafting.moveBy(recipe, offset);
        }
        this.recipeLayout[index].add(recipe);
    }

    private static void moveBy(PositionedItemStack[] in, int offY) {
        for (int i = 0; i < in.length; ++i) {
            in[i] = new PositionedItemStack(in[i].displayList(), in[i].x(), in[i].y() + offY);
        }
    }

    @Override
    public void onOpened(ManualScreen gui, int x, int y, List<Button> pageButtons) {
        int recipeYOffset = 0;
        for (int i = 0; i < this.recipeRows.length; ++i) {
            if (this.recipeLayout[i].size() > 1) {
                int iFinal = i;
                pageButtons.add(new GuiButtonManualNavigation(gui, x - 2, y + recipeYOffset + this.heightPixels[i] / 2 - 5, 8, 10, 0, btn -> {
                    int n = iFinal;
                    this.recipePage[n] = this.recipePage[n] - 1;
                    if (this.recipePage[iFinal] < 0) {
                        this.recipePage[iFinal] = this.recipeLayout[iFinal].size() - 1;
                    }
                }));
                pageButtons.add(new GuiButtonManualNavigation(gui, x + 122 - 16, y + recipeYOffset + this.heightPixels[i] / 2 - 5, 8, 10, 1, btn -> {
                    int n = iFinal;
                    this.recipePage[n] = this.recipePage[n] + 1;
                    if (this.recipePage[iFinal] >= this.recipeLayout[iFinal].size()) {
                        this.recipePage[iFinal] = 0;
                    }
                }));
            }
            if (this.recipeLayout[i].size() <= 0) continue;
            recipeYOffset += this.heightPixels[i] + 8;
        }
        super.onOpened(gui, x, y + recipeYOffset - 2, pageButtons);
    }

    @Override
    public void render(PoseStack transform, ManualScreen gui, int x, int y, int mx, int my) {
        List<PositionedItemStack[]> rList;
        int i;
        int totalYOff = 0;
        this.highlighted = ItemStack.f_41583_;
        for (i = 0; i < this.recipeRows.length; ++i) {
            rList = this.recipeLayout[i];
            if (rList.isEmpty() || this.recipePage[i] < 0 || this.recipePage[i] >= rList.size()) continue;
            int maxX = 0;
            PositionedItemStack[] positionedItemStackArray = rList.get(this.recipePage[i]);
            int n = positionedItemStackArray.length;
            for (int j = 0; j < n; ++j) {
                PositionedItemStack pstack = positionedItemStackArray[j];
                if (pstack == null) continue;
                if (pstack.x() > maxX) {
                    maxX = pstack.x();
                }
                GuiComponent.m_93172_((PoseStack)transform, (int)(x + pstack.x()), (int)(y + totalYOff + pstack.y()), (int)(x + pstack.x() + 16), (int)(y + totalYOff + pstack.y() + 16), (int)0x33666666);
            }
            ManualUtils.drawTexturedRect(transform, this.manual.texture, x + maxX - 17, y + totalYOff + this.heightPixels[i] / 2 - 5, 16, 10, 0.0f, 0.0625f, 0.8828125f, 0.921875f);
            totalYOff += this.heightPixels[i] + 8;
        }
        totalYOff = 0;
        for (i = 0; i < this.recipeLayout.length; ++i) {
            rList = this.recipeLayout[i];
            if (rList.isEmpty() || this.recipePage[i] < 0 || this.recipePage[i] >= rList.size()) continue;
            for (PositionedItemStack pstack : rList.get(this.recipePage[i])) {
                if (pstack == null || pstack.getStackAtCurrentTime().m_41619_()) continue;
                ManualUtils.renderItemStack(transform, pstack.getStackAtCurrentTime(), x + pstack.x(), y + totalYOff + pstack.y(), true);
                if (mx < x + pstack.x() || mx >= x + pstack.x() + 16 || my < y + totalYOff + pstack.y() || my >= y + totalYOff + pstack.y() + 16) continue;
                this.highlighted = pstack.getStackAtCurrentTime();
            }
            totalYOff += this.heightPixels[i] + 8;
        }
        this.renderHighlightedTooltip(transform, gui, mx, my);
    }

    @Override
    public boolean listForSearch(String searchTag) {
        ManualRecipeRef[][] manualRecipeRefArray = this.recipeRows;
        int n = manualRecipeRefArray.length;
        for (int i = 0; i < n; ++i) {
            ManualRecipeRef[] row;
            for (ManualRecipeRef recipe : row = manualRecipeRefArray[i]) {
                if (!recipe.isResult() || !ManualUtils.listStack(searchTag, recipe.getResult())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int getPixelsTaken() {
        int yOff = 0;
        for (int heightPixel : this.heightPixels) {
            yOff += heightPixel + 8;
        }
        return yOff;
    }
}

