/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.tool.IElectricEquipment;
import blusunrize.immersiveengineering.api.wires.utils.IElectricDamageSource;
import blusunrize.immersiveengineering.common.entities.RailgunShotEntity;
import blusunrize.immersiveengineering.common.entities.RevolvershotEntity;
import blusunrize.immersiveengineering.common.entities.SawbladeEntity;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class IEDamageSources {
    public static DamageSource acid = new IEDamageSource(Lib.DMG_Acid);
    public static DamageSource crusher = new IEDamageSource(Lib.DMG_Crusher);
    public static DamageSource sawmill = new IEDamageSource(Lib.DMG_Sawmill);
    public static DamageSource razorWire = new IEDamageSource(Lib.DMG_RazorWire);
    public static DamageSource razorShock = new IEDamageSource(Lib.DMG_RazorShock);
    public static DamageSource wireShock = new ElectricDamageSource(Lib.DMG_WireShock, new IElectricEquipment.ElectricSource(1.0f), 1.0f);
    private static final IElectricEquipment.ElectricSource TC_LOW = new IElectricEquipment.ElectricSource(0.25f);
    private static final IElectricEquipment.ElectricSource TC_HIGH = new IElectricEquipment.ElectricSource(2.0f);

    public static DamageSource causeCasullDamage(RevolvershotEntity shot, Entity shooter) {
        if (shooter == null) {
            return new TurretDamageSource(Lib.DMG_RevolverCasull);
        }
        return new IEDamageSource_Indirect(Lib.DMG_RevolverCasull, (Entity)shot, shooter);
    }

    public static DamageSource causePiercingDamage(RevolvershotEntity shot, Entity shooter) {
        if (shooter == null) {
            return new TurretDamageSource(Lib.DMG_RevolverAP).m_19380_();
        }
        return new IEDamageSource_Indirect(Lib.DMG_RevolverAP, (Entity)shot, shooter).m_19380_();
    }

    public static DamageSource causeBuckshotDamage(RevolvershotEntity shot, Entity shooter) {
        if (shooter == null) {
            return new TurretDamageSource(Lib.DMG_RevolverBuck);
        }
        return new IEDamageSource_Indirect(Lib.DMG_RevolverBuck, (Entity)shot, shooter);
    }

    public static DamageSource causeDragonsbreathDamage(RevolvershotEntity shot, Entity shooter) {
        if (shooter == null) {
            return new TurretDamageSource(Lib.DMG_RevolverDragon).m_19383_();
        }
        return new IEDamageSource_Indirect(Lib.DMG_RevolverDragon, (Entity)shot, shooter).m_19383_();
    }

    public static DamageSource causeHomingDamage(RevolvershotEntity shot, Entity shooter) {
        if (shooter == null) {
            return new TurretDamageSource(Lib.DMG_RevolverHoming);
        }
        return new IEDamageSource_Indirect(Lib.DMG_RevolverHoming, (Entity)shot, shooter);
    }

    public static DamageSource causeWolfpackDamage(RevolvershotEntity shot, Entity shooter) {
        if (shooter == null) {
            return new TurretDamageSource(Lib.DMG_RevolverWolfpack);
        }
        return new IEDamageSource_Indirect(Lib.DMG_RevolverWolfpack, (Entity)shot, shooter);
    }

    public static DamageSource causeSilverDamage(RevolvershotEntity shot, Entity shooter) {
        if (shooter == null) {
            return new TurretDamageSource(Lib.DMG_RevolverSilver);
        }
        return new IEDamageSource_Indirect(Lib.DMG_RevolverSilver, (Entity)shot, shooter);
    }

    public static DamageSource causePotionDamage(RevolvershotEntity shot, Entity shooter) {
        if (shooter == null) {
            return new TurretDamageSource(Lib.DMG_RevolverPotion);
        }
        return new IEDamageSource_Indirect(Lib.DMG_RevolverPotion, (Entity)shot, shooter);
    }

    public static ElectricDamageSource causeTeslaDamage(float amount, boolean lowPower) {
        return new ElectricDamageSource(Lib.DMG_Tesla, lowPower ? TC_LOW : TC_HIGH, amount);
    }

    public static ElectricDamageSource causeWireDamage(float amount, IElectricEquipment.ElectricSource source) {
        return new ElectricDamageSource(Lib.DMG_WireShock, source, amount);
    }

    public static DamageSource causeRailgunDamage(RailgunShotEntity shot, Entity shooter) {
        if (shooter == null) {
            return new TurretDamageSource(Lib.DMG_Railgun);
        }
        return new IEDamageSource_Indirect(Lib.DMG_Railgun, (Entity)shot, shooter).m_19380_();
    }

    public static DamageSource causeSawbladeDamage(SawbladeEntity shot, Entity shooter) {
        if (shooter == null) {
            return new TurretDamageSource(Lib.DMG_Sawblade);
        }
        return new IEDamageSource_Indirect(Lib.DMG_Sawblade, (Entity)shot, shooter).m_19380_();
    }

    public static DamageSource causeTeslaPrimaryDamage() {
        return new IEDamageSource(Lib.DMG_Tesla_prim).m_19380_();
    }

    public static class TurretDamageSource
    extends IEDamageSource {
        public TurretDamageSource(String damageTypeIn) {
            super(damageTypeIn);
        }

        public Component m_6157_(LivingEntity entityLivingBaseIn) {
            String s = "death.attack." + this.f_19326_ + ".turret";
            return Component.m_237110_((String)s, (Object[])new Object[]{entityLivingBaseIn.m_5446_()});
        }
    }

    public static class IEDamageSource_Indirect
    extends IndirectEntityDamageSource {
        public IEDamageSource_Indirect(String tag, Entity shot, Entity shooter) {
            super(tag, shot, shooter);
        }
    }

    public static class ElectricDamageSource
    extends DamageSource
    implements IElectricDamageSource {
        public IElectricEquipment.ElectricSource source;
        public float dmg;

        public ElectricDamageSource(String tag, IElectricEquipment.ElectricSource source, float amount) {
            super(tag);
            this.source = source;
            this.dmg = amount;
            this.m_19380_();
        }

        @Override
        public boolean apply(Entity e) {
            if (e instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)e;
                IElectricEquipment.applyToEntity(living, this, this.source);
            }
            if (this.dmg > 0.0f) {
                e.m_6469_((DamageSource)this, this.dmg);
            }
            return this.dmg > 0.0f;
        }

        @Override
        public float getDamage() {
            return this.dmg;
        }
    }

    public static class IEDamageSource
    extends DamageSource {
        public IEDamageSource(String tag) {
            super(tag);
        }
    }

    public static class IEDamageSource_Direct
    extends EntityDamageSource {
        public IEDamageSource_Direct(String tag, Entity attacker) {
            super(tag, attacker);
        }
    }
}

