/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.plant;

import blusunrize.immersiveengineering.common.blocks.plant.EnumHempGrowth;
import blusunrize.immersiveengineering.common.register.IEItems;
import java.util.EnumMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.PlantType;

public class HempBlock
extends BushBlock
implements BonemealableBlock {
    public static final Supplier<BlockBehaviour.Properties> PROPERTIES = () -> BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60918_(SoundType.f_56758_).m_60910_().m_60978_(0.0f).m_60977_();
    public static final EnumProperty<EnumHempGrowth> GROWTH = EnumProperty.m_61587_((String)"growth", EnumHempGrowth.class);
    private static final EnumMap<EnumHempGrowth, VoxelShape> shapes = new EnumMap(EnumHempGrowth.class);

    public HempBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    public void m_49811_(CreativeModeTab group, NonNullList<ItemStack> items) {
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{GROWTH});
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        boolean b = super.m_7898_(state, world, pos);
        if (state.m_61143_(GROWTH) == EnumHempGrowth.TOP0) {
            BlockState stateBelow = world.m_8055_(pos.m_7495_());
            b = stateBelow.m_60734_().equals((Object)this) && stateBelow.m_61143_(GROWTH) == EnumHempGrowth.BOTTOM0.getMax();
        }
        return b;
    }

    protected boolean m_6266_(BlockState state, BlockGetter world, BlockPos pos) {
        return state.m_60734_() == Blocks.f_50093_;
    }

    public PlantType getPlantType(BlockGetter world, BlockPos pos) {
        return PlantType.CROP;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return shapes.getOrDefault(state.m_61143_(GROWTH), Shapes.m_83144_());
    }

    public void onNeighborChange(BlockState state, LevelReader world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(state, world, pos, neighbor);
        if (world.m_8055_(pos).m_61143_(GROWTH) != EnumHempGrowth.TOP0 && world instanceof Level) {
            ((Level)world).m_46672_(pos.m_7918_(0, 1, 0), (Block)this);
        }
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        int light = world.m_46803_(pos);
        if (light >= 12) {
            EnumHempGrowth growth = (EnumHempGrowth)((Object)state.m_61143_(GROWTH));
            if (growth == EnumHempGrowth.TOP0) {
                return;
            }
            float speed = this.getGrowthSpeed((Level)world, pos, state, light);
            if (random.m_188503_((int)(50.0f / speed) + 1) == 0) {
                if (growth.getMax() != growth) {
                    world.m_46597_(pos, (BlockState)state.m_61124_(GROWTH, (Comparable)((Object)growth.next())));
                } else if (world.m_46859_(pos.m_7918_(0, 1, 0))) {
                    world.m_46597_(pos.m_7918_(0, 1, 0), (BlockState)state.m_61124_(GROWTH, (Comparable)((Object)EnumHempGrowth.TOP0)));
                }
            }
        }
    }

    private float getGrowthSpeed(Level world, BlockPos pos, BlockState state, int light) {
        BlockState soil;
        float growth = 0.125f * (float)(light - 11);
        if (world.m_46861_(pos)) {
            growth += 2.0f;
        }
        if ((soil = world.m_8055_(pos.m_7918_(0, -1, 0))).m_60734_().isFertile(soil, (BlockGetter)world, pos.m_7918_(0, -1, 0))) {
            growth *= 1.5f;
        }
        return 1.0f + growth;
    }

    public boolean m_7370_(BlockGetter world, BlockPos pos, BlockState state, boolean isClient) {
        EnumHempGrowth growth = (EnumHempGrowth)((Object)state.m_61143_(GROWTH));
        if (growth != growth.getMax()) {
            return true;
        }
        return growth == EnumHempGrowth.BOTTOM4 && world.m_8055_(pos.m_7918_(0, 1, 0)).m_60734_() != this;
    }

    public boolean m_214167_(Level world, RandomSource rand, BlockPos pos, BlockState state) {
        return this.m_7370_((BlockGetter)world, pos, world.m_8055_(pos), world.f_46443_);
    }

    public void m_214148_(ServerLevel world, RandomSource rand, BlockPos pos, BlockState state) {
        EnumHempGrowth growth = (EnumHempGrowth)((Object)state.m_61143_(GROWTH));
        if (growth != growth.getMax()) {
            int span = growth.getMax().ordinal() - growth.ordinal();
            EnumHempGrowth newGrowth = growth;
            int growBy = rand.m_188503_(span) + 1;
            for (int i = 0; i < growBy; ++i) {
                newGrowth = newGrowth.next();
            }
            world.m_46597_(pos, (BlockState)state.m_61124_(GROWTH, (Comparable)((Object)newGrowth)));
            growth = newGrowth;
        }
        if (growth == EnumHempGrowth.BOTTOM4 && world.m_46859_(pos.m_7918_(0, 1, 0))) {
            world.m_46597_(pos.m_7918_(0, 1, 0), (BlockState)state.m_61124_(GROWTH, (Comparable)((Object)EnumHempGrowth.TOP0)));
        }
    }

    public Item m_5456_() {
        return IEItems.Misc.HEMP_SEEDS.m_5456_();
    }

    static {
        shapes.put(EnumHempGrowth.BOTTOM0, Shapes.m_83064_((AABB)new AABB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0)));
        shapes.put(EnumHempGrowth.BOTTOM1, Shapes.m_83064_((AABB)new AABB(0.0, 0.0, 0.0, 1.0, 0.625, 1.0)));
        shapes.put(EnumHempGrowth.BOTTOM2, Shapes.m_83064_((AABB)new AABB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0)));
    }
}

