/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.items.InternalStorageItem;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.register.IEMenuTypes;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;

public class ToolboxBlockEntity
extends IEBaseBlockEntity
implements IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IBlockBounds,
IIEInventory,
IEBlockInterfaces.IInteractionObjectIE<ToolboxBlockEntity>,
IEBlockInterfaces.IBlockEntityDrop,
IEBlockInterfaces.IPlayerInteraction {
    private final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)23, (Object)ItemStack.f_41583_);
    public Component name;
    private ListTag enchantments;
    private static final VoxelShape boundsZ = Shapes.m_83048_((double)0.125, (double)0.0, (double)0.25, (double)0.875, (double)0.625, (double)0.75);
    private static final VoxelShape boundsX = Shapes.m_83048_((double)0.25, (double)0.0, (double)0.125, (double)0.75, (double)0.625, (double)0.875);

    public ToolboxBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.TOOLBOX.get(), pos, state);
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        if (nbt.m_128425_("name", 8)) {
            this.name = Component.Serializer.m_130701_((String)nbt.m_128461_("name"));
        }
        if (nbt.m_128425_("enchantments", 9)) {
            this.enchantments = nbt.m_128437_("enchantments", 10);
        }
        if (!descPacket) {
            ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        }
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        if (this.name != null) {
            nbt.m_128359_("name", Component.Serializer.m_130703_((Component)this.name));
        }
        if (this.enchantments != null) {
            nbt.m_128365_("enchantments", (Tag)this.enchantments);
        }
        if (!descPacket) {
            ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        }
    }

    @Override
    public boolean interact(Direction side, Player player, InteractionHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        if (player.m_6144_()) {
            if (!this.f_58857_.f_46443_) {
                ItemEntity entityitem = new ItemEntity(this.f_58857_, (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5, this.getPickBlock(player, this.m_58900_(), (HitResult)new BlockHitResult(new Vec3((double)hitX, (double)hitY, (double)hitZ), side, this.f_58858_, false)));
                entityitem.m_32060_();
                this.f_58857_.m_7471_(this.m_58899_(), false);
                this.f_58857_.m_7967_((Entity)entityitem);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canUseGui(Player player) {
        return true;
    }

    @Override
    public ToolboxBlockEntity getGuiMaster() {
        return this;
    }

    @Override
    public IEMenuTypes.BEContainer<ToolboxBlockEntity, ?> getContainerType() {
        return IEMenuTypes.TOOLBOX_BLOCK;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return IEApi.isAllowedInCrate(stack);
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public void doGraphicalUpdates() {
        this.m_6596_();
    }

    @Override
    public List<ItemStack> getBlockEntityDrop(LootContext context) {
        ItemStack stack = new ItemStack(IEItems.Tools.TOOLBOX);
        IEItems.Tools.TOOLBOX.get().setContainedItems(stack, this.inventory);
        if (this.name != null) {
            stack.m_41714_(this.name);
        }
        if (this.enchantments != null) {
            stack.m_41784_().m_128365_("ench", (Tag)this.enchantments);
        }
        return ImmutableList.of((Object)stack);
    }

    @Override
    public void readOnPlacement(LivingEntity placer, ItemStack stack) {
        if (stack.m_41720_() instanceof InternalStorageItem) {
            stack.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(inv -> {
                for (int i = 0; i < inv.getSlots(); ++i) {
                    this.inventory.set(i, (Object)inv.getStackInSlot(i));
                }
            });
            if (stack.m_41788_()) {
                this.name = stack.m_41786_();
            }
            this.enchantments = stack.m_41785_();
        }
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.HORIZONTAL;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return true;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3 hit, LivingEntity entity) {
        return false;
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        return this.getFacing().m_122434_() == Direction.Axis.Z ? boundsZ : boundsX;
    }
}

