/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.entity;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.utils.client.ModelDataUtils;
import blusunrize.immersiveengineering.client.models.obj.callback.DynamicSubmodelCallbacks;
import blusunrize.immersiveengineering.client.render.tile.DynamicModel;
import blusunrize.immersiveengineering.common.entities.SawbladeEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;

public class SawbladeRenderer
extends EntityRenderer<SawbladeEntity> {
    public static final String NAME = "sawblade_entity";
    public static DynamicModel MODEL;
    public static final ResourceLocation SAWBLADE;
    private static final IEProperties.VisibilityList DYNAMIC_GROUPS;

    public SawbladeRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    public void render(SawbladeEntity entity, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        VertexConsumer builder = bufferIn.m_6299_(RenderType.m_110466_());
        BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
        BlockPos blockPos = entity.m_20183_();
        BlockState state = entity.m_20193_().m_8055_(blockPos);
        BakedModel model = MODEL.get();
        matrixStackIn.m_85836_();
        matrixStackIn.m_85841_(0.75f, 0.75f, 0.75f);
        double yaw = entity.f_19859_ + (entity.m_146908_() - entity.f_19859_) * partialTicks - 90.0f;
        double pitch = entity.f_19860_ + (entity.m_146909_() - entity.f_19860_) * partialTicks;
        matrixStackIn.m_85845_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), (float)yaw, true));
        matrixStackIn.m_85845_(new Quaternion(new Vector3f(0.0f, 0.0f, 1.0f), (float)pitch, true));
        if (!entity.f_36703_) {
            float spin = ((float)entity.f_19797_ + partialTicks) % 10.0f / 10.0f * 360.0f;
            matrixStackIn.m_85845_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), spin, true));
        }
        blockRenderer.m_110937_().renderModel(matrixStackIn.m_85850_(), builder, state, model, 1.0f, 1.0f, 1.0f, packedLightIn, OverlayTexture.f_118083_, ModelDataUtils.single(DynamicSubmodelCallbacks.getProperty(), DYNAMIC_GROUPS), RenderType.m_110463_());
        matrixStackIn.m_85849_();
    }

    public ResourceLocation getTextureLocation(@Nonnull SawbladeEntity entity) {
        return SAWBLADE;
    }

    static {
        SAWBLADE = new ResourceLocation("immersiveengineering", "item/sawblade_blade");
        DYNAMIC_GROUPS = IEProperties.VisibilityList.show("blade");
    }
}

