/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.tool.conveyor;

import blusunrize.immersiveengineering.api.tool.conveyor.BasicConveyorCacheData;
import blusunrize.immersiveengineering.api.tool.conveyor.ConveyorHandler;
import blusunrize.immersiveengineering.api.tool.conveyor.ConveyorWall;
import blusunrize.immersiveengineering.api.tool.conveyor.IConveyorBelt;
import blusunrize.immersiveengineering.api.tool.conveyor.IConveyorType;
import com.mojang.math.Transformation;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;

public interface IConveyorModelRender<T extends IConveyorBelt> {
    default public Object getModelCacheKey(RenderContext<T> context) {
        return IConveyorModelRender.getDefaultData(this, context);
    }

    public static <T extends IConveyorBelt> BasicConveyorCacheData getDefaultData(IConveyorModelRender<T> renderer, RenderContext<T> context) {
        T instance = context.instance();
        Block cover = context.getCover();
        if (instance == null) {
            return new BasicConveyorCacheData(cover, Direction.NORTH, ConveyorHandler.ConveyorDirection.HORIZONTAL, true, true, true, DyeColor.WHITE);
        }
        Direction facing = instance.getFacing();
        return new BasicConveyorCacheData(cover, facing, instance.getConveyorDirection(), instance.isActive(), renderer.shouldRenderWall(facing, ConveyorWall.LEFT, context), renderer.shouldRenderWall(facing, ConveyorWall.RIGHT, context), instance.getDyeColour());
    }

    default public Transformation modifyBaseRotationMatrix(Transformation matrix) {
        return matrix;
    }

    public ResourceLocation getActiveTexture();

    public ResourceLocation getInactiveTexture();

    default public ResourceLocation getColouredStripesTexture() {
        return ConveyorHandler.textureConveyorColour;
    }

    default public List<BakedQuad> modifyQuads(List<BakedQuad> baseModel, RenderContext<T> context) {
        return baseModel;
    }

    default public boolean shouldRenderWall(Direction facing, ConveyorWall wall, RenderContext<T> context) {
        T instance = context.instance();
        if (instance == null || instance.getConveyorDirection() != ConveyorHandler.ConveyorDirection.HORIZONTAL) {
            return true;
        }
        Direction side = wall.getWallSide(facing);
        BlockPos pos = instance.getBlockEntity().m_58899_().m_121945_(side);
        return ConveyorHandler.connectsToConveyor(instance.getBlockEntity().m_58904_(), pos, side);
    }

    public record RenderContext<T extends IConveyorBelt>(IConveyorType<T> type, @Nullable T instance, Block coverFallback) {
        public Block getCover() {
            return IConveyorBelt.getCoverOrDefault(this.instance, this.coverFallback);
        }

        public Direction getFacing() {
            return this.instance == null ? Direction.NORTH : this.instance.getFacing();
        }

        public ConveyorHandler.ConveyorDirection getConveyorDirection() {
            return this.instance == null ? ConveyorHandler.ConveyorDirection.HORIZONTAL : this.instance.getConveyorDirection();
        }

        public boolean isActiveOr(boolean fallback) {
            return this.instance == null ? fallback : this.instance.isActive();
        }
    }
}

