/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.hooks;

import java.util.function.DoubleSupplier;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class TriggerMechanism {
    private static final RangeTriggerMechanism DISTANCE_TRIGGER = new RangeTriggerMechanism("dist", () -> 16.0, 10, 0);
    private static final RayTraceTriggerMechanism RAY_TRACE_TRIGGER = new RayTraceTriggerMechanism("ray_trace", 1, 1);
    protected final String name;
    protected final int tickEveryXTicks;
    protected int priority;

    private TriggerMechanism(String name, int tickEveryXTicks, int priority) {
        this.name = name;
        this.tickEveryXTicks = tickEveryXTicks;
        this.priority = priority;
    }

    public static RayTraceTriggerMechanism getRayTrace() {
        return RAY_TRACE_TRIGGER;
    }

    public static RangeTriggerMechanism getDistance() {
        return DISTANCE_TRIGGER;
    }

    public static RangeTriggerMechanism getDistance(double blocks) {
        return new RangeTriggerMechanism(TriggerMechanism.DISTANCE_TRIGGER.name, () -> blocks, TriggerMechanism.DISTANCE_TRIGGER.tickEveryXTicks, TriggerMechanism.DISTANCE_TRIGGER.priority);
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    String getName() {
        return this.name;
    }

    boolean canTick(long ticks) {
        return ticks % (long)this.tickEveryXTicks == 0L;
    }

    boolean isLowerPriority(TriggerMechanism other) {
        return this.priority < other.priority;
    }

    public static final class RayTraceTriggerMechanism
    extends TriggerMechanism {
        private RayTraceTriggerMechanism(String name, int tickEveryXTicks, int priority) {
            super(name, tickEveryXTicks, priority);
        }
    }

    public static final class RangeTriggerMechanism
    extends TriggerMechanism {
        private final DoubleSupplier rangeSupplier;

        private RangeTriggerMechanism(String name, DoubleSupplier rangeSupplier, int tickEveryXTicks, int priority) {
            super(name, tickEveryXTicks, priority);
            this.rangeSupplier = rangeSupplier;
        }

        public double getSearchRange() {
            return this.rangeSupplier.getAsDouble();
        }
    }
}

