/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.controls;

import com.ldtteam.blockui.Alignment;
import com.ldtteam.blockui.PaneParams;
import com.ldtteam.blockui.controls.AbstractTextElement;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.Collections;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;

public class Tooltip
extends AbstractTextElement {
    public static final int DEFAULT_MAX_WIDTH = 208;
    public static final int DEFAULT_MAX_HEIGHT = 1000000;
    private static final int CURSOR_BOX_SIZE = 12;
    private static final int Z_OFFSET = 200;
    private static final int BACKGROUND_COLOR = -267386864;
    private static final int BORDER_COLOR_A = 0x505000FF;
    private static final int BORDER_COLOR_B = 1344798847;
    public static final int DEFAULT_TEXT_COLOR = 0xFFFFFF;
    protected boolean autoWidth = true;
    protected boolean autoHeight = true;
    protected int maxWidth = 208;
    protected int maxHeight = 1000000;

    @Deprecated
    public Tooltip() {
        super(Alignment.TOP_LEFT, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, true, true);
        this.init();
    }

    public Tooltip(PaneParams params) {
        super(params, Alignment.TOP_LEFT, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, true, true);
        this.autoWidth = this.width == 0;
        this.autoHeight = this.height == 0;
        this.init();
    }

    protected void init() {
        this.textLinespace = 1;
        this.textOffsetX = 4;
        this.textOffsetY = 4;
        this.hide();
        this.recalcTextRendering();
    }

    @Override
    protected void recalcTextRendering() {
        if (this.textScale <= 0.0 || this.isTextEmpty()) {
            this.preparedText = Collections.emptyList();
            return;
        }
        if (this.autoWidth) {
            this.textWidth = Math.min(this.text.stream().mapToInt(arg_0 -> ((Font)this.mc.f_91062_).m_92852_(arg_0)).max().orElse(Integer.MAX_VALUE), this.maxWidth - 8) + 1;
        }
        if (this.autoHeight) {
            this.textHeight = this.maxHeight - 8;
        }
        super.recalcTextRendering();
        if (this.autoWidth) {
            this.width = this.renderedTextWidth + 8;
        }
        if (this.autoHeight) {
            this.height = this.renderedTextHeight + 8;
        }
    }

    @Override
    public void setSize(int w, int h) {
        this.autoWidth = w == 0;
        this.autoHeight = h == 0;
        super.setSize(w, h);
    }

    @Override
    public void drawSelf(PoseStack ms, double mx, double my) {
    }

    @Override
    public void drawSelfLast(PoseStack ms, double mx, double my) {
        if (!this.preparedText.isEmpty() && this.enabled) {
            this.x = (int)mx + 12 - 4;
            this.y = (int)my - 12 - 4;
            if (this.x + this.width + 3 > this.window.getScreen().f_96543_) {
                this.x = this.window.getScreen().f_96543_ - this.width - 4;
            }
            if (this.y + this.height + 3 > this.window.getScreen().f_96544_) {
                this.y = this.window.getScreen().f_96544_ - this.height - 4;
            }
            ms.m_85836_();
            ms.m_85837_((double)this.x, (double)this.y, 200.0);
            BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
            Matrix4f mat = ms.m_85850_().m_85861_();
            buffer.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
            int bg_a = 240;
            int bg_r = 16;
            boolean bg_g = false;
            int bg_b = 16;
            buffer.m_85982_(mat, 1.0f, 1.0f, 0.0f).m_6122_(16, 0, 16, 240).m_5752_();
            buffer.m_85982_(mat, 0.0f, 1.0f, 0.0f).m_6122_(16, 0, 16, 240).m_5752_();
            buffer.m_85982_(mat, 0.0f, (float)(this.height - 1), 0.0f).m_6122_(16, 0, 16, 240).m_5752_();
            buffer.m_85982_(mat, 1.0f, (float)(this.height - 1), 0.0f).m_6122_(16, 0, 16, 240).m_5752_();
            buffer.m_85982_(mat, 1.0f, (float)this.height, 0.0f).m_6122_(16, 0, 16, 240).m_5752_();
            buffer.m_85982_(mat, (float)(this.width - 1), (float)this.height, 0.0f).m_6122_(16, 0, 16, 240).m_5752_();
            buffer.m_85982_(mat, (float)(this.width - 1), (float)(this.height - 1), 0.0f).m_6122_(16, 0, 16, 240).m_5752_();
            buffer.m_85982_(mat, (float)this.width, (float)(this.height - 1), 0.0f).m_6122_(16, 0, 16, 240).m_5752_();
            buffer.m_85982_(mat, (float)this.width, 1.0f, 0.0f).m_6122_(16, 0, 16, 240).m_5752_();
            buffer.m_85982_(mat, (float)(this.width - 1), 1.0f, 0.0f).m_6122_(16, 0, 16, 240).m_5752_();
            buffer.m_85982_(mat, (float)(this.width - 1), 0.0f, 0.0f).m_6122_(16, 0, 16, 240).m_5752_();
            buffer.m_85982_(mat, 1.0f, 0.0f, 0.0f).m_6122_(16, 0, 16, 240).m_5752_();
            RenderSystem.m_69472_();
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            Tesselator.m_85913_().m_85914_();
            Tooltip.drawLineRectGradient(ms, 1, 1, this.width - 2, this.height - 2, 0x505000FF, 1344798847, 1);
            RenderSystem.m_69461_();
            RenderSystem.m_69493_();
            ms.m_85837_((double)(-this.x), (double)(-this.y), 0.0);
            super.drawSelf(ms, mx, my);
            ms.m_85849_();
        }
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    @Override
    public boolean isPointInPane(double mx, double my) {
        return false;
    }
}

