/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.entity;

import com.buuz135.industrial.item.infinity.ItemInfinity;
import com.buuz135.industrial.item.infinity.item.ItemInfinityTrident;
import com.buuz135.industrial.module.ModuleTool;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

public class InfinityTridentEntity
extends AbstractArrow {
    private static final EntityDataAccessor<Integer> LOYALTY_LEVEL = SynchedEntityData.m_135353_(InfinityTridentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> CHANNELING = SynchedEntityData.m_135353_(InfinityTridentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> TIER = SynchedEntityData.m_135353_(InfinityTridentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static int DAMAGE = 8;
    private ItemStack thrownStack = new ItemStack((ItemLike)ModuleTool.INFINITY_TRIDENT.get());
    private boolean dealtDamage;
    public int returningTicks;

    public InfinityTridentEntity(EntityType<? extends InfinityTridentEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public InfinityTridentEntity(Level worldIn, LivingEntity thrower, ItemStack thrownStackIn) {
        super((EntityType)ModuleTool.TRIDENT_ENTITY_TYPE.get(), thrower, worldIn);
        this.thrownStack = thrownStackIn.m_41777_();
        this.f_19804_.m_135381_(LOYALTY_LEVEL, (Object)((ItemInfinityTrident)ModuleTool.INFINITY_TRIDENT.get()).getCurrentLoyalty(this.thrownStack));
        this.f_19804_.m_135381_(CHANNELING, (Object)((ItemInfinityTrident)ModuleTool.INFINITY_TRIDENT.get()).getCurrentChanneling(this.thrownStack));
        this.f_19804_.m_135381_(TIER, (Object)ItemInfinity.getSelectedTier(this.thrownStack).getRadius());
    }

    @OnlyIn(value=Dist.CLIENT)
    public InfinityTridentEntity(Level worldIn, double x, double y, double z) {
        super((EntityType)ModuleTool.TRIDENT_ENTITY_TYPE.get(), x, y, z, worldIn);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LOYALTY_LEVEL, (Object)0);
        this.f_19804_.m_135372_(CHANNELING, (Object)false);
        this.f_19804_.m_135372_(TIER, (Object)1);
    }

    public void m_8119_() {
        if (this.f_36704_ > 4 || this.m_20186_() < 0.0) {
            this.dealtDamage = true;
        }
        Entity entity = this.m_37282_();
        if ((this.dealtDamage || this.m_36797_()) && entity != null) {
            int loyaltyLevel = (Integer)this.f_19804_.m_135370_(LOYALTY_LEVEL);
            if (!this.shouldReturnToThrower()) {
                if (!this.f_19853_.f_46443_ && this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                    this.m_5552_(this.m_7941_(), 0.1f);
                }
                this.m_142036_();
            } else if (loyaltyLevel > 0) {
                this.m_36790_(true);
                Vec3 vector3d = new Vec3(entity.m_20185_() - this.m_20185_(), entity.m_20188_() - this.m_20186_(), entity.m_20189_() - this.m_20189_());
                this.m_20343_(this.m_20185_(), this.m_20186_() + vector3d.f_82480_ * 0.015 * (double)loyaltyLevel, this.m_20189_());
                if (this.f_19853_.f_46443_) {
                    this.f_19791_ = this.m_20186_();
                }
                double d0 = 0.05 * (double)loyaltyLevel;
                this.m_20256_(this.m_20184_().m_82490_(0.95).m_82549_(vector3d.m_82541_().m_82490_(d0)));
                if (this.returningTicks == 0) {
                    this.m_5496_(SoundEvents.f_12516_, 10.0f, 1.0f);
                }
                ++this.returningTicks;
            }
        }
        super.m_8119_();
    }

    protected void m_5790_(EntityHitResult p_213868_1_) {
        BlockPos blockpos;
        Entity entity1;
        Entity target = p_213868_1_.m_82443_();
        float damageHit = (float)((double)DAMAGE + Math.pow(2.0, ((Integer)this.f_19804_.m_135370_(TIER)).intValue())) * 0.5f;
        if (target instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)target;
            damageHit += EnchantmentHelper.m_44833_((ItemStack)this.thrownStack, (MobType)livingentity.m_6336_());
        }
        DamageSource damagesource = DamageSource.m_19337_((Entity)this, (Entity)((entity1 = this.m_37282_()) == null ? this : entity1));
        this.dealtDamage = true;
        SoundEvent soundevent = SoundEvents.f_12514_;
        if (target.m_6469_(damagesource, damageHit)) {
            if (target.m_6095_() == EntityType.f_20566_) {
                return;
            }
            if (target instanceof LivingEntity) {
                LivingEntity livingentity1 = (LivingEntity)target;
                if (entity1 instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)livingentity1, (Entity)entity1);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)entity1), (Entity)livingentity1);
                }
                this.m_7761_(livingentity1);
            }
        }
        this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
        float f1 = 1.0f;
        AABB area = new AABB(target.m_20185_(), target.m_20186_(), target.m_20189_(), target.m_20185_(), target.m_20186_(), target.m_20189_()).m_82400_((double)((Integer)this.f_19804_.m_135370_(TIER)).intValue());
        List mobs = this.m_20193_().m_45976_(Mob.class, area);
        if (entity1 instanceof Player) {
            mobs.forEach(mobEntity -> {
                float damage = (float)((double)DAMAGE + Math.pow(2.0, ((Integer)this.f_19804_.m_135370_(TIER)).intValue())) * 0.5f;
                if (target instanceof LivingEntity) {
                    LivingEntity livingentity = (LivingEntity)target;
                    damage += EnchantmentHelper.m_44833_((ItemStack)this.thrownStack, (MobType)livingentity.m_6336_());
                }
                mobEntity.m_6469_(DamageSource.m_19344_((Player)((Player)entity1)), damage);
            });
            this.m_20193_().m_45976_(ItemEntity.class, area.m_82400_(1.0)).forEach(itemEntity -> {
                itemEntity.m_32061_();
                itemEntity.m_6021_((double)entity1.m_20183_().m_123341_(), (double)(entity1.m_20183_().m_123342_() + 1), (double)entity1.m_20183_().m_123343_());
            });
            this.m_20193_().m_45976_(ExperienceOrb.class, area.m_82400_(1.0)).forEach(entityXPOrb -> entityXPOrb.m_6021_((double)entity1.m_20183_().m_123341_(), (double)entity1.m_20183_().m_123342_(), (double)entity1.m_20183_().m_123343_()));
        }
        if (this.f_19853_ instanceof ServerLevel && ((Boolean)this.f_19804_.m_135370_(CHANNELING)).booleanValue() && this.f_19853_.m_45527_(blockpos = target.m_20183_())) {
            LightningBolt lightningboltentity = (LightningBolt)EntityType.f_20465_.m_20615_(this.f_19853_);
            lightningboltentity.m_20219_(Vec3.m_82539_((Vec3i)blockpos));
            lightningboltentity.m_20879_(entity1 instanceof ServerPlayer ? (ServerPlayer)entity1 : null);
            this.f_19853_.m_7967_((Entity)lightningboltentity);
            soundevent = SoundEvents.f_12521_;
            f1 = 5.0f;
            mobs.forEach(mobEntity -> {
                if (this.f_19853_.m_45527_(mobEntity.m_20183_())) {
                    LightningBolt lightningboltentity1 = (LightningBolt)EntityType.f_20465_.m_20615_(this.f_19853_);
                    lightningboltentity1.m_20219_(Vec3.m_82539_((Vec3i)mobEntity.m_20183_()));
                    lightningboltentity1.m_20879_(entity1 instanceof ServerPlayer ? (ServerPlayer)entity1 : null);
                    this.f_19853_.m_7967_((Entity)lightningboltentity1);
                }
            });
        }
        this.m_5496_(soundevent, f1, 1.0f);
    }

    private boolean shouldReturnToThrower() {
        Entity entity = this.m_37282_();
        if (entity != null && entity.m_6084_()) {
            return !(entity instanceof ServerPlayer) || !entity.m_5833_();
        }
        return false;
    }

    protected ItemStack m_7941_() {
        return this.thrownStack.m_41777_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isEnchanted() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6000_(double x, double y, double z) {
        return true;
    }

    public boolean m_6783_(double dist) {
        return dist <= 64.0;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_6901_() {
    }

    protected float m_6882_() {
        return 0.99f;
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("Trident", 10)) {
            this.thrownStack = ItemStack.m_41712_((CompoundTag)compound.m_128469_("Trident"));
        }
        this.dealtDamage = compound.m_128471_("DealtDamage");
        this.f_19804_.m_135381_(LOYALTY_LEVEL, (Object)((ItemInfinityTrident)ModuleTool.INFINITY_TRIDENT.get()).getCurrentLoyalty(this.thrownStack));
        this.f_19804_.m_135381_(CHANNELING, (Object)((ItemInfinityTrident)ModuleTool.INFINITY_TRIDENT.get()).getCurrentChanneling(this.thrownStack));
        this.f_19804_.m_135381_(TIER, (Object)ItemInfinity.getSelectedTier(this.thrownStack).getRadius());
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128365_("Trident", (Tag)this.thrownStack.m_41739_(new CompoundTag()));
        compound.m_128379_("DealtDamage", this.dealtDamage);
    }
}

