/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.generator.mycelial;

import com.buuz135.industrial.block.generator.mycelial.IMycelialGeneratorType;
import com.buuz135.industrial.plugin.jei.generator.MycelialGeneratorRecipe;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class DisenchantmentGeneratorType
implements IMycelialGeneratorType {
    @Override
    public String getName() {
        return "disenchantment";
    }

    @Override
    public IMycelialGeneratorType.Input[] getInputs() {
        return new IMycelialGeneratorType.Input[]{IMycelialGeneratorType.Input.SLOT, IMycelialGeneratorType.Input.SLOT};
    }

    @Override
    public List<BiPredicate<ItemStack, Integer>> getSlotInputPredicates() {
        return Arrays.asList((stack, integer) -> stack.m_41793_() || stack.m_41720_() instanceof EnchantedBookItem, (stack, integer) -> false);
    }

    @Override
    public List<Predicate<FluidStack>> getTankInputPredicates() {
        return new ArrayList<Predicate<FluidStack>>();
    }

    @Override
    public boolean canStart(INBTSerializable<CompoundTag>[] inputs) {
        return inputs.length > 0 && inputs[0] instanceof SidedInventoryComponent && inputs[1] instanceof SidedInventoryComponent && ((SidedInventoryComponent)inputs[0]).getStackInSlot(0).m_41613_() > 0 && this.getSlotInputPredicates().get(0).test(((SidedInventoryComponent)inputs[0]).getStackInSlot(0), 0) && ((SidedInventoryComponent)inputs[1]).getStackInSlot(0).m_41619_();
    }

    @Override
    public Pair<Integer, Integer> getTimeAndPowerGeneration(INBTSerializable<CompoundTag>[] inputs) {
        if (inputs.length > 0 && inputs[0] instanceof SidedInventoryComponent && ((SidedInventoryComponent)inputs[0]).getStackInSlot(0).m_41613_() > 0) {
            ItemStack itemstack = ((SidedInventoryComponent)inputs[0]).getStackInSlot(0).m_41777_();
            ((SidedInventoryComponent)inputs[0]).setStackInSlot(0, ItemStack.f_41583_);
            if (itemstack.m_41720_().equals(Items.f_42690_)) {
                ((SidedInventoryComponent)inputs[1]).setStackInSlot(0, new ItemStack((ItemLike)Items.f_42517_));
            } else {
                ((SidedInventoryComponent)inputs[1]).setStackInSlot(0, new ItemStack((ItemLike)itemstack.m_41720_()));
            }
            return this.calculate(itemstack);
        }
        return Pair.of((Object)0, (Object)80);
    }

    @Override
    public DyeColor[] getInputColors() {
        return new DyeColor[]{DyeColor.LIME, DyeColor.ORANGE};
    }

    @Override
    public Item getDisplay() {
        return Items.f_42690_;
    }

    @Override
    public int getSlotSize() {
        return 1;
    }

    @Override
    public List<MycelialGeneratorRecipe> getRecipes() {
        ArrayList<MycelialGeneratorRecipe> recipes = new ArrayList<MycelialGeneratorRecipe>();
        for (Enchantment value : ForgeRegistries.ENCHANTMENTS.getValues()) {
            for (int i = value.m_44702_(); i <= value.m_6586_(); ++i) {
                HashMap<Enchantment, Integer> map = new HashMap<Enchantment, Integer>();
                map.put(value, i);
                ItemStack book = new ItemStack((ItemLike)Items.f_42690_);
                EnchantmentHelper.m_44865_(map, (ItemStack)book);
                Pair<Integer, Integer> power = this.calculate(book);
                recipes.add(new MycelialGeneratorRecipe(Arrays.asList(Collections.singletonList(Ingredient.m_43927_((ItemStack[])new ItemStack[]{book})), Collections.singletonList(Ingredient.m_43927_((ItemStack[])new ItemStack[]{ItemStack.f_41583_}))), new ArrayList<List<FluidStack>>(), (Integer)power.getLeft(), (Integer)power.getRight()));
            }
        }
        return recipes;
    }

    private Pair<Integer, Integer> calculate(ItemStack stack) {
        Map ench = EnchantmentHelper.m_44831_((ItemStack)stack);
        int rarity = 0;
        double level = 0.0;
        for (Map.Entry enchEntry : ench.entrySet()) {
            rarity += 14 - ((Enchantment)enchEntry.getKey()).m_44699_().m_44716_();
            level += (double)((Integer)enchEntry.getValue()).intValue() / (double)((Enchantment)enchEntry.getKey()).m_6586_();
        }
        return Pair.of((Object)(rarity * 80), (Object)((int)(160.0 * level)));
    }

    @Override
    public ShapedRecipeBuilder addIngredients(ShapedRecipeBuilder recipeBuilder) {
        recipeBuilder = recipeBuilder.m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42517_).m_126127_(Character.valueOf('C'), (ItemLike)Blocks.f_50623_).m_206416_(Character.valueOf('M'), IndustrialTags.Items.MACHINE_FRAME_ADVANCED);
        return recipeBuilder;
    }
}

