/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.agriculturehusbandry.tile;

import com.buuz135.industrial.block.tile.IndustrialAreaWorkingTile;
import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.block.tile.RangeManager;
import com.buuz135.industrial.config.machine.agriculturehusbandry.AnimalBabySeparatorConfig;
import com.buuz135.industrial.gui.component.ItemGuiAddon;
import com.buuz135.industrial.module.ModuleAgricultureHusbandry;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonInfo;
import com.hrznstudio.titanium.component.button.ButtonComponent;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AnimalBabySeparatorTile
extends IndustrialAreaWorkingTile<AnimalBabySeparatorTile> {
    private int maxProgress;
    private int powerPerOperation;
    @Save
    private boolean movingAdults = false;

    public AnimalBabySeparatorTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleAgricultureHusbandry.ANIMAL_BABY_SEPARATOR, RangeManager.RangeType.BEHIND, true, AnimalBabySeparatorConfig.powerPerOperation, blockPos, blockState);
        this.addButton(new ButtonComponent(42, 20, 18, 18){

            @OnlyIn(value=Dist.CLIENT)
            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new StateButtonAddon(this, new StateButtonInfo[]{new StateButtonInfo(0, AssetTypes.ITEM_BACKGROUND, new String[]{"Moving babies"}), new StateButtonInfo(1, AssetTypes.ITEM_BACKGROUND, new String[]{"Moving adults"})}){

                    public int getState() {
                        return AnimalBabySeparatorTile.this.movingAdults ? 1 : 0;
                    }
                });
            }
        }.setPredicate((playerEntity, compoundNBT) -> {
            this.movingAdults = !this.movingAdults;
            this.markForUpdate();
        }));
        this.maxProgress = AnimalBabySeparatorConfig.maxProgress;
        this.powerPerOperation = AnimalBabySeparatorConfig.powerPerOperation;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initClient() {
        super.initClient();
        this.addGuiAddonFactory(() -> new ItemGuiAddon(42, 20){

            @Override
            public ItemStack getItemStack() {
                return new ItemStack((ItemLike)(AnimalBabySeparatorTile.this.movingAdults ? Items.f_42405_ : Items.f_42404_));
            }
        }.withoutTooltip());
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        if (this.f_58857_ != null && this.hasEnergy(this.powerPerOperation)) {
            List mobs = this.f_58857_.m_45976_(Animal.class, this.getWorkingArea().m_83215_());
            mobs.removeIf(animalEntity -> !animalEntity.m_6162_() == !this.movingAdults);
            if (mobs.size() == 0) {
                return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
            }
            BlockPos pos = this.m_58899_().m_121945_(this.getFacingDirection());
            ((Animal)mobs.get(0)).m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            return new IndustrialWorkingTile.WorkAction(this, 0.25f, this.powerPerOperation);
        }
        return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
    }

    protected EnergyStorageComponent<AnimalBabySeparatorTile> createEnergyStorage() {
        return new EnergyStorageComponent(AnimalBabySeparatorConfig.maxStoredPower, 10, 20);
    }

    @Override
    public int getMaxProgress() {
        return this.maxProgress;
    }

    @Nonnull
    public AnimalBabySeparatorTile getSelf() {
        return this;
    }
}

