/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.item.reactor;

import dev.ftb.mods.ftbic.block.entity.generator.NuclearReactorBlockEntity;
import dev.ftb.mods.ftbic.item.reactor.BaseReactorItem;
import dev.ftb.mods.ftbic.item.reactor.NuclearReactor;
import dev.ftb.mods.ftbic.item.reactor.ReactorItem;
import dev.ftb.mods.ftbic.util.FTBICUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class HeatExchangerItem
extends BaseReactorItem {
    public final int heatTransferToAdjacent;
    public final int heatTransferToCore;

    public HeatExchangerItem(int durability, int a, int c) {
        super(durability);
        this.heatTransferToAdjacent = a;
        this.heatTransferToCore = c;
    }

    @Override
    public boolean isHeatAcceptor(ItemStack stack) {
        return stack.m_41776_() > 0;
    }

    @Override
    public void reactorInfo(ItemStack stack, List<Component> list, boolean shift, boolean advanced, @Nullable NuclearReactor reactor, int x, int y) {
        if (stack.m_41776_() > 0) {
            list.add((Component)Component.m_237113_((String)"Coolant: ").m_7220_(FTBICUtils.formatHeat(stack.m_41776_() - stack.m_41773_())).m_130940_(ChatFormatting.GRAY));
        }
        list.add((Component)Component.m_237113_((String)"Heat Transfer to Adjacent: ").m_7220_(FTBICUtils.formatHeat(this.heatTransferToAdjacent)).m_130946_("/s").m_130940_(ChatFormatting.GRAY));
        list.add((Component)Component.m_237113_((String)"Heat Transfer to Core: ").m_7220_(FTBICUtils.formatHeat(this.heatTransferToCore)).m_130946_("/s").m_130940_(ChatFormatting.GRAY));
    }

    @Override
    public void reactorTickPre(NuclearReactor reactor, ItemStack stack, int x, int y) {
        int damage = 0;
        if (this.heatTransferToAdjacent > 0) {
            for (int i = 0; i < 4; ++i) {
                ReactorItem reactorItem;
                ItemStack is = reactor.getAt(x + NuclearReactorBlockEntity.OFFSET_X[i], y + NuclearReactorBlockEntity.OFFSET_Y[i]);
                Item item = is.m_41720_();
                if (!(item instanceof ReactorItem) || !(reactorItem = (ReactorItem)item).isHeatAcceptor(is)) continue;
                double sh = this.getRelativeDamage(stack) * 100.0;
                double rh = reactorItem.getRelativeDamage(is) * 100.0;
                int heat = this.getHeatTransfer(sh, rh, is.m_41776_(), this.heatTransferToAdjacent);
                damage -= heat;
                damage += reactorItem.damageReactorItem(is, heat);
            }
        }
        if (this.heatTransferToCore > 0) {
            double sh = this.getRelativeDamage(stack) * 100.0;
            double rh = (double)reactor.heat * 100.0 / (double)reactor.maxHeat;
            int heat = this.getHeatTransfer(sh, rh, reactor.maxHeat, this.heatTransferToCore);
            damage -= heat;
            reactor.addHeat(heat);
        }
        this.damageReactorItem(stack, damage);
    }

    private int getHeatTransfer(double sh, double rh, int max, int transfer) {
        double hh = rh + sh / 2.0;
        int add = Math.min(Mth.m_14107_((double)((double)max * hh / 100.0)), transfer);
        if (hh < 0.25) {
            add = 1;
        } else if (hh < 0.5) {
            add = transfer / 8;
        } else if (hh < 0.75) {
            add = transfer / 4;
        } else if (hh < 1.0) {
            add = transfer / 2;
        }
        double frh = (double)Mth.m_14107_((double)(rh * 10.0)) / 10.0;
        double fsh = (double)Mth.m_14107_((double)(sh * 10.0)) / 10.0;
        if (frh > fsh) {
            add -= 2 * add;
        } else if (frh == fsh) {
            add = 0;
        }
        return add;
    }
}

