/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tubemodules;

import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import me.desht.pneumaticcraft.common.block.entity.PressureTubeBlockEntity;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.tubemodules.AbstractRedstoneReceivingModule;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;

public class SafetyValveModule
extends AbstractRedstoneReceivingModule {
    private boolean inited = false;

    public SafetyValveModule(Direction dir, PressureTubeBlockEntity pressureTube) {
        super(dir, pressureTube);
    }

    @Override
    public Item getItem() {
        return (Item)ModItems.SAFETY_TUBE_MODULE.get();
    }

    @Override
    public void tickServer() {
        super.tickServer();
        if (!this.inited) {
            ((IAirHandlerMachine)this.pressureTube.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY).orElseThrow(RuntimeException::new)).enableSafetyVenting(p -> p.floatValue() > this.getThreshold(), this.getDirection());
            this.inited = true;
        }
    }

    @Override
    public float getThreshold() {
        if (this.upgraded) {
            return super.getThreshold();
        }
        return this.getTube().getDangerPressure() == 20.0f ? 19.9f : 4.92f;
    }

    @Override
    public void onRemoved() {
        if (!this.pressureTube.nonNullLevel().f_46443_) {
            this.pressureTube.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY).ifPresent(h -> {
                h.disableSafetyVenting();
                h.setSideLeaking(null);
            });
        }
    }
}

