/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tubemodules;

import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.IntStream;
import me.desht.pneumaticcraft.common.block.entity.PressureTubeBlockEntity;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSyncRedstoneModuleToClient;
import me.desht.pneumaticcraft.common.thirdparty.ModdedWrenchUtils;
import me.desht.pneumaticcraft.common.tubemodules.AbstractRedstoneEmittingModule;
import me.desht.pneumaticcraft.common.tubemodules.AbstractTubeModule;
import me.desht.pneumaticcraft.common.tubemodules.INetworkedModule;
import me.desht.pneumaticcraft.common.tubemodules.ModuleNetworkManager;
import me.desht.pneumaticcraft.common.util.ITranslatableEnum;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class RedstoneModule
extends AbstractTubeModule
implements INetworkedModule {
    private EnumRedstoneDirection redstoneDirection = EnumRedstoneDirection.OUTPUT;
    private int inputLevel = -1;
    private int outputLevel;
    private int colorChannel;
    private Operation operation = Operation.PASSTHROUGH;
    private boolean inverted = false;
    private int otherColor = 0;
    private int constantVal = 0;
    private final byte[] prevLevels = new byte[16];
    public float extension = 1.0f;
    public float lastExtension;
    private boolean comparatorInput;

    public RedstoneModule(Direction dir, PressureTubeBlockEntity pressureTube) {
        super(dir, pressureTube);
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void onNeighborBlockUpdate() {
        if (!this.comparatorInput) {
            this.updateInputLevel();
        }
    }

    @Override
    public void onNeighborTileUpdate() {
        if (this.comparatorInput) {
            this.updateInputLevel();
        }
    }

    @Override
    public double getWidth() {
        return 9.0;
    }

    @Override
    protected double getHeight() {
        return 5.0;
    }

    @Override
    public Item getItem() {
        return (Item)ModItems.REDSTONE_MODULE.get();
    }

    @Override
    public void tickServer() {
        super.tickServer();
        byte[] levels = new byte[16];
        if (this.redstoneDirection == EnumRedstoneDirection.OUTPUT) {
            for (AbstractTubeModule module : ModuleNetworkManager.getInstance(this.getTube().nonNullLevel()).getConnectedModules(this)) {
                RedstoneModule mr;
                if (!(module instanceof RedstoneModule) || (mr = (RedstoneModule)module).getRedstoneDirection() != EnumRedstoneDirection.INPUT || mr.getInputLevel() <= levels[mr.getColorChannel()]) continue;
                levels[mr.getColorChannel()] = (byte)mr.inputLevel;
            }
            int out = this.computeOutputSignal(this.outputLevel, levels);
            if (this.inverted) {
                int n = out = out > 0 ? 0 : 15;
            }
            if (this.setOutputLevel(out)) {
                NetworkHandler.sendToAllTracking((Object)new PacketSyncRedstoneModuleToClient(this), this.getTube());
            }
        } else if (this.inputLevel < 0) {
            this.updateInputLevel();
        }
        System.arraycopy(levels, 0, this.prevLevels, 0, 16);
    }

    @Override
    public void tickClient() {
        super.tickClient();
        this.lastExtension = this.extension;
        this.extension = this.redstoneDirection == EnumRedstoneDirection.OUTPUT ? Math.min(1.0f, this.extension + 0.125f) : Math.max(0.0f, this.extension - 0.125f);
    }

    private int computeOutputSignal(int lastOutput, byte[] levels) {
        byte s1 = levels[this.getColorChannel()];
        byte s1prev = this.prevLevels[this.getColorChannel()];
        byte s2 = levels[this.otherColor];
        return this.operation.signalFunction.compute(lastOutput, s1, s2, this.getTube().nonNullLevel().m_46467_(), this.constantVal, s1 > s1prev);
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        tag.m_128379_("input", this.redstoneDirection == EnumRedstoneDirection.INPUT);
        tag.m_128344_("channel", (byte)this.colorChannel);
        tag.m_128344_("outputLevel", (byte)this.outputLevel);
        tag.m_128359_("op", this.operation.toString());
        tag.m_128344_("color2", (byte)this.otherColor);
        tag.m_128405_("const", (int)((byte)this.constantVal));
        tag.m_128379_("invert", this.inverted);
        tag.m_128356_("prevLevels", this.encodeLevels(this.prevLevels));
        tag.m_128379_("comparatorInput", this.comparatorInput);
        return tag;
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.redstoneDirection = tag.m_128471_("input") ? EnumRedstoneDirection.INPUT : EnumRedstoneDirection.OUTPUT;
        this.colorChannel = tag.m_128445_("channel");
        this.outputLevel = tag.m_128445_("outputLevel");
        try {
            this.operation = tag.m_128441_("op") ? Operation.valueOf(tag.m_128461_("op")) : Operation.PASSTHROUGH;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            this.operation = Operation.PASSTHROUGH;
        }
        this.otherColor = tag.m_128445_("color2");
        this.constantVal = tag.m_128451_("const");
        this.inverted = tag.m_128471_("invert");
        this.decodeLevels(tag.m_128454_("prevLevels"), this.prevLevels);
        this.comparatorInput = tag.m_128471_("comparatorInput");
    }

    private long encodeLevels(byte[] l) {
        return IntStream.range(0, l.length).mapToLong(i -> (long)l[i] << 4 * i).reduce(0L, (a, b) -> a | b);
    }

    private void decodeLevels(long l, byte[] res) {
        for (int i = 0; i < res.length; ++i) {
            res[i] = (byte)(l >> 4 * i | 0xFL);
        }
    }

    public EnumRedstoneDirection getRedstoneDirection() {
        return this.redstoneDirection;
    }

    public void setRedstoneDirection(EnumRedstoneDirection redstoneDirection) {
        this.redstoneDirection = redstoneDirection;
        this.setChanged();
    }

    @Override
    public int getRedstoneLevel() {
        return this.redstoneDirection == EnumRedstoneDirection.OUTPUT ? this.outputLevel : 0;
    }

    public boolean setOutputLevel(int level) {
        if ((level = Mth.m_14045_((int)level, (int)0, (int)15)) != this.outputLevel) {
            this.outputLevel = level;
            this.updateNeighbors();
            return true;
        }
        return false;
    }

    public int getInputLevel() {
        return this.inputLevel;
    }

    public void setInputLevel(int level) {
        this.inputLevel = level;
    }

    @Override
    public int getColorChannel() {
        return this.colorChannel;
    }

    @Override
    public void setColorChannel(int channel) {
        this.colorChannel = channel;
        this.setChanged();
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setInverted(boolean inverted) {
        this.inverted = inverted;
        this.setChanged();
    }

    public boolean isComparatorInput() {
        return this.comparatorInput;
    }

    public void setComparatorInput(boolean comparatorInput) {
        this.comparatorInput = comparatorInput;
        this.setChanged();
    }

    @Override
    public void addInfo(List<Component> curInfo) {
        super.addInfo(curInfo);
        if (this.getRedstoneDirection() == EnumRedstoneDirection.INPUT) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.waila.redstoneModule.receiving", this.inputLevel));
        } else {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.waila.redstoneModule.emitting", this.outputLevel));
            if (this.upgraded) {
                this.addAdvancedInfo(curInfo);
            }
        }
    }

    private void addAdvancedInfo(List<Component> curInfo) {
        MutableComponent s = Component.m_237110_((String)"pneumaticcraft.waila.redstoneModule.op", (Object[])new Object[]{PneumaticCraftUtils.xlate(this.operation.getTranslationKey(), new Object[0])});
        if (this.operation.useOtherColor) {
            s = s.m_130946_(" (").m_7220_((Component)PneumaticCraftUtils.dyeColorDesc(this.otherColor)).m_130946_(")");
        }
        if (this.operation.useConst) {
            s = s.m_130946_(" (" + this.constantVal + ")");
        }
        curInfo.add((Component)s);
        if (this.inverted) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.waila.redstoneModule.inverted", new Object[0]));
        }
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand) {
        ItemStack heldStack = player.m_21120_(hand);
        DyeColor dyeColor = DyeColor.getColor((ItemStack)heldStack);
        if (dyeColor != null) {
            int colorId = dyeColor.m_41060_();
            this.setColorChannel(colorId);
            if (((Boolean)ConfigHelper.common().general.useUpDyesWhenColoring.get()).booleanValue() && !player.m_7500_()) {
                heldStack.m_41774_(1);
            }
            return true;
        }
        if (ModdedWrenchUtils.getInstance().isWrench(heldStack)) {
            this.redstoneDirection = this.redstoneDirection == EnumRedstoneDirection.INPUT ? EnumRedstoneDirection.OUTPUT : EnumRedstoneDirection.INPUT;
            this.updateNeighbors();
            if (!this.updateInputLevel()) {
                NetworkHandler.sendToAllTracking((Object)new PacketSyncRedstoneModuleToClient(this), this.getTube());
            }
            return true;
        }
        return super.onActivated(player, hand);
    }

    private boolean updateInputLevel() {
        int newInputLevel = this.redstoneDirection == EnumRedstoneDirection.INPUT ? this.readInputLevel() : 0;
        if ((newInputLevel = Math.max(newInputLevel, this.pressureTube.tubeModules().filter(tm -> tm instanceof AbstractRedstoneEmittingModule).max(Comparator.comparingInt(AbstractTubeModule::getRedstoneLevel)).map(AbstractTubeModule::getRedstoneLevel).orElse(0))) != this.inputLevel) {
            this.inputLevel = newInputLevel;
            NetworkHandler.sendToAllTracking((Object)new PacketSyncRedstoneModuleToClient(this), this.getTube());
            return true;
        }
        return false;
    }

    private int readInputLevel() {
        Level world = Objects.requireNonNull(this.pressureTube.m_58904_());
        if (this.comparatorInput && this.upgraded) {
            BlockPos pos2 = this.pressureTube.m_58899_().m_121945_(this.getDirection());
            BlockState state = world.m_8055_(pos2);
            return state.m_60807_() ? state.m_60674_(world, pos2) : 0;
        }
        return world.m_46681_(this.pressureTube.m_58899_().m_121945_(this.getDirection()), this.getDirection());
    }

    public Operation getOperation() {
        return this.operation;
    }

    public int getOtherColor() {
        return this.otherColor;
    }

    public int getConstantVal() {
        return this.constantVal;
    }

    public void setOperation(Operation operation, int otherColor, int constantVal) {
        if (operation == Operation.CLOCK) {
            constantVal = Math.max(4, constantVal);
        }
        this.operation = operation;
        this.otherColor = otherColor;
        this.constantVal = constantVal;
        this.setChanged();
    }

    public static enum EnumRedstoneDirection implements ITranslatableEnum
    {
        INPUT,
        OUTPUT;


        public EnumRedstoneDirection toggle() {
            return this == INPUT ? OUTPUT : INPUT;
        }

        @Override
        public String getTranslationKey() {
            return "pneumaticcraft.gui.redstoneModule." + this.toString().toLowerCase(Locale.ROOT);
        }
    }

    public static enum Operation implements ITranslatableEnum
    {
        PASSTHROUGH(false, false, (lastOutput, s1, s2, timer, constant, s1rising) -> s1),
        AND(true, false, (lastOutput, s1, s2, timer, constant, s1rising) -> s1 > 0 && s2 > 0 ? 15 : 0),
        OR(true, false, (lastOutput, s1, s2, timer, constant, s1rising) -> s1 > 0 || s2 > 0 ? 15 : 0),
        XOR(true, false, (lastOutput, s1, s2, timer, constant, s1rising) -> s1 == 0 && s2 == 0 || s1 > 0 && s2 > 0 ? 0 : 15),
        CLOCK(false, true, (lastOutput, s1, s2, timer, constant, s1rising) -> s1 == 0 && timer % (long)constant < 2L ? 15 : 0, 4, Integer.MAX_VALUE),
        COMPARATOR(true, false, (lastOutput, s1, s2, timer, constant, s1rising) -> s1 > s2 ? 15 : 0),
        SUBTRACT(true, false, (lastOutput, s1, s2, timer, constant, s1rising) -> Mth.m_14045_((int)(s1 - s2), (int)0, (int)15)),
        COMPARE(false, true, (lastOutput, s1, s2, timer, constant, s1rising) -> s1 > constant ? 15 : 0, 0, 15),
        TOGGLE(false, false, (lastOutput, s1, s2, timer, constant, s1rising) -> s1rising ? (lastOutput > 0 ? 0 : 15) : lastOutput),
        CONSTANT(false, true, (lastOutput, s1, s2, timer, constant, s1rising) -> constant, 0, 15),
        COUNTER(false, true, (lastOutput, s1, s2, timer, constant, s1rising) -> s1rising ? (lastOutput + 1 > Math.min(15, constant) ? 0 : lastOutput + 1) : lastOutput, 0, 15);

        private final boolean useOtherColor;
        private final boolean useConst;
        private final int constMin;
        private final int constMax;
        private final SignalFunction signalFunction;

        private Operation(boolean useOtherColor, boolean useConst, SignalFunction signalFunction) {
            this(useOtherColor, useConst, signalFunction, 0, 0);
        }

        private Operation(boolean useOtherColor, boolean useConst, SignalFunction signalFunction, int constMin, int constMax) {
            this.useOtherColor = useOtherColor;
            this.useConst = useConst;
            this.signalFunction = signalFunction;
            this.constMin = constMin;
            this.constMax = constMax;
        }

        @Override
        public String getTranslationKey() {
            return "pneumaticcraft.gui.redstoneModule.operation_" + this.toString().toLowerCase(Locale.ROOT);
        }

        public boolean useOtherColor() {
            return this.useOtherColor;
        }

        public boolean useConstant() {
            return this.useConst;
        }

        public int getConstMin() {
            return this.constMin;
        }

        public int getConstMax() {
            return this.constMax;
        }
    }

    @FunctionalInterface
    private static interface SignalFunction {
        public int compute(int var1, byte var2, byte var3, long var4, int var6, boolean var7);
    }
}

