/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.amadron.AmadronOfferManager;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.inventory.AmadronAddTradeMenu;
import me.desht.pneumaticcraft.common.item.AmadronTabletItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketAbstractAmadronTrade;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronPlayerOffer;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class PacketAmadronTradeAddCustom
extends PacketAbstractAmadronTrade {
    public PacketAmadronTradeAddCustom(AmadronPlayerOffer offer) {
        super(offer);
    }

    public PacketAmadronTradeAddCustom(FriendlyByteBuf buffer) {
        super(buffer);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            AmadronPlayerOffer offer = this.getOffer();
            if (player == null) {
                this.handleClientSide(offer);
            } else {
                this.handleServerSide(player, offer);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private void handleServerSide(ServerPlayer player, AmadronPlayerOffer offer) {
        if (player.f_36096_ instanceof AmadronAddTradeMenu) {
            offer.updatePlayerId();
            if (AmadronOfferManager.getInstance().hasSimilarPlayerOffer(offer.getReversedOffer())) {
                player.m_5661_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.message.amadron.duplicateReversedOffer", new Object[0]), false);
            } else if (AmadronOfferManager.getInstance().addPlayerOffer(offer)) {
                if (((Boolean)ConfigHelper.common().amadron.notifyOfTradeAddition.get()).booleanValue()) {
                    NetworkHandler.sendToAll(this);
                }
                if (player.m_21205_().m_41720_() == ModItems.AMADRON_TABLET.get()) {
                    AmadronTabletItem.openGui((Player)player, InteractionHand.MAIN_HAND);
                } else if (player.m_21206_().m_41720_() == ModItems.AMADRON_TABLET.get()) {
                    AmadronTabletItem.openGui((Player)player, InteractionHand.OFF_HAND);
                }
            } else {
                player.m_5661_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.message.amadron.duplicateOffer", new Object[0]), false);
            }
        }
    }

    private void handleClientSide(AmadronPlayerOffer offer) {
        if (((Boolean)ConfigHelper.common().amadron.notifyOfTradeAddition.get()).booleanValue()) {
            ClientUtils.getClientPlayer().m_5661_((Component)Component.m_237110_((String)"pneumaticcraft.message.amadron.playerAddedTrade", (Object[])new Object[]{offer.getVendorName(), offer.getOutput().toString(), offer.getInput().toString()}), false);
        }
    }
}

