/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.item.IPositionProvider;
import me.desht.pneumaticcraft.common.amadron.ShoppingBasket;
import me.desht.pneumaticcraft.common.block.entity.ChargingStationBlockEntity;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModMenuTypes;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.inventory.AmadronMenu;
import me.desht.pneumaticcraft.common.inventory.ChargingStationUpgradeManagerMenu;
import me.desht.pneumaticcraft.common.item.IChargeableContainerProvider;
import me.desht.pneumaticcraft.common.item.PressurizableItem;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.GlobalPosHelper;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.NBTUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class AmadronTabletItem
extends PressurizableItem
implements IPositionProvider,
IChargeableContainerProvider {
    public AmadronTabletItem() {
        super(ModItems.toolProps(), 30000, 3000);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (!worldIn.f_46443_) {
            AmadronTabletItem.openGui(playerIn, handIn);
        }
        return InteractionResultHolder.m_19090_((Object)playerIn.m_21120_(handIn));
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        BlockPos pos;
        Direction facing = ctx.m_43719_();
        Player player = ctx.m_43723_();
        Level worldIn = ctx.m_43725_();
        BlockEntity te = worldIn.m_7702_(pos = ctx.m_8083_());
        if (te == null || player == null) {
            return InteractionResult.PASS;
        }
        if (te.getCapability(ForgeCapabilities.FLUID_HANDLER, facing).isPresent()) {
            if (!worldIn.f_46443_) {
                AmadronTabletItem.setFluidProvidingLocation(player.m_21120_(ctx.m_43724_()), GlobalPosHelper.makeGlobalPos(worldIn, pos));
            } else {
                player.m_5496_((SoundEvent)ModSounds.CHIRP.get(), 1.0f, 1.5f);
            }
        } else if (te.getCapability(ForgeCapabilities.ITEM_HANDLER, facing).isPresent()) {
            if (!worldIn.f_46443_) {
                AmadronTabletItem.setItemProvidingLocation(player.m_21120_(ctx.m_43724_()), GlobalPosHelper.makeGlobalPos(worldIn, pos));
            } else {
                player.m_5496_((SoundEvent)ModSounds.CHIRP.get(), 1.0f, 1.5f);
            }
        } else {
            return InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> infoList, TooltipFlag flag) {
        super.m_7373_(stack, worldIn, infoList, flag);
        GlobalPos gPos = AmadronTabletItem.getItemProvidingLocation(stack);
        if (gPos != null) {
            infoList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.amadronTablet.itemLocation", GlobalPosHelper.prettyPrint(gPos)).m_130940_(ChatFormatting.YELLOW));
        } else {
            infoList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.amadronTablet.selectItemLocation", new Object[0]));
        }
        gPos = AmadronTabletItem.getFluidProvidingLocation(stack);
        if (gPos != null) {
            infoList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.amadronTablet.fluidLocation", GlobalPosHelper.prettyPrint(gPos)).m_130940_(ChatFormatting.YELLOW));
        } else {
            infoList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.amadronTablet.selectFluidLocation", new Object[0]));
        }
    }

    public static LazyOptional<IItemHandler> getItemCapability(ItemStack tablet) {
        GlobalPos pos = AmadronTabletItem.getItemProvidingLocation(tablet);
        if (pos != null) {
            BlockEntity te = GlobalPosHelper.getTileEntity(pos);
            for (Direction dir : DirectionUtil.VALUES) {
                LazyOptional<IItemHandler> lazy = IOHelper.getInventoryForTE(te, dir);
                if (!lazy.isPresent()) continue;
                return lazy;
            }
        }
        return LazyOptional.empty();
    }

    public static GlobalPos getItemProvidingLocation(ItemStack tablet) {
        return tablet.m_41782_() && Objects.requireNonNull(tablet.m_41783_()).m_128441_("itemPos") ? GlobalPosHelper.fromNBT(tablet.m_41783_().m_128469_("itemPos")) : null;
    }

    private static void setItemProvidingLocation(ItemStack tablet, GlobalPos globalPos) {
        NBTUtils.setCompoundTag(tablet, "itemPos", GlobalPosHelper.toNBT(globalPos));
    }

    public static LazyOptional<IFluidHandler> getFluidCapability(ItemStack tablet) {
        GlobalPos pos = AmadronTabletItem.getFluidProvidingLocation(tablet);
        if (pos != null) {
            BlockEntity te = GlobalPosHelper.getTileEntity(pos);
            for (Direction dir : DirectionUtil.VALUES) {
                LazyOptional<IFluidHandler> lazy = IOHelper.getFluidHandlerForTE(te, dir);
                if (!lazy.isPresent()) continue;
                return lazy;
            }
        }
        return LazyOptional.empty();
    }

    public static GlobalPos getFluidProvidingLocation(ItemStack tablet) {
        return tablet.m_41782_() && Objects.requireNonNull(tablet.m_41783_()).m_128441_("liquidPos") ? GlobalPosHelper.fromNBT(tablet.m_41783_().m_128469_("liquidPos")) : null;
    }

    private static void setFluidProvidingLocation(ItemStack tablet, GlobalPos globalPos) {
        NBTUtils.setCompoundTag(tablet, "liquidPos", GlobalPosHelper.toNBT(globalPos));
    }

    @Nonnull
    public static ShoppingBasket loadShoppingCart(ItemStack tablet) {
        if (!(tablet.m_41720_() instanceof AmadronTabletItem)) {
            return new ShoppingBasket();
        }
        return ShoppingBasket.fromNBT(tablet.m_41737_("shoppingCart"));
    }

    public static void saveShoppingCart(ItemStack tablet, ShoppingBasket cart) {
        if (tablet.m_41720_() instanceof AmadronTabletItem) {
            NBTUtils.setCompoundTag(tablet, "shoppingCart", (Tag)cart.toNBT());
        }
    }

    @Override
    @NotNull
    public List<BlockPos> getStoredPositions(UUID playerId, @NotNull ItemStack stack) {
        GlobalPos gp1 = AmadronTabletItem.getItemProvidingLocation(stack);
        GlobalPos gp2 = AmadronTabletItem.getFluidProvidingLocation(stack);
        return Arrays.asList(gp1 == null ? null : gp1.m_122646_(), gp2 == null ? null : gp2.m_122646_());
    }

    @Override
    public int getRenderColor(int index) {
        return switch (index) {
            case 0 -> -1868543730;
            case 1 -> -1878998848;
            default -> -1;
        };
    }

    public static void openGui(final Player playerIn, final InteractionHand handIn) {
        NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)playerIn), (MenuProvider)new MenuProvider(){

            public Component m_5446_() {
                return playerIn.m_21120_(handIn).m_41786_();
            }

            public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player playerEntity) {
                return new AmadronMenu(windowId, playerInventory, handIn);
            }
        }, buf -> buf.writeBoolean(handIn == InteractionHand.MAIN_HAND));
    }

    @Override
    public MenuProvider getContainerProvider(ChargingStationBlockEntity te) {
        return new IChargeableContainerProvider.Provider(te, (MenuType<? extends ChargingStationUpgradeManagerMenu>)((MenuType)ModMenuTypes.CHARGING_AMADRON.get()));
    }
}

