/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import com.google.common.collect.ImmutableList;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.item.PNCUpgrade;
import me.desht.pneumaticcraft.common.PNCDamageSource;
import me.desht.pneumaticcraft.common.block.entity.AbstractTickingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IRangedTE;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.block.entity.RangeManager;
import me.desht.pneumaticcraft.common.block.entity.RedstoneController;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.core.ModUpgrades;
import me.desht.pneumaticcraft.common.hacking.secstation.HackSimulation;
import me.desht.pneumaticcraft.common.hacking.secstation.ISimulationController;
import me.desht.pneumaticcraft.common.hacking.secstation.SimulationController;
import me.desht.pneumaticcraft.common.inventory.SecurityStationHackingMenu;
import me.desht.pneumaticcraft.common.inventory.SecurityStationMainMenu;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.item.NetworkComponentItem;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.util.GlobalBlockEntityCacheManager;
import me.desht.pneumaticcraft.common.util.ITranslatableEnum;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class SecurityStationBlockEntity
extends AbstractTickingBlockEntity
implements IRedstoneControl<SecurityStationBlockEntity>,
MenuProvider,
IRangedTE {
    private static final List<RedstoneController.RedstoneMode<SecurityStationBlockEntity>> REDSTONE_MODES = ImmutableList.of(new RedstoneController.EmittingRedstoneMode<SecurityStationBlockEntity>("standard.never", new ItemStack((ItemLike)Items.f_42403_), te -> false), new RedstoneController.EmittingRedstoneMode<SecurityStationBlockEntity>("securityStation.hacked", ((PNCUpgrade)ModUpgrades.SECURITY.get()).getItemStack(), SecurityStationBlockEntity::isHacked), new RedstoneController.EmittingRedstoneMode<SecurityStationBlockEntity>("securityStation.doneRebooting", new ItemStack((ItemLike)ModBlocks.SECURITY_STATION.get()), te -> te.getRebootTime() <= 0));
    public static final int INV_ROWS = 7;
    public static final int INV_COLS = 5;
    private static final int INVENTORY_SIZE = 35;
    private final SecurityStationHandler inventory = new SecurityStationHandler();
    private final LazyOptional<IItemHandler> invCap = LazyOptional.of(() -> this.inventory);
    public final List<GameProfile> hackedUsers = new ArrayList<GameProfile>();
    public final List<GameProfile> sharedUsers = new ArrayList<GameProfile>();
    @GuiSynced
    private int rebootTimer;
    @GuiSynced
    public final RedstoneController<SecurityStationBlockEntity> rsController = new RedstoneController<SecurityStationBlockEntity>(this, REDSTONE_MODES);
    private final RangeManager rangeManager = new RangeManager(this, 0x60FF0000);
    private boolean oldRedstoneStatus;
    private boolean validNetwork;
    private ISimulationController simulationController = null;

    public SecurityStationBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<?>)((BlockEntityType)ModBlockEntities.SECURITY_STATION.get()), pos, state, 4);
    }

    @Override
    public void m_7651_() {
        super.m_7651_();
        GlobalBlockEntityCacheManager.getInstance((LevelAccessor)this.m_58904_()).getSecurityStations().remove(this);
    }

    public void m_6339_() {
        super.m_6339_();
        GlobalBlockEntityCacheManager.getInstance((LevelAccessor)this.m_58904_()).getSecurityStations().add(this);
    }

    @Override
    public void tickCommonPre() {
        super.tickCommonPre();
        if (this.rebootTimer > 0) {
            --this.rebootTimer;
            if (!this.nonNullLevel().f_46443_ && this.rebootTimer == 0) {
                this.hackedUsers.clear();
                NetworkHandler.sendToAllTracking(new PacketPlaySound((SoundEvent)ModSounds.HUD_ENTITY_LOCK.get(), SoundSource.BLOCKS, this.m_58899_(), 1.0f, 1.0f, false), this.m_58904_(), this.m_58899_());
            }
        } else if (this.simulationController != null) {
            this.simulationController.tick();
            Player hacker = this.simulationController.getHacker();
            if (!(hacker.f_36096_ instanceof SecurityStationHackingMenu)) {
                if (!this.simulationController.isSimulationDone() && this.simulationController.getSimulation(ISimulationController.HackingSide.AI).isAwake() && !this.simulationController.isJustTesting()) {
                    this.retaliate(hacker);
                }
                this.simulationController = null;
            }
        }
        if (this.oldRedstoneStatus != this.rsController.shouldEmit()) {
            this.oldRedstoneStatus = this.rsController.shouldEmit();
            this.updateNeighbours();
        }
        this.rangeManager.setRange(Math.min(2 + this.getUpgrades((PNCUpgrade)ModUpgrades.RANGE.get()), 16));
    }

    private boolean isOwner(Player player) {
        return !this.sharedUsers.isEmpty() && player.m_36316_().equals((Object)this.sharedUsers.get(0));
    }

    public void rebootStation() {
        this.rebootTimer = 1200;
        NetworkHandler.sendToAllTracking(new PacketPlaySound((SoundEvent)ModSounds.MINIGUN_STOP.get(), SoundSource.BLOCKS, this.m_58899_(), 1.0f, 1.0f, false), this.m_58904_(), this.m_58899_());
    }

    public int getRebootTime() {
        return this.rebootTimer;
    }

    @Override
    protected LazyOptional<IItemHandler> getInventoryCap(Direction side) {
        return this.invCap;
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        if (this.rsController.parseRedstoneMode(tag)) {
            return;
        }
        if (player.f_36096_ instanceof SecurityStationMainMenu && this.isPlayerOnWhiteList((Player)player)) {
            if (tag.equals("reboot")) {
                this.rebootStation();
            } else if (tag.equals("test") && ((Boolean)ConfigHelper.common().machines.securityStationAllowHacking.get()).booleanValue()) {
                if (this.hasValidNetwork()) {
                    this.initiateHacking((Player)player);
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"pneumaticcraft.message.securityStation.outOfOrder"), false);
                }
            } else if (tag.startsWith("remove:") && this.isOwner((Player)player)) {
                String name = tag.split(":", 2)[1];
                this.removeTrustedUser(name);
            } else if (tag.startsWith("add:") && this.isOwner((Player)player)) {
                String name = tag.split(":", 2)[1];
                this.addTrustedUser(new GameProfile(null, name));
            }
        } else if (player.f_36096_ instanceof SecurityStationHackingMenu && this.isPlayerHacking((Player)player)) {
            if (tag.equals("end_test") && this.simulationController.isJustTesting()) {
                NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)this, (BlockPos)this.m_58899_());
            } else if (tag.startsWith("nuke:")) {
                this.tryNukeVirus(tag, (Player)player);
            } else if (tag.equals("stop_worm")) {
                this.tryStopWorm((Player)player);
            } else if (tag.startsWith("fortify:")) {
                this.tryFortify(tag, (Player)player);
            } else if (tag.startsWith("hack:")) {
                this.tryHack(tag, (Player)player);
            }
        }
        this.sendDescriptionPacket();
    }

    private boolean isPlayerHacking(Player player) {
        return this.simulationController != null && this.simulationController.getHacker().m_6084_() && this.simulationController.getHacker().equals((Object)player);
    }

    private void tryHack(String tag, Player player) {
        try {
            int nodePos = Integer.parseInt(tag.split(":", 2)[1]);
            HackSimulation playerSim = this.simulationController.getSimulation(ISimulationController.HackingSide.PLAYER);
            HackSimulation.Node node = playerSim.getNodeAt(nodePos);
            if (node != null && !node.isHacked() && playerSim.getHackedNeighbour(nodePos) >= 0) {
                this.simulationController.getSimulation(ISimulationController.HackingSide.PLAYER).startHack(nodePos);
            }
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            Log.warning("security station @ %s: ignoring bad message %s from %s", PneumaticCraftUtils.posToString(this.f_58858_), tag, player.m_36316_().getName());
        }
    }

    private void tryFortify(String tag, Player player) {
        try {
            int nodePos = Integer.parseInt(tag.split(":", 2)[1]);
            HackSimulation.Node node = this.simulationController.getSimulation(ISimulationController.HackingSide.PLAYER).getNodeAt(nodePos);
            if (node != null && node.isHacked()) {
                this.simulationController.getSimulation(ISimulationController.HackingSide.AI).fortify(nodePos);
            }
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            Log.warning("security station @ %s: ignoring bad message %s from %s", PneumaticCraftUtils.posToString(this.f_58858_), tag, player.m_36316_().getName());
        }
    }

    private void tryStopWorm(Player player) {
        if (!this.simulationController.getSimulation(ISimulationController.HackingSide.AI).isStopWormed()) {
            if (PneumaticCraftUtils.consumeInventoryItem(player.m_150109_(), (Item)ModItems.STOP_WORM.get())) {
                int r = 80 + this.nonNullLevel().f_46441_.m_188503_(40);
                this.simulationController.getSimulation(ISimulationController.HackingSide.AI).applyStopWorm(r);
            } else {
                player.m_6469_(DamageSource.f_19317_, 10000.0f);
            }
        }
    }

    private void tryNukeVirus(String tag, Player player) {
        try {
            if (PneumaticCraftUtils.consumeInventoryItem(player.m_150109_(), (Item)ModItems.NUKE_VIRUS.get())) {
                int nodePos = Integer.parseInt(tag.split(":", 2)[1]);
                this.simulationController.getSimulation(ISimulationController.HackingSide.PLAYER).initiateNukeVirus(nodePos);
            } else {
                player.m_6469_(DamageSource.f_19317_, 10000.0f);
            }
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            Log.warning("security station @ %s: ignoring bad message %s from %s", PneumaticCraftUtils.posToString(this.f_58858_), tag, player.m_36316_().getName());
        }
    }

    public HackingContainerProvider getHackingContainerProvider() {
        return new HackingContainerProvider();
    }

    public void addTrustedUser(GameProfile user) {
        for (GameProfile sharedUser : this.sharedUsers) {
            if (!this.gameProfileEquals(sharedUser, user)) continue;
            return;
        }
        this.sharedUsers.add(user);
        this.sendDescriptionPacket();
    }

    private void removeTrustedUser(String name) {
        this.sharedUsers.removeIf(prof -> name.equals(prof.getName()));
        this.sendDescriptionPacket();
    }

    public void addHacker(GameProfile user) {
        for (GameProfile hackedUser : this.hackedUsers) {
            if (!this.gameProfileEquals(hackedUser, user)) continue;
            return;
        }
        for (GameProfile sharedUser : this.sharedUsers) {
            if (!this.gameProfileEquals(sharedUser, user)) continue;
            return;
        }
        this.hackedUsers.add(user);
        this.sendDescriptionPacket();
    }

    private boolean gameProfileEquals(GameProfile profile1, GameProfile profile2) {
        return profile1.getId() != null && profile2.getId() != null ? profile1.getId().equals(profile2.getId()) : profile1.getName().equals(profile2.getName());
    }

    public boolean isHacked() {
        return !this.hackedUsers.isEmpty();
    }

    public AABB getRenderBoundingBox() {
        return this.rangeManager.shouldShowRange() ? this.getSecurityCoverage() : super.getRenderBoundingBox();
    }

    public AABB getSecurityCoverage() {
        return this.rangeManager.getExtents();
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.rebootTimer = tag.m_128451_("startupTimer");
        this.inventory.deserializeNBT(tag.m_128469_("Items"));
        this.checkForNetworkValidity();
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("startupTimer", this.rebootTimer);
        tag.m_128365_("Items", (Tag)this.inventory.serializeNBT());
    }

    @Override
    public void writeToPacket(CompoundTag tag) {
        super.writeToPacket(tag);
        tag.m_128365_("SharedUsers", (Tag)this.toNBTList(this.sharedUsers));
        tag.m_128365_("HackedUsers", (Tag)this.toNBTList(this.hackedUsers));
    }

    @Override
    public void readFromPacket(CompoundTag tag) {
        super.readFromPacket(tag);
        this.sharedUsers.clear();
        this.sharedUsers.addAll(this.fromNBTList(tag.m_128437_("SharedUsers", 10)));
        this.hackedUsers.clear();
        this.hackedUsers.addAll(this.fromNBTList(tag.m_128437_("HackedUsers", 10)));
    }

    private ListTag toNBTList(Collection<GameProfile> profiles) {
        ListTag res = new ListTag();
        for (GameProfile profile : profiles) {
            CompoundTag tagCompound = new CompoundTag();
            tagCompound.m_128359_("name", profile.getName());
            if (profile.getId() != null) {
                tagCompound.m_128359_("uuid", profile.getId().toString());
            }
            res.add((Object)tagCompound);
        }
        return res;
    }

    private Collection<GameProfile> fromNBTList(ListTag list) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag tagCompound = list.m_128728_(i);
            builder.add((Object)new GameProfile(tagCompound.m_128441_("uuid") ? UUID.fromString(tagCompound.m_128461_("uuid")) : null, tagCompound.m_128461_("name")));
        }
        return builder.build();
    }

    public boolean doesAllowPlayer(Player player) {
        return this.rebootTimer > 0 || this.isPlayerOnWhiteList(player) || this.hasPlayerHacked(player);
    }

    public boolean isPlayerOnWhiteList(Player player) {
        for (int i = 0; i < this.sharedUsers.size(); ++i) {
            GameProfile user = this.sharedUsers.get(i);
            if (!this.gameProfileEquals(user, player.m_36316_())) continue;
            if (user.getId() == null && player.m_36316_().getId() != null) {
                this.sharedUsers.set(i, player.m_36316_());
                Log.info("Legacy conversion: Security Station shared username '" + player.m_7755_().getString() + "' is now using UUID '" + player.m_36316_().getId() + "'.", new Object[0]);
            }
            return true;
        }
        return false;
    }

    public boolean hasPlayerHacked(Player player) {
        for (int i = 0; i < this.hackedUsers.size(); ++i) {
            GameProfile user = this.hackedUsers.get(i);
            if (!this.gameProfileEquals(user, player.m_36316_())) continue;
            if (user.getId() == null && player.m_36316_().getId() != null) {
                this.hackedUsers.set(i, player.m_36316_());
                Log.info("Legacy conversion: Security Station hacked username '" + player.m_7755_().getString() + "' is now using UUID '" + player.m_36316_().getId() + "'.", new Object[0]);
            }
            return true;
        }
        return false;
    }

    public boolean connects(int firstSlot, int secondSlot) {
        if (firstSlot < 0 || secondSlot < 0 || firstSlot >= 35 || secondSlot >= 35 || firstSlot == secondSlot || this.inventory.getStackInSlot(firstSlot).m_41619_() || this.inventory.getStackInSlot(secondSlot).m_41619_()) {
            return false;
        }
        for (int column = -1; column <= 1; ++column) {
            for (int row = -1; row <= 1; ++row) {
                if (firstSlot + row * 5 + column != secondSlot || !(firstSlot % 5 > 0 && firstSlot % 5 < 4 || secondSlot % 5 > 0 && secondSlot % 5 < 4) && secondSlot % 5 != firstSlot % 5) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasValidNetwork() {
        return this.validNetwork;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new SecurityStationMainMenu(i, playerInventory, this.m_58899_());
    }

    public void initiateHacking(Player hacker) {
        if (this.simulationController != null) {
            hacker.m_5661_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.message.securityStation.hackInProgress", new Object[0]).m_130940_(ChatFormatting.GOLD), false);
        } else {
            this.simulationController = new SimulationController(this, hacker, this.isPlayerOnWhiteList(hacker));
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)hacker), (MenuProvider)this.getHackingContainerProvider(), buf -> this.simulationController.toBytes((FriendlyByteBuf)buf));
        }
    }

    public int findComponent(NetworkComponentItem.NetworkComponentType type) {
        for (int i = 0; i < 35; ++i) {
            if (!NetworkComponentItem.isType(this.inventory.getStackInSlot(i), type)) continue;
            return i;
        }
        return -1;
    }

    public ISimulationController getSimulationController() {
        return this.simulationController;
    }

    public void setSimulationController(ISimulationController newController) {
        this.simulationController = newController;
    }

    public void retaliate(Player hacker) {
        hacker.m_6469_(PNCDamageSource.SECURITY_STATION, hacker.m_21233_() - 0.5f);
        hacker.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 100));
        hacker.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 200));
        hacker.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 300, 3));
    }

    @Override
    public RangeManager getRangeManager() {
        return this.rangeManager;
    }

    public EnumNetworkValidityProblem checkForNetworkValidity() {
        this.validNetwork = false;
        int ioPortSlot = -1;
        int registrySlot = -1;
        int subroutineSlot = -1;
        block5: for (int i = 0; i < 35; ++i) {
            Optional<NetworkComponentItem.NetworkComponentType> type;
            if (this.inventory.getStackInSlot(i).m_41619_() || (type = NetworkComponentItem.getType(this.inventory.getStackInSlot(i))).isEmpty()) continue;
            switch (type.get()) {
                case DIAGNOSTIC_SUBROUTINE: {
                    if (subroutineSlot != -1) {
                        return EnumNetworkValidityProblem.TOO_MANY_SUBROUTINES;
                    }
                    subroutineSlot = i;
                    continue block5;
                }
                case NETWORK_IO_PORT: {
                    if (ioPortSlot != -1) {
                        return EnumNetworkValidityProblem.TOO_MANY_IO_PORTS;
                    }
                    ioPortSlot = i;
                    continue block5;
                }
                case NETWORK_REGISTRY: {
                    if (registrySlot != -1) {
                        return EnumNetworkValidityProblem.TOO_MANY_REGISTRIES;
                    }
                    registrySlot = i;
                }
            }
        }
        if (subroutineSlot == -1) {
            return EnumNetworkValidityProblem.NO_SUBROUTINE;
        }
        if (ioPortSlot == -1) {
            return EnumNetworkValidityProblem.NO_IO_PORT;
        }
        if (registrySlot == -1) {
            return EnumNetworkValidityProblem.NO_REGISTRY;
        }
        if (!this.traceComponent(subroutineSlot, ioPortSlot, new boolean[35])) {
            return EnumNetworkValidityProblem.NO_CONNECTION_SUB_AND_IO_PORT;
        }
        if (!this.traceComponent(ioPortSlot, registrySlot, new boolean[35])) {
            return EnumNetworkValidityProblem.NO_CONNECTION_IO_PORT_AND_REGISTRY;
        }
        this.validNetwork = true;
        return EnumNetworkValidityProblem.NONE;
    }

    private boolean traceComponent(int startSlot, int targetSlot, boolean[] slotsDone) {
        for (int i = 0; i < 35; ++i) {
            if (slotsDone[i] || !this.connects(startSlot, i)) continue;
            if (i == targetSlot) {
                return true;
            }
            slotsDone[i] = true;
            if (!this.traceComponent(i, targetSlot, slotsDone)) continue;
            return true;
        }
        return false;
    }

    public int getDetectionChance() {
        double n = 1.0 - Math.pow(0.7, this.getUpgrades((PNCUpgrade)ModUpgrades.ENTITY_TRACKER.get()) + 1);
        return Mth.m_14045_((int)((int)(n * 100.0)), (int)0, (int)100);
    }

    public int getSecurityLevel() {
        return Math.min(64, 1 + this.getUpgrades((PNCUpgrade)ModUpgrades.SECURITY.get()));
    }

    @Override
    public boolean isGuiUseableByPlayer(Player par1EntityPlayer) {
        return this.nonNullLevel().m_7702_(this.m_58899_()) == this;
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.inventory;
    }

    @Override
    public RedstoneController<SecurityStationBlockEntity> getRedstoneController() {
        return this.rsController;
    }

    public static int getProtectingSecurityStations(Player player, BlockPos pos, boolean isPlacingSecurityStation) {
        return (int)SecurityStationBlockEntity.getSecurityStations(player.m_20193_(), pos, isPlacingSecurityStation).filter(teSS -> !teSS.doesAllowPlayer(player)).count();
    }

    public static boolean isProtectedFromPlayer(Player player, BlockPos pos, boolean isPlacingSecurityStation) {
        return SecurityStationBlockEntity.getSecurityStations(player.m_20193_(), pos, isPlacingSecurityStation).anyMatch(teSS -> !teSS.doesAllowPlayer(player));
    }

    static Stream<SecurityStationBlockEntity> getSecurityStations(Level level, BlockPos pos, boolean isPlacingSecurityStation) {
        return GlobalBlockEntityCacheManager.getInstance((LevelAccessor)level).getSecurityStations().stream().filter(station -> SecurityStationBlockEntity.isValidAndInRange(level, pos, isPlacingSecurityStation, station));
    }

    private static boolean isValidAndInRange(Level world, BlockPos pos, boolean isPlacingSecurityStation, SecurityStationBlockEntity teSS) {
        if (!teSS.m_58901_() && teSS.nonNullLevel().m_46472_().compareTo(world.m_46472_()) == 0 && teSS.hasValidNetwork()) {
            AABB aabb = teSS.getSecurityCoverage();
            if (isPlacingSecurityStation) {
                aabb = aabb.m_82400_(16.0);
            }
            return aabb.f_82288_ <= (double)pos.m_123341_() && aabb.f_82291_ >= (double)pos.m_123341_() && aabb.f_82289_ <= (double)pos.m_123342_() && aabb.f_82292_ >= (double)pos.m_123342_() && aabb.f_82290_ <= (double)pos.m_123343_() && aabb.f_82293_ >= (double)pos.m_123343_();
        }
        return false;
    }

    private static boolean isPlayerExempt(Player player) {
        return player.m_7500_() && (Boolean)ConfigHelper.common().machines.securityStationCreativePlayersExempt.get() != false || player.m_36316_().isComplete() && player.m_20203_().m_6761_(2);
    }

    private class SecurityStationHandler
    extends BaseItemStackHandler {
        private SecurityStationHandler() {
            super(SecurityStationBlockEntity.this, 35);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return NetworkComponentItem.getType(stack).map(NetworkComponentItem.NetworkComponentType::isSecStationComponent).orElse(false);
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            SecurityStationBlockEntity.this.checkForNetworkValidity();
        }
    }

    private class HackingContainerProvider
    implements MenuProvider {
        private HackingContainerProvider() {
        }

        public Component m_5446_() {
            return SecurityStationBlockEntity.this.m_7755_().m_6879_().m_130946_(" ").m_7220_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.upgrade.hacking", new Object[0]));
        }

        @Nullable
        public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player playerEntity) {
            return new SecurityStationHackingMenu(windowId, playerInventory, SecurityStationBlockEntity.this.m_58899_());
        }
    }

    public static enum EnumNetworkValidityProblem implements ITranslatableEnum
    {
        NONE,
        NO_SUBROUTINE,
        NO_IO_PORT,
        NO_REGISTRY,
        TOO_MANY_SUBROUTINES,
        TOO_MANY_IO_PORTS,
        TOO_MANY_REGISTRIES,
        NO_CONNECTION_SUB_AND_IO_PORT,
        NO_CONNECTION_IO_PORT_AND_REGISTRY;


        @Override
        public String getTranslationKey() {
            return "pneumaticcraft.gui.tab.problems.security_station." + this.toString().toLowerCase(Locale.ROOT);
        }
    }

    @Mod.EventBusSubscriber(modid="pneumaticcraft")
    public static class Listener {
        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void onPlayerInteract(PlayerInteractEvent event) {
            if (event instanceof PlayerInteractEvent.RightClickEmpty || event.getLevel().f_46443_ || !event.getLevel().m_46749_(event.getPos())) {
                return;
            }
            Player player = event.getEntity();
            if (SecurityStationBlockEntity.isPlayerExempt(player)) {
                return;
            }
            ItemStack heldItem = player.m_21120_(event.getHand());
            BlockState interactedBlockState = event.getLevel().m_8055_(event.getPos());
            Block interactedBlock = interactedBlockState.m_60734_();
            if (interactedBlock != ModBlocks.SECURITY_STATION.get() || event instanceof PlayerInteractEvent.LeftClickBlock) {
                boolean tryingToPlaceSecurityStation;
                boolean bl = tryingToPlaceSecurityStation = heldItem.m_41720_() instanceof BlockItem && ((BlockItem)heldItem.m_41720_()).m_40614_() == ModBlocks.SECURITY_STATION.get();
                if (SecurityStationBlockEntity.isProtectedFromPlayer(player, event.getPos(), tryingToPlaceSecurityStation)) {
                    event.setCanceled(true);
                    player.m_5661_((Component)PneumaticCraftUtils.xlate(tryingToPlaceSecurityStation ? "pneumaticcraft.message.securityStation.stationPlacementPrevented" : "pneumaticcraft.message.securityStation.accessPrevented", new Object[0]).m_130940_(ChatFormatting.RED), true);
                    if (player instanceof ServerPlayer && heldItem.m_41720_() instanceof BlockItem) {
                        ((ServerPlayer)player).f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(-2, 0, player.m_150109_().f_35977_, heldItem));
                    }
                }
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
            Entity entity = event.getEntity();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (!event.getLevel().m_5776_() && !SecurityStationBlockEntity.isPlayerExempt(player)) {
                    if (event instanceof BlockEvent.EntityMultiPlaceEvent) {
                        for (BlockSnapshot snapshot : ((BlockEvent.EntityMultiPlaceEvent)event).getReplacedBlockSnapshots()) {
                            if (!Listener.isPlacementPrevented(event, player, snapshot.getPos())) continue;
                            return;
                        }
                    } else {
                        Listener.isPlacementPrevented(event, player, event.getPos());
                    }
                }
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void onBlockBreak(BlockEvent.BreakEvent event) {
            Player player = event.getPlayer();
            if (!SecurityStationBlockEntity.isPlayerExempt(player) && SecurityStationBlockEntity.isProtectedFromPlayer(player, event.getPos(), false)) {
                event.setCanceled(true);
                player.m_5661_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.message.securityStation.accessPrevented", new Object[0]).m_130940_(ChatFormatting.RED), true);
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void onBlockExplode(ExplosionEvent event) {
            Player player = Listener.getPlayerForExplosion(event);
            if (player != null && !SecurityStationBlockEntity.isPlayerExempt(player) && event.getLevel() != null && !event.getLevel().f_46443_) {
                event.getExplosion().m_46081_().removeIf(pos -> SecurityStationBlockEntity.isProtectedFromPlayer(player, pos, false));
            }
        }

        private static boolean isPlacementPrevented(BlockEvent.EntityPlaceEvent event, Player player, BlockPos pos) {
            boolean tryingToPlaceSecurityStation;
            boolean bl = tryingToPlaceSecurityStation = event.getPlacedBlock().m_60734_() == ModBlocks.SECURITY_STATION.get();
            if (SecurityStationBlockEntity.isProtectedFromPlayer(player, pos, tryingToPlaceSecurityStation)) {
                event.setCanceled(true);
                player.m_5661_((Component)PneumaticCraftUtils.xlate(tryingToPlaceSecurityStation ? "pneumaticcraft.message.securityStation.stationPlacementPrevented" : "pneumaticcraft.message.securityStation.accessPrevented", new Object[0]).m_130940_(ChatFormatting.RED), true);
                return true;
            }
            return false;
        }

        private static Player getPlayerForExplosion(ExplosionEvent event) {
            LivingEntity entity = event.getExplosion().m_46079_();
            return entity instanceof Player ? (Player)entity : null;
        }

        @SubscribeEvent
        public static void onContainerClose(PlayerContainerEvent.Close event) {
            ServerPlayer player;
            MinecraftServer server;
            SecurityStationBlockEntity teSS;
            if (event.getEntity() instanceof ServerPlayer && event.getContainer() instanceof SecurityStationHackingMenu && (teSS = (SecurityStationBlockEntity)((SecurityStationHackingMenu)event.getContainer()).te).getSimulationController() != null && teSS.getSimulationController().isJustTesting() && (server = (player = (ServerPlayer)event.getEntity()).m_20194_()) != null) {
                server.m_6937_((Runnable)new TickTask(server.m_129921_(), () -> NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)teSS, (BlockPos)teSS.m_58899_())));
            }
        }
    }
}

