/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import java.util.List;
import java.util.stream.Stream;
import me.desht.pneumaticcraft.common.block.AbstractPNCBlockWithBoundingBlocks;
import me.desht.pneumaticcraft.common.block.entity.SolarCompressorBlockEntity;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.VoxelShapeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SolarCompressorBlock
extends AbstractPNCBlockWithBoundingBlocks {
    private static final Vec3i[] BOUNDING_BLOCK_OFFSETS = new Vec3i[]{new Vec3i(0, 1, 0), new Vec3i(0, 1, 1), new Vec3i(0, 1, -1)};
    private static final VoxelShape SHAPE_S = Stream.of(Block.m_49796_((double)0.0, (double)1.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0), Block.m_49796_((double)5.0, (double)16.0, (double)5.0, (double)11.0, (double)17.0, (double)11.0), Block.m_49796_((double)2.0, (double)15.0, (double)3.0, (double)3.0, (double)17.0, (double)13.0), Block.m_49796_((double)13.0, (double)15.0, (double)3.0, (double)14.0, (double)17.0, (double)13.0), Block.m_49796_((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)16.0), Block.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), Block.m_49796_((double)7.0, (double)17.0, (double)7.0, (double)9.0, (double)31.0, (double)9.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_W = VoxelShapeUtils.rotateY(SHAPE_S, 90);
    private static final VoxelShape SHAPE_N = VoxelShapeUtils.rotateY(SHAPE_W, 90);
    private static final VoxelShape SHAPE_E = VoxelShapeUtils.rotateY(SHAPE_N, 90);
    private static final VoxelShape[] SHAPES = new VoxelShape[]{SHAPE_S, SHAPE_W, SHAPE_N, SHAPE_E};

    public SolarCompressorBlock() {
        super(ModBlocks.defaultProps());
    }

    @Override
    protected boolean isWaterloggable() {
        return true;
    }

    @Override
    @NotNull
    public VoxelShape m_5940_(BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)BOUNDING)).booleanValue()) {
            return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        }
        Direction d = (Direction)state.m_61143_((Property)this.directionProperty());
        return SHAPES[d.m_122416_()];
    }

    @Override
    @NotNull
    public VoxelShape m_5939_(BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.m_5940_(state, world, pos, context);
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new SolarCompressorBlockEntity(pPos, pState);
    }

    @Override
    @Nullable
    public Vec3i[] getBoundingBlockOffsets() {
        return BOUNDING_BLOCK_OFFSETS;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult brtr) {
        SolarCompressorBlockEntity solarCompressor;
        if (((Boolean)state.m_61143_((Property)BOUNDING)).booleanValue()) {
            return InteractionResult.FAIL;
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof SolarCompressorBlockEntity && (solarCompressor = (SolarCompressorBlockEntity)blockEntity).isBroken() && player.m_21205_().m_41720_() == ModItems.SOLAR_CELL.get()) {
            if (!player.m_7500_()) {
                player.m_21205_().m_41774_(1);
            }
            solarCompressor.fixBroken();
            world.m_5594_(null, pos, SoundEvents.f_11671_, SoundSource.BLOCKS, 1.0f, 1.5f);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, brtr);
    }

    @Override
    public void m_5871_(ItemStack stack, BlockGetter world, List<Component> curInfo, TooltipFlag flag) {
        CompoundTag subTag;
        super.m_5871_(stack, world, curInfo, flag);
        if (stack.m_41782_() && (subTag = stack.m_41737_("BlockEntityTag")) != null && subTag.m_128441_("IsBroken") && subTag.m_128471_("IsBroken")) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.broken", new Object[0]));
        }
    }
}

