/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import me.desht.pneumaticcraft.client.model.PNCModelLayers;
import me.desht.pneumaticcraft.client.render.blockentity.AbstractBlockEntityModelRenderer;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.block.entity.PneumaticDoorBaseBlockEntity;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class PneumaticDoorBaseRenderer
extends AbstractBlockEntityModelRenderer<PneumaticDoorBaseBlockEntity> {
    private final ModelPart cylinder1;
    private final ModelPart cylinder2;
    private final ModelPart cylinder3;
    private static final String CYLINDER1 = "cylinder1";
    private static final String CYLINDER2 = "cylinder2";
    private static final String CYLINDER3 = "cylinder3";

    public PneumaticDoorBaseRenderer(BlockEntityRendererProvider.Context ctx) {
        super(ctx);
        ModelPart root = ctx.m_173582_(PNCModelLayers.PNEUMATIC_DOOR_BASE);
        this.cylinder1 = root.m_171324_(CYLINDER1);
        this.cylinder2 = root.m_171324_(CYLINDER2);
        this.cylinder3 = root.m_171324_(CYLINDER3);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_(CYLINDER1, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171517_("cylinder1_0", 0.0f, 0.0f, 0.0f, 3.0f, 3.0f, 10.0f), PartPose.m_171419_((float)2.5f, (float)8.5f, (float)-6.0f));
        partdefinition.m_171599_(CYLINDER2, CubeListBuilder.m_171558_().m_171514_(0, 13).m_171517_("cylinder2_0", 0.0f, 0.0f, 0.0f, 2.0f, 2.0f, 10.0f), PartPose.m_171419_((float)3.0f, (float)9.0f, (float)-6.0f));
        partdefinition.m_171599_(CYLINDER3, CubeListBuilder.m_171558_().m_171514_(0, 25).m_171517_("cylinder3_0", 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 10.0f), PartPose.m_171419_((float)3.5f, (float)9.5f, (float)-6.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    @Override
    public void renderModel(PneumaticDoorBaseBlockEntity te, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        VertexConsumer builder = bufferIn.m_6299_(RenderType.m_110452_((ResourceLocation)Textures.MODEL_PNEUMATIC_DOOR_BASE));
        float progress = Mth.m_14179_((float)partialTicks, (float)te.oldProgress, (float)te.progress);
        float cosinus = (float)Math.sin(Math.toRadians((1.0f - progress) * 90.0f)) * 12.0f / 16.0f;
        float sinus = 0.5625f - (float)Math.cos(Math.toRadians((1.0f - progress) * 90.0f)) * 9.0f / 16.0f;
        double extension = Math.sqrt(Math.pow(sinus, 2.0) + Math.pow(cosinus + 0.25f, 2.0));
        RenderUtils.rotateMatrixForDirection(matrixStackIn, te.getRotation());
        matrixStackIn.m_85837_(((double)(te.rightGoing ? -4 : 0) + 2.5) / 16.0, 0.0, -0.375);
        float cylinderAngle = (float)Math.toDegrees(Math.atan(sinus / (cosinus + 0.875f)));
        matrixStackIn.m_85845_(te.rightGoing ? Vector3f.f_122225_.m_122240_(cylinderAngle) : Vector3f.f_122224_.m_122240_(cylinderAngle));
        matrixStackIn.m_85837_(((double)(te.rightGoing ? -3 : 0) - 2.5) / 16.0, 0.0, 0.375);
        double extensionPart = extension * 0.5;
        int l = ClientUtils.getLightAt(te.m_58899_().m_121945_(te.getRotation()));
        this.cylinder1.m_104301_(matrixStackIn, builder, l, combinedOverlayIn);
        matrixStackIn.m_85837_(0.0, 0.0, extensionPart);
        this.cylinder2.m_104306_(matrixStackIn, builder, l, combinedOverlayIn, 0.8f, 0.8f, 0.8f, 1.0f);
        matrixStackIn.m_85837_(0.0, 0.0, extensionPart);
        this.cylinder3.m_104306_(matrixStackIn, builder, l, combinedOverlayIn, 0.6f, 0.6f, 0.6f, 1.0f);
    }
}

