/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.remote.actionwidget;

import me.desht.pneumaticcraft.client.gui.RemoteEditorScreen;
import me.desht.pneumaticcraft.client.gui.remote.RemoteDropdownOptionScreen;
import me.desht.pneumaticcraft.client.gui.remote.actionwidget.ActionWidgetVariable;
import me.desht.pneumaticcraft.client.gui.widget.WidgetComboBox;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSetGlobalVariable;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.variables.GlobalVariableHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class ActionWidgetDropdown
extends ActionWidgetVariable<WidgetComboBox> {
    private int x;
    private int y;
    private int width;
    private int height;
    private String dropDownElements = "";
    private boolean sorted;

    public ActionWidgetDropdown() {
    }

    public ActionWidgetDropdown(WidgetComboBox widget) {
        super(widget);
        this.x = widget.f_93620_;
        this.y = widget.f_93621_;
        this.width = widget.m_5711_();
        this.height = widget.m_93694_();
        widget.m_94144_(I18n.m_118938_((String)"pneumaticcraft.gui.remote.tray.dropdown.name", (Object[])new Object[0]));
        widget.setTooltip(new Component[]{PneumaticCraftUtils.xlate("pneumaticcraft.gui.remote.tray.dropdown.tooltip", new Object[0])});
    }

    @Override
    public void readFromNBT(CompoundTag tag, int guiLeft, int guiTop) {
        super.readFromNBT(tag, guiLeft, guiTop);
        this.x = tag.m_128451_("x") + guiLeft;
        this.y = tag.m_128451_("y") + guiTop;
        this.width = tag.m_128451_("width");
        this.height = tag.m_128451_("height");
        this.dropDownElements = tag.m_128461_("dropDownElements");
        this.sorted = tag.m_128471_("sorted");
        this.updateWidget();
    }

    @Override
    public CompoundTag toNBT(int guiLeft, int guiTop) {
        CompoundTag tag = super.toNBT(guiLeft, guiTop);
        tag.m_128405_("x", this.x - guiLeft);
        tag.m_128405_("y", this.y - guiTop);
        tag.m_128405_("width", this.width);
        tag.m_128405_("height", this.height);
        tag.m_128359_("dropDownElements", this.dropDownElements);
        tag.m_128379_("sorted", this.sorted);
        return tag;
    }

    @Override
    public String getId() {
        return "dropdown";
    }

    @Override
    public void onKeyTyped() {
        if (!this.getVariableName().isEmpty()) {
            NetworkHandler.sendToServer(new PacketSetGlobalVariable(this.getVariableName(), ((WidgetComboBox)this.widget).getSelectedElementIndex()));
        }
    }

    @Override
    public void onVariableChange() {
        this.updateWidget();
    }

    @Override
    public void setWidgetPos(int x, int y) {
        this.x = x;
        this.y = y;
        this.updateWidget();
    }

    @Override
    public WidgetComboBox getWidget() {
        if (this.widget == null) {
            this.widget = new WidgetComboBox(Minecraft.m_91087_().f_91062_, this.x, this.y, this.width, this.height, this::onPressed);
            ((WidgetComboBox)this.widget).setElements(this.getDropdownElements());
            ((WidgetComboBox)this.widget).setFixedOptions(true);
            ((WidgetComboBox)this.widget).setShouldSort(this.sorted);
            this.updateWidget();
        }
        return (WidgetComboBox)this.widget;
    }

    private void onPressed(WidgetComboBox comboBox) {
        if (comboBox.getSelectedElementIndex() >= 0 && !this.getVariableName().isEmpty()) {
            NetworkHandler.sendToServer(new PacketSetGlobalVariable(this.getVariableName(), comboBox.getSelectedElementIndex()));
        }
    }

    private String[] getDropdownElements() {
        return this.dropDownElements.split(",");
    }

    private void updateWidget() {
        String[] elements = this.getDropdownElements();
        int idx = GlobalVariableHelper.getInt(ClientUtils.getClientPlayer().m_20148_(), this.getVariableName());
        String selectedElement = elements[Mth.m_14045_((int)idx, (int)0, (int)(elements.length - 1))];
        if (this.widget != null) {
            ((WidgetComboBox)this.widget).f_93620_ = this.x;
            ((WidgetComboBox)this.widget).f_93621_ = this.y;
            ((WidgetComboBox)this.widget).m_93674_(this.width);
            ((WidgetComboBox)this.widget).setHeight(this.height);
            ((WidgetComboBox)this.widget).setElements(this.getDropdownElements());
            ((WidgetComboBox)this.widget).m_94144_(selectedElement);
            ((WidgetComboBox)this.widget).setShouldSort(this.sorted);
        }
    }

    @Override
    public void onActionPerformed() {
    }

    public void setDropDownElements(String dropDownElements) {
        this.dropDownElements = dropDownElements;
        this.updateWidget();
    }

    public String getDropDownElements() {
        return this.dropDownElements;
    }

    public boolean getSorted() {
        return this.sorted;
    }

    public void setSorted(boolean sorted) {
        this.sorted = sorted;
    }

    public void setWidth(int width) {
        this.width = width;
        this.updateWidget();
    }

    public int getWidth() {
        return this.width;
    }

    @Override
    public Screen getGui(RemoteEditorScreen guiRemote) {
        return new RemoteDropdownOptionScreen(this, guiRemote);
    }
}

