/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.stacks;

import appeng.api.config.FuzzyMode;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.VariantMap;
import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Supplier;

public final class KeyMap<K extends AEKey, V>
implements Iterable<Map.Entry<K, V>> {
    private final V defaultValue;
    private final Supplier<V> defaultValueFactory;
    private final Map<Object, VariantMap<K, V>> lists = new IdentityHashMap<Object, VariantMap<K, V>>();

    public KeyMap(V defaultValue, Supplier<V> defaultValueFactory) {
        this.defaultValue = defaultValue;
        this.defaultValueFactory = defaultValueFactory;
    }

    public V mapping(K key) {
        return this.getSubIndex(key).mapping(key);
    }

    public V findPrecise(K key) {
        return this.getSubIndex(key).findPrecise(key);
    }

    public Collection<Map.Entry<K, V>> findFuzzy(K key, FuzzyMode fuzzy) {
        return this.getSubIndex(key).findFuzzy(key, fuzzy);
    }

    public boolean isEmpty() {
        for (VariantMap<K, V> list : this.lists.values()) {
            if (list.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public int size() {
        int tot = 0;
        for (VariantMap<K, V> list : this.lists.values()) {
            tot += list.size();
        }
        return tot;
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return Iterators.concat((Iterator)Iterators.transform(this.lists.values().iterator(), VariantMap::iterator));
    }

    private VariantMap<K, V> getSubIndex(K key) {
        VariantMap<K, V> subIndex = this.lists.get(((AEKey)key).getPrimaryKey());
        if (subIndex == null) {
            subIndex = VariantMap.create(key, this.defaultValue, this.defaultValueFactory);
            this.lists.put(((AEKey)key).getPrimaryKey(), subIndex);
        }
        return subIndex;
    }
}

