/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.include.dev.felnull.fnjl.util;

import dev.felnull.otyacraftengine.include.dev.felnull.fnjl.math.FN2dLine;
import dev.felnull.otyacraftengine.include.dev.felnull.fnjl.math.FNComplex;
import dev.felnull.otyacraftengine.include.dev.felnull.fnjl.math.FNVec2d;
import dev.felnull.otyacraftengine.include.dev.felnull.fnjl.math.FNVec2f;
import dev.felnull.otyacraftengine.include.dev.felnull.fnjl.math.FNVec2i;
import dev.felnull.otyacraftengine.include.dev.felnull.fnjl.math.FNVec3d;
import dev.felnull.otyacraftengine.include.dev.felnull.fnjl.math.FNVec4d;
import dev.felnull.otyacraftengine.include.dev.felnull.fnjl.tuple.FNPair;
import dev.felnull.otyacraftengine.include.dev.felnull.fnjl.tuple.FNQuadruple;
import dev.felnull.otyacraftengine.include.dev.felnull.fnjl.tuple.FNTriple;
import dev.felnull.otyacraftengine.include.dev.felnull.fnjl.tuple.SimpleFNPair;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class FNMath {
    public static final double ABSOLUTE_ZERO_TEMP = (double)-273.15f;

    public static float toKelvinTemp(float celsius) {
        return celsius - -273.15f;
    }

    public static float toCelsiusTemp(float kelvin) {
        return kelvin + -273.15f;
    }

    public static int toKelvinTemp(int celsius) {
        return celsius - -273;
    }

    public static int toCelsiusTemp(int kelvin) {
        return kelvin + -273;
    }

    public static long toKelvinTemp(long celsius) {
        return celsius - -273L;
    }

    public static long toCelsiusTemp(long kelvin) {
        return kelvin + -273L;
    }

    public static double toKelvinTemp(double celsius) {
        return celsius - (double)-273.15f;
    }

    public static double toCelsiusTemp(double kelvin) {
        return kelvin + (double)-273.15f;
    }

    public static int clamp(int value, int min, int max) {
        return Math.max(Math.min(value, max), min);
    }

    public static long clamp(long value, long min, long max) {
        return Math.max(Math.min(value, max), min);
    }

    public static float clamp(float value, float min, float max) {
        return Math.max(Math.min(value, max), min);
    }

    public static double clamp(double value, double min, double max) {
        return Math.max(Math.min(value, max), min);
    }

    public static boolean mandelbrot(double x, double y, int num) {
        return FNMath.mandelbrot(new FNComplex(x, y), num);
    }

    public static boolean mandelbrot(@NotNull FNComplex complex, int num) {
        return complex.mandelbrot(num) >= num;
    }

    public static void generateMandelbrotSet(int width, int height, double posX, double posY, double zoom, int num, Consumer<FNVec2i> pos) {
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                double xp = (-((double)width) / 2.0 + (double)x + posX) / (double)width;
                double yp = (-((double)height) / 2.0 + (double)y + posY) / (double)height;
                if (!FNMath.mandelbrot(xp * (4.0 / zoom), yp * (4.0 / zoom), num)) continue;
                pos.accept(new FNVec2i(x, y));
            }
        }
    }

    public static void generateColorMandelbrot(int width, int height, double posX, double posY, double zoom, int max, Consumer<PosColorEntry> pos) {
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                double xp = (-((double)width) / 2.0 + (double)x + posX) / (double)width;
                double yp = (-((double)height) / 2.0 + (double)y + posY) / (double)height;
                pos.accept(new PosColorEntry(new FNVec2i(x, y), new FNComplex(xp * (4.0 / zoom), yp * (4.0 / zoom)).mandelbrot(max)));
            }
        }
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static FNVec2d scale(double w, double h) {
        if (w > h) {
            return new FNVec2d(1.0, h / w);
        }
        return new FNVec2d(w / h, 1.0);
    }

    @Contract(pure=true)
    public static int min(int value, int ... values) {
        int min = value;
        for (int i : values) {
            if (min <= i) continue;
            min = i;
        }
        return min;
    }

    @Contract(pure=true)
    public static float min(float value, float ... values) {
        float min = value;
        for (float i : values) {
            if (!(min > i)) continue;
            min = i;
        }
        return min;
    }

    @Contract(pure=true)
    public static double min(double value, double ... values) {
        double min = value;
        for (double i : values) {
            if (!(min > i)) continue;
            min = i;
        }
        return min;
    }

    @Contract(pure=true)
    public static long min(long value, long ... values) {
        long min = value;
        for (long i : values) {
            if (min <= i) continue;
            min = i;
        }
        return min;
    }

    @Contract(pure=true)
    public static int max(int value, int ... values) {
        int max = value;
        for (int i : values) {
            if (max >= i) continue;
            max = i;
        }
        return max;
    }

    @Contract(pure=true)
    public static float max(float value, float ... values) {
        float max = value;
        for (float i : values) {
            if (!(max < i)) continue;
            max = i;
        }
        return max;
    }

    @Contract(pure=true)
    public static double max(double value, double ... values) {
        double max = value;
        for (double i : values) {
            if (!(max < i)) continue;
            max = i;
        }
        return max;
    }

    @Contract(pure=true)
    public static long max(long value, long ... values) {
        long max = value;
        for (long i : values) {
            if (max >= i) continue;
            max = i;
        }
        return max;
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static FNPair<FNVec2f, FNVec2f> trans4to2CornerPlanes(@NotNull FNVec2f v1, @NotNull FNVec2f v2, @NotNull FNVec2f v3, @NotNull FNVec2f v4) {
        float stX = FNMath.min(v1.getX(), v2.getX(), v3.getX(), v4.getX());
        float stY = FNMath.min(v1.getY(), v2.getY(), v3.getY(), v4.getY());
        float enX = FNMath.max(v1.getX(), v2.getX(), v3.getX(), v4.getX());
        float enY = FNMath.max(v1.getY(), v2.getY(), v3.getY(), v4.getY());
        return new SimpleFNPair<FNVec2f, FNVec2f>(new FNVec2f(stX, stY), new FNVec2f(enX, enY));
    }

    @NotNull
    public static FNQuadruple<Double, Double, Double, Double> toQuaternion(double roll, double pitch, double yaw) {
        double cy = Math.cos(yaw * 0.5);
        double sy = Math.sin(yaw * 0.5);
        double cp = Math.cos(pitch * 0.5);
        double sp = Math.sin(pitch * 0.5);
        double cr = Math.cos(roll * 0.5);
        double sr = Math.sin(roll * 0.5);
        double qw = cr * cp * cy + sr * sp * sy;
        double qx = sr * cp * cy - cr * sp * sy;
        double qy = cr * sp * cy + sr * cp * sy;
        double qz = cr * cp * sy - sr * sp * cy;
        return FNQuadruple.of(qx, qy, qz, qw);
    }

    @NotNull
    public static FNTriple<Double, Double, Double> toEulerAngle(double x, double y, double z, double w) {
        double sinr_cosp = 2.0 * (w * x + y * z);
        double cosr_cosp = 1.0 - 2.0 * (x * x + y * y);
        double roll = Math.atan2(sinr_cosp, cosr_cosp);
        double sinp = 2.0 * (w * y - z * x);
        double pitch = Math.abs(sinp) >= 1.0 ? Math.copySign(1.5707963267948966, sinp) : Math.asin(sinp);
        double siny_cosp = 2.0 * (w * z + x * y);
        double cosy_cosp = 1.0 - 2.0 * (y * y + z * z);
        double yaw = Math.atan2(siny_cosp, cosy_cosp);
        return FNTriple.of(roll, pitch, yaw);
    }

    public static float fastInvSqrt(float f) {
        float g = 0.5f * f;
        int i = Float.floatToIntBits(f);
        i = 1597463007 - (i >> 1);
        f = Float.intBitsToFloat(i);
        f *= 1.5f - g * f * f;
        return f;
    }

    public static double fastInvSqrt(double d) {
        double e = 0.5 * d;
        long l = Double.doubleToRawLongBits(d);
        l = 6910469410427058090L - (l >> 1);
        d = Double.longBitsToDouble(l);
        d *= 1.5 - e * d * d;
        return d;
    }

    private float addRotation(float v, float add) {
        return (v + add) % 360.0f;
    }

    public static float lerp(float delta, float old, float value) {
        return old + delta * (value - old);
    }

    public static float lerpRoted(float delta, float old, float value) {
        return FNMath.lerpRoted(delta, old, value, 270.0f);
    }

    public static float lerpRoted(float delta, float old, float value, float maxValue) {
        float sa = Math.abs(value - old);
        if (sa > maxValue) {
            value = old < value ? -(360.0f - value) : 360.0f + value;
        }
        return FNMath.lerp(delta, old, value);
    }

    public static FNVec2d getLinesIntersectPoint(FNVec4d line1, FNVec4d line2) {
        double x = (line2.getY() * line2.getZ() - line2.getX() * line2.getW()) * (line1.getZ() - line1.getX()) - (line1.getY() * line1.getZ() - line1.getX() * line1.getW()) * (line2.getZ() - line2.getX());
        double y = (line2.getY() * line2.getZ() - line2.getX() * line2.getW()) * (line1.getW() - line1.getY()) - (line1.getY() * line1.getZ() - line1.getX() * line1.getW()) * (line2.getW() - line2.getY());
        if (!Double.isFinite(x /= (line1.getW() - line1.getY()) * (line2.getZ() - line2.getX()) - (line1.getZ() - line1.getX()) * (line2.getW() - line2.getY())) || !Double.isFinite(y /= (line1.getW() - line1.getY()) * (line2.getZ() - line2.getX()) - (line1.getZ() - line1.getX()) * (line2.getW() - line2.getY()))) {
            return null;
        }
        return new FNVec2d(x, y);
    }

    public static FNVec2d getLinesIntersectPoint(FN2dLine line1, FN2dLine line2) {
        double x = (line2.getFromY() * line2.getToX() - line2.getFromX() * line2.getToY()) * (line1.getToX() - line1.getFromX()) - (line1.getFromY() * line1.getToX() - line1.getFromX() * line1.getToY()) * (line2.getToX() - line2.getFromX());
        double y = (line2.getFromY() * line2.getToX() - line2.getFromX() * line2.getToY()) * (line1.getToY() - line1.getFromY()) - (line1.getFromY() * line1.getToX() - line1.getFromX() * line1.getToY()) * (line2.getToY() - line2.getFromY());
        if (!Double.isFinite(x /= (line1.getToY() - line1.getFromY()) * (line2.getToX() - line2.getFromX()) - (line1.getToX() - line1.getFromX()) * (line2.getToY() - line2.getFromY())) || !Double.isFinite(y /= (line1.getToY() - line1.getFromY()) * (line2.getToX() - line2.getFromX()) - (line1.getToX() - line1.getFromX()) * (line2.getToY() - line2.getFromY()))) {
            return null;
        }
        return new FNVec2d(x, y);
    }

    public static boolean isPointOnLine(FN2dLine line, FNVec2d point) {
        if ((line.getFromX() <= point.getX() && point.getX() <= line.getToX() || line.getToX() <= point.getX() && point.getX() <= line.getToX()) && (line.getFromY() <= point.getY() && point.getY() <= line.getToY() || line.getToY() <= point.getY() && point.getY() <= line.getFromY())) {
            return point.getY() * (line.getFromX() - line.getToX()) + line.getFromY() * (line.getToX() - point.getX()) + line.getToY() * (point.getX() - line.getFromX()) == 0.0;
        }
        return false;
    }

    public static double getAngle(FNVec2d from, FNVec2d to) {
        double x = to.getX() - from.getX();
        double y = to.getY() - from.getY();
        double n = Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0));
        return Math.toDegrees(Math.acos(x / n));
    }

    public static FNVec3d getAngle(FNVec3d from, FNVec3d to) {
        double x = FNMath.getAngle(new FNVec2d(from.getZ(), from.getY()), new FNVec2d(to.getZ(), to.getY()));
        double y = FNMath.getAngle(new FNVec2d(from.getX(), from.getZ()), new FNVec2d(to.getX(), to.getZ()));
        double z = FNMath.getAngle(new FNVec2d(from.getX(), from.getY()), new FNVec2d(to.getX(), to.getY()));
        return new FNVec3d(x, y, z);
    }

    public static class PosColorEntry {
        private final FNVec2i pos;
        private final int color;

        protected PosColorEntry(FNVec2i pos, int color) {
            this.pos = pos;
            this.color = color;
        }

        public FNVec2i getPos() {
            return this.pos;
        }

        public int getColor() {
            return this.color;
        }
    }
}

