/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.data.recipes.ModRecipeTypes;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class DryingRackRecipe
implements Recipe<SimpleContainer> {
    private final ResourceLocation id;
    private final ItemStack output;
    private final NonNullList<Ingredient> recipeItems;
    private final int dryingTime;
    protected static final List<Boolean> itemMatchesSlot = new ArrayList<Boolean>();

    public DryingRackRecipe(ResourceLocation id, NonNullList<Ingredient> inputs, ItemStack output, int dryingTime) {
        this.id = id;
        this.output = output;
        this.recipeItems = inputs;
        this.dryingTime = dryingTime;
        for (int i = 0; i < 8; ++i) {
            itemMatchesSlot.add(false);
        }
    }

    public boolean matches(SimpleContainer inv, Level worldIn) {
        return ((Ingredient)this.recipeItems.get(0)).test(inv.m_8020_(0)) || ((Ingredient)this.recipeItems.get(0)).test(inv.m_8020_(1)) || ((Ingredient)this.recipeItems.get(0)).test(inv.m_8020_(2));
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.recipeItems;
    }

    public ItemStack assemble(SimpleContainer inv) {
        return this.output;
    }

    public boolean m_8004_(int p_43999_, int p_44000_) {
        return true;
    }

    public ItemStack m_8043_() {
        return this.output.m_41777_();
    }

    public int getDryingTime() {
        return this.dryingTime;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)ModBlocks.HERB_DRYING_RACK.get());
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeTypes.DRYING_RACK_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Type
    implements RecipeType<DryingRackRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "drying_rack";

        private Type() {
        }
    }

    public static class Serializer
    implements RecipeSerializer<DryingRackRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("hexerei", "drying_rack");

        public DryingRackRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            NonNullList inputs = NonNullList.m_122780_((int)1, (Object)Ingredient.f_43901_);
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output"));
            int dryingTime = GsonHelper.m_13927_((JsonObject)json, (String)"dryingTimeInTicks");
            inputs.set(0, (Object)Ingredient.m_43917_((JsonElement)ingredients.get(0)));
            return new DryingRackRecipe(recipeId, (NonNullList<Ingredient>)inputs, output, dryingTime);
        }

        @Nullable
        public DryingRackRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            NonNullList inputs = NonNullList.m_122780_((int)buffer.readInt(), (Object)Ingredient.f_43901_);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack output = buffer.m_130267_();
            return new DryingRackRecipe(recipeId, (NonNullList<Ingredient>)inputs, output, buffer.readInt());
        }

        public void toNetwork(FriendlyByteBuf buffer, DryingRackRecipe recipe) {
            buffer.writeInt(recipe.m_7527_().size());
            for (Ingredient ing : recipe.m_7527_()) {
                ing.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.m_8043_());
            buffer.writeInt(recipe.getDryingTime());
        }
    }
}

