/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.container;

import net.joefoxe.hexerei.client.renderer.entity.custom.CrowEntity;
import net.joefoxe.hexerei.container.ModContainers;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class CrowContainer
extends AbstractContainerMenu {
    private final Player playerEntity;
    public final CrowEntity crowEntity;
    private final IItemHandler playerInventory;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 3;

    public CrowContainer(int windowId, final CrowEntity crowEntity, Inventory playerInventory, Player player) {
        super((MenuType)ModContainers.CROW_CONTAINER.get(), windowId);
        this.crowEntity = crowEntity;
        this.playerEntity = player;
        this.playerInventory = new InvWrapper((Container)playerInventory);
        crowEntity.sync();
        this.layoutPlayerInventorySlots(14, 147);
        if (crowEntity != null) {
            crowEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> {
                this.m_38897_((Slot)new SlotItemHandler((IItemHandler)h, 0, 86, 50){

                    public int m_6641_() {
                        return 1;
                    }

                    public boolean m_5857_(@NotNull ItemStack stack) {
                        return stack.canEquip(EquipmentSlot.HEAD, (Entity)crowEntity);
                    }
                });
                this.m_38897_((Slot)new SlotItemHandler((IItemHandler)h, 1, 37, 50){

                    public int m_6641_() {
                        return 1;
                    }

                    public boolean m_5857_(@NotNull ItemStack stack) {
                        return true;
                    }
                });
                this.m_38897_((Slot)new SlotItemHandler((IItemHandler)h, 2, 134, 50){

                    public int m_6641_() {
                        return 1;
                    }

                    public boolean m_5857_(@NotNull ItemStack stack) {
                        return true;
                    }
                });
            });
        }
        this.m_38895_(new DataSlot(){

            public void m_6422_(int value) {
                crowEntity.setCommand(value);
            }

            public int m_6501_() {
                return crowEntity.getCommand();
            }
        });
    }

    public void m_150399_(int p_150400_, int p_150401_, ClickType p_150402_, Player p_150403_) {
        super.m_150399_(p_150400_, p_150401_, p_150402_, p_150403_);
    }

    public void playSound() {
        this.crowEntity.m_9236_().m_5594_((Player)null, this.crowEntity.m_20183_(), SoundEvents.f_12490_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public int getCommand() {
        return this.crowEntity.getCommand();
    }

    public void setCommand(int value) {
        this.crowEntity.setCommand(value);
    }

    public int getHelpCommand() {
        return this.crowEntity.getHelpCommand();
    }

    public void setHelpCommand(int value) {
        this.crowEntity.setHelpCommand(value);
    }

    public boolean m_6875_(Player playerIn) {
        if (this.crowEntity.m_213877_()) {
            return false;
        }
        return !(playerIn.m_20280_((Entity)this.crowEntity) > 64.0);
    }

    private int addSlotRange(IItemHandler handler, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.m_38897_((Slot)new SlotItemHandler(handler, index, x, y));
            x += dx;
            ++index;
        }
        return index;
    }

    private int addSlotBox(IItemHandler handler, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(handler, index, x, y, horAmount, dx);
            y += dy;
        }
        return index;
    }

    private void layoutPlayerInventorySlots(int leftCol, int topRow) {
        this.addSlotBox(this.playerInventory, 9, leftCol, topRow, 9, 18, 3, 18);
        this.addSlotRange(this.playerInventory, 0, leftCol, topRow += 58, 9, 18);
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        Slot sourceSlot = (Slot)this.f_38839_.get(index);
        if (sourceSlot == null || !sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyOfSourceStack = sourceStack.m_41777_();
        if (index < 36) {
            if (!this.m_38903_(sourceStack, 36, 39, false)) {
                return ItemStack.f_41583_;
            }
        } else if (index < 39) {
            if (!this.m_38903_(sourceStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            System.out.println("Invalid slotIndex:" + index);
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41613_() == 0) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        sourceSlot.m_142406_(this.playerEntity, sourceStack);
        return copyOfSourceStack;
    }
}

