/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.client.renderer.entity;

import net.joefoxe.hexerei.client.renderer.entity.custom.BroomEntity;
import net.joefoxe.hexerei.client.renderer.entity.custom.CrowEntity;
import net.joefoxe.hexerei.client.renderer.entity.custom.ModBoatEntity;
import net.joefoxe.hexerei.client.renderer.entity.custom.ModChestBoatEntity;
import net.joefoxe.hexerei.item.ModItemGroup;
import net.joefoxe.hexerei.item.ModItems;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="hexerei", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModEntityTypes {
    public static DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"hexerei");
    public static final RegistryObject<EntityType<BroomEntity>> BROOM = ENTITY_TYPES.register("broom", () -> EntityType.Builder.m_20704_(BroomEntity::new, (MobCategory)MobCategory.MISC).m_20699_(1.175f, 0.3625f).setTrackingRange(10).m_20712_(new ResourceLocation("hexerei", "broom").toString()));
    public static final RegistryObject<EntityType<ModBoatEntity>> HEXEREI_BOAT = ENTITY_TYPES.register("boat", () -> EntityType.Builder.m_20704_(ModBoatEntity::new, (MobCategory)MobCategory.MISC).m_20699_(1.175f, 0.3625f).setTrackingRange(10).m_20712_(new ResourceLocation("hexerei", "boat").toString()));
    public static final RegistryObject<EntityType<ModChestBoatEntity>> HEXEREI_CHEST_BOAT = ENTITY_TYPES.register("chest_boat", () -> EntityType.Builder.m_20704_(ModChestBoatEntity::new, (MobCategory)MobCategory.MISC).m_20699_(1.175f, 0.3625f).setTrackingRange(10).m_20712_(new ResourceLocation("hexerei", "chest_boat").toString()));
    public static final RegistryObject<EntityType<CrowEntity>> CROW = ENTITY_TYPES.register("crow", () -> EntityType.Builder.m_20704_(CrowEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.375f, 0.5f).setTrackingRange(64).setUpdateInterval(1).m_20712_(new ResourceLocation("hexerei", "crow").toString()));

    public static void register(IEventBus eventBus) {
        ENTITY_TYPES.register(eventBus);
    }

    @SubscribeEvent
    public static void addEntityAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)CROW.get(), CrowEntity.createAttributes());
    }

    static <T extends Mob> RegistryObject<EntityType<T>> addEntityWithEgg(String name, int color1, int color2, float width, float height, EntityType.EntityFactory<T> factory, MobCategory kind) {
        EntityType type = EntityType.Builder.m_20704_(factory, (MobCategory)kind).setTrackingRange(64).setUpdateInterval(1).m_20699_(width, height).m_20712_("hexerei:" + name);
        ModItems.ITEMS.register(name + "_spawn_egg", () -> new SpawnEggItem(type, color1, color2, new Item.Properties().m_41491_(ModItemGroup.HEXEREI_GROUP)));
        return ENTITY_TYPES.register(name, () -> type);
    }
}

