/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.block.custom;

import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.tileentity.ModChestBlockEntity;
import net.joefoxe.hexerei.tileentity.ModTileEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractChestBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ModChest
extends AbstractChestBlock<ModChestBlockEntity>
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<ChestType> TYPE = BlockStateProperties.f_61392_;
    public static final EnumProperty<WoodType> WOOD_TYPE = EnumProperty.m_61587_((String)"wood_type", WoodType.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final int EVENT_SET_OPEN_COUNT = 1;
    protected static final int AABB_OFFSET = 1;
    protected static final int AABB_HEIGHT = 14;
    protected static final VoxelShape NORTH_AABB = Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)14.0, (double)15.0);
    protected static final VoxelShape SOUTH_AABB = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    protected static final VoxelShape EAST_AABB = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)14.0, (double)15.0);
    protected static final VoxelShape AABB = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    private static final DoubleBlockCombiner.Combiner<ModChestBlockEntity, Optional<Container>> CHEST_COMBINER = new DoubleBlockCombiner.Combiner<ModChestBlockEntity, Optional<Container>>(){

        public Optional<Container> acceptDouble(ModChestBlockEntity p_51591_, ModChestBlockEntity p_51592_) {
            return Optional.of(new CompoundContainer((Container)p_51591_, (Container)p_51592_));
        }

        public Optional<Container> acceptSingle(ModChestBlockEntity p_51589_) {
            return Optional.of(p_51589_);
        }

        public Optional<Container> acceptNone() {
            return Optional.empty();
        }
    };
    private static final DoubleBlockCombiner.Combiner<ModChestBlockEntity, Optional<MenuProvider>> MENU_PROVIDER_COMBINER = new DoubleBlockCombiner.Combiner<ModChestBlockEntity, Optional<MenuProvider>>(){

        public Optional<MenuProvider> acceptDouble(final ModChestBlockEntity p_51604_, final ModChestBlockEntity p_51605_) {
            CompoundContainer container = new CompoundContainer((Container)p_51604_, (Container)p_51605_);
            return Optional.of(new MenuProvider(){
                final /* synthetic */ Container val$container;
                {
                    this.val$container = container;
                }

                @Nullable
                public AbstractContainerMenu m_7208_(int p_51622_, Inventory p_51623_, Player p_51624_) {
                    if (p_51604_.m_7525_(p_51624_) && p_51605_.m_7525_(p_51624_)) {
                        p_51604_.m_59640_(p_51623_.f_35978_);
                        p_51605_.m_59640_(p_51623_.f_35978_);
                        return ChestMenu.m_39246_((int)p_51622_, (Inventory)p_51623_, (Container)this.val$container);
                    }
                    return null;
                }

                public Component m_5446_() {
                    if (p_51604_.m_8077_()) {
                        return p_51604_.m_5446_();
                    }
                    return p_51605_.m_8077_() ? p_51605_.m_5446_() : Component.m_237115_((String)"container.chestDouble");
                }
            });
        }

        public Optional<MenuProvider> acceptSingle(ModChestBlockEntity p_51602_) {
            return Optional.of(p_51602_);
        }

        public Optional<MenuProvider> acceptNone() {
            return Optional.empty();
        }
    };
    public WoodType type;

    public ModChest(BlockBehaviour.Properties pProperties, Supplier<BlockEntityType<? extends ModChestBlockEntity>> pBlockEntityType, WoodType type) {
        super(pProperties, pBlockEntityType);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(TYPE, (Comparable)ChestType.SINGLE)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_(WOOD_TYPE, (Comparable)((Object)type)));
        this.type = type;
    }

    public static DoubleBlockCombiner.BlockType getBlockType(BlockState p_51583_) {
        ChestType chesttype = (ChestType)p_51583_.m_61143_(TYPE);
        if (chesttype == ChestType.SINGLE) {
            return DoubleBlockCombiner.BlockType.SINGLE;
        }
        return chesttype == ChestType.RIGHT ? DoubleBlockCombiner.BlockType.FIRST : DoubleBlockCombiner.BlockType.SECOND;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        if (pFacingState.m_60713_((Block)this) && pFacing.m_122434_().m_122479_()) {
            ChestType chesttype = (ChestType)pFacingState.m_61143_(TYPE);
            if (pState.m_61143_(TYPE) == ChestType.SINGLE && chesttype != ChestType.SINGLE && pState.m_61143_((Property)FACING) == pFacingState.m_61143_((Property)FACING) && ModChest.getConnectedDirection(pFacingState) == pFacing.m_122424_()) {
                return (BlockState)pState.m_61124_(TYPE, (Comparable)chesttype.m_61486_());
            }
        } else if (ModChest.getConnectedDirection(pState) == pFacing) {
            return (BlockState)pState.m_61124_(TYPE, (Comparable)ChestType.SINGLE);
        }
        return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (pState.m_61143_(TYPE) == ChestType.SINGLE) {
            return AABB;
        }
        switch (ModChest.getConnectedDirection(pState)) {
            default: {
                return NORTH_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
            case EAST: 
        }
        return EAST_AABB;
    }

    public static Direction getConnectedDirection(BlockState p_51585_) {
        Direction direction = (Direction)p_51585_.m_61143_((Property)FACING);
        return p_51585_.m_61143_(TYPE) == ChestType.LEFT ? direction.m_122427_() : direction.m_122428_();
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        Direction direction2;
        ChestType chesttype = ChestType.SINGLE;
        Direction direction = pContext.m_8125_().m_122424_();
        FluidState fluidstate = pContext.m_43725_().m_6425_(pContext.m_8083_());
        boolean flag = pContext.m_7078_();
        Direction direction1 = pContext.m_43719_();
        if (direction1.m_122434_().m_122479_() && flag && (direction2 = this.candidatePartnerFacing(pContext, direction1.m_122424_())) != null && direction2.m_122434_() != direction1.m_122434_()) {
            direction = direction2;
            ChestType chestType = chesttype = direction2.m_122428_() == direction1.m_122424_() ? ChestType.RIGHT : ChestType.LEFT;
        }
        if (chesttype == ChestType.SINGLE && !flag) {
            if (direction == this.candidatePartnerFacing(pContext, direction.m_122427_())) {
                chesttype = ChestType.LEFT;
            } else if (direction == this.candidatePartnerFacing(pContext, direction.m_122428_())) {
                chesttype = ChestType.RIGHT;
            }
        }
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction)).m_61124_(TYPE, (Comparable)chesttype)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    @Nullable
    private Direction candidatePartnerFacing(BlockPlaceContext pContext, Direction pDirection) {
        BlockState blockstate = pContext.m_43725_().m_8055_(pContext.m_8083_().m_121945_(pDirection));
        return blockstate.m_60713_((Block)this) && blockstate.m_61143_(TYPE) == ChestType.SINGLE ? (Direction)blockstate.m_61143_((Property)FACING) : null;
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        BlockEntity blockentity;
        if (pStack.m_41788_() && (blockentity = pLevel.m_7702_(pPos)) instanceof ModChestBlockEntity) {
            ((ModChestBlockEntity)blockentity).m_58638_(pStack.m_41786_());
        }
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pState.m_60713_(pNewState.m_60734_())) {
            BlockEntity blockentity = pLevel.m_7702_(pPos);
            if (blockentity instanceof Container) {
                Containers.m_19002_((Level)pLevel, (BlockPos)pPos, (Container)((Container)blockentity));
                pLevel.m_46717_(pPos, (Block)this);
            }
            super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
        }
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pLevel.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        MenuProvider menuprovider = this.m_7246_(pState, pLevel, pPos);
        if (menuprovider != null) {
            pPlayer.m_5893_(menuprovider);
            pPlayer.m_36246_(this.getOpenChestStat());
            PiglinAi.m_34873_((Player)pPlayer, (boolean)true);
            BlockEntity be = pLevel.m_7702_(pPos);
            if (be instanceof ModChestBlockEntity) {
                ModChestBlockEntity chest = (ModChestBlockEntity)be;
                chest.sync();
            }
        }
        return InteractionResult.CONSUME;
    }

    protected Stat<ResourceLocation> getOpenChestStat() {
        return Stats.f_12988_.m_12902_((Object)Stats.f_12968_);
    }

    public BlockEntityType<? extends ModChestBlockEntity> blockEntityType() {
        return (BlockEntityType)this.f_48675_.get();
    }

    @Nullable
    public static Container getContainer(ModChest pChest, BlockState pState, Level pLevel, BlockPos pPos, boolean pOverride) {
        return ((Optional)pChest.m_5641_(pState, pLevel, pPos, pOverride).m_5649_(CHEST_COMBINER)).orElse(null);
    }

    public DoubleBlockCombiner.NeighborCombineResult<? extends ModChestBlockEntity> m_5641_(BlockState pState, Level pLevel, BlockPos pPos, boolean pOverride) {
        BiPredicate<LevelAccessor, BlockPos> bipredicate = pOverride ? (p_51578_, p_51579_) -> false : ModChest::isChestBlockedAt;
        return DoubleBlockCombiner.m_52822_((BlockEntityType)((BlockEntityType)this.f_48675_.get()), ModChest::getBlockType, ModChest::getConnectedDirection, (DirectionProperty)FACING, (BlockState)pState, (LevelAccessor)pLevel, (BlockPos)pPos, bipredicate);
    }

    @Nullable
    public MenuProvider m_7246_(BlockState pState, Level pLevel, BlockPos pPos) {
        return ((Optional)this.m_5641_(pState, pLevel, pPos, false).m_5649_(MENU_PROVIDER_COMBINER)).orElse(null);
    }

    public static DoubleBlockCombiner.Combiner<ModChestBlockEntity, Float2FloatFunction> opennessCombiner(final LidBlockEntity pLid) {
        return new DoubleBlockCombiner.Combiner<ModChestBlockEntity, Float2FloatFunction>(){

            public Float2FloatFunction acceptDouble(ModChestBlockEntity p_51633_, ModChestBlockEntity p_51634_) {
                return p_51638_ -> Math.max(p_51633_.m_6683_(p_51638_), p_51634_.m_6683_(p_51638_));
            }

            public Float2FloatFunction acceptSingle(ModChestBlockEntity p_51631_) {
                return arg_0 -> ((ModChestBlockEntity)p_51631_).m_6683_(arg_0);
            }

            public Float2FloatFunction acceptNone() {
                return arg_0 -> ((LidBlockEntity)pLid).m_6683_(arg_0);
            }
        };
    }

    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new ModChestBlockEntity((BlockEntityType)ModTileEntities.CHEST_TILE.get(), pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return pLevel.f_46443_ ? ModChest.m_152132_(pBlockEntityType, this.blockEntityType(), ChestBlockEntity::m_155343_) : null;
    }

    public static boolean isChestBlockedAt(LevelAccessor p_51509_, BlockPos p_51510_) {
        return ModChest.isBlockedChestByBlock((BlockGetter)p_51509_, p_51510_) || ModChest.isCatSittingOnChest(p_51509_, p_51510_);
    }

    private static boolean isBlockedChestByBlock(BlockGetter pLevel, BlockPos pPos) {
        BlockPos blockpos = pPos.m_7494_();
        return pLevel.m_8055_(blockpos).m_60796_(pLevel, blockpos);
    }

    private static boolean isCatSittingOnChest(LevelAccessor pLevel, BlockPos pPos) {
        List list = pLevel.m_45976_(Cat.class, new AABB((double)pPos.m_123341_(), (double)(pPos.m_123342_() + 1), (double)pPos.m_123343_(), (double)(pPos.m_123341_() + 1), (double)(pPos.m_123342_() + 2), (double)(pPos.m_123343_() + 1)));
        if (!list.isEmpty()) {
            for (Cat cat : list) {
                if (!cat.m_21825_()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean m_7278_(BlockState pState) {
        return true;
    }

    public int m_6782_(BlockState pBlockState, Level pLevel, BlockPos pPos) {
        return AbstractContainerMenu.m_38938_((Container)ModChest.getContainer(this, pBlockState, pLevel, pPos, false));
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        BlockState rotated = pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
        return pMirror == Mirror.NONE ? rotated : (BlockState)rotated.m_61124_(TYPE, (Comparable)((ChestType)rotated.m_61143_(TYPE)).m_61486_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING, TYPE, WATERLOGGED, WOOD_TYPE});
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        BlockEntity blockentity = pLevel.m_7702_(pPos);
        if (blockentity instanceof ModChestBlockEntity) {
            ((ModChestBlockEntity)blockentity).m_155350_();
        }
    }

    public static enum WoodType implements StringRepresentable
    {
        WILLOW("willow", (Supplier<Block>)ModBlocks.WILLOW_PLANKS),
        POLISHED_WILLOW("polished_willow", (Supplier<Block>)ModBlocks.POLISHED_WILLOW_PLANKS),
        MAHOGANY("mahogany", (Supplier<Block>)ModBlocks.MAHOGANY_PLANKS),
        POLISHED_MAHOGANY("polished_mahogany", (Supplier<Block>)ModBlocks.POLISHED_MAHOGANY_PLANKS);

        private final String name;
        private final Supplier<Block> supplierPlanks;

        private WoodType(String name, Supplier<Block> supplierPlanks) {
            this.name = name;
            this.supplierPlanks = supplierPlanks;
        }

        public String getName() {
            return this.name;
        }

        public Block getPlanks() {
            return this.supplierPlanks.get();
        }

        public String toString() {
            return this.name;
        }

        public static WoodType byId(int id) {
            WoodType[] type = WoodType.values();
            return type[id < 0 || id >= type.length ? 0 : id];
        }

        public static WoodType byName(String aName) {
            WoodType[] type = WoodType.values();
            return Arrays.stream(type).filter(t -> t.getName().equals(aName)).findFirst().orElse(type[0]);
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

