/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.block;

import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.config.EnderStorageConfig;
import codechicken.enderstorage.tile.TileFrequencyOwner;
import codechicken.lib.colour.EnumColour;
import codechicken.lib.raytracer.RayTracer;
import codechicken.lib.raytracer.SubHitBlockHitResult;
import codechicken.lib.util.ItemUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public abstract class BlockEnderStorage
extends BaseEntityBlock {
    public BlockEnderStorage(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        return willHarvest || super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public void m_6240_(Level worldIn, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        super.m_6240_(worldIn, player, pos, state, te, stack);
        worldIn.m_46597_(pos, Blocks.f_50016_.m_49966_());
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        TileFrequencyOwner tile = (TileFrequencyOwner)((Object)builder.m_78982_(LootContextParams.f_81462_));
        if (tile != null) {
            drops.add(this.createItem(tile.getFrequency()));
            if (EnderStorageConfig.anarchyMode && tile.getFrequency().hasOwner()) {
                drops.add(EnderStorageConfig.getPersonalItem().m_41777_());
            }
        }
        return drops;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult rayTraceResult, BlockGetter world, BlockPos pos, Player player) {
        TileFrequencyOwner tile = (TileFrequencyOwner)world.m_7702_(pos);
        return this.createItem(tile.getFrequency());
    }

    private ItemStack createItem(Frequency freq) {
        ItemStack stack = new ItemStack((ItemLike)this, 1);
        if (EnderStorageConfig.anarchyMode) {
            freq.setOwner(null);
        }
        freq.writeToStack(stack);
        return stack;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult clientHit) {
        EnumColour dye;
        ItemStack item;
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity tile = world.m_7702_(pos);
        if (!(tile instanceof TileFrequencyOwner)) {
            return InteractionResult.FAIL;
        }
        TileFrequencyOwner owner = (TileFrequencyOwner)tile;
        BlockHitResult rawHit = RayTracer.retrace((Player)player);
        if (!(rawHit instanceof SubHitBlockHitResult)) {
            return InteractionResult.FAIL;
        }
        SubHitBlockHitResult hit = (SubHitBlockHitResult)rawHit;
        if (hit.subHit == 4) {
            ItemStack item2 = player.m_150109_().m_36056_();
            if (player.m_6047_() && owner.getFrequency().hasOwner()) {
                if (!player.m_150110_().f_35937_ && !player.m_150109_().m_36054_(EnderStorageConfig.getPersonalItem().m_41777_())) {
                    return InteractionResult.FAIL;
                }
                owner.setFreq(owner.getFrequency().copy().clearOwner());
                return InteractionResult.SUCCESS;
            }
            if (!item2.m_41619_() && ItemUtils.areStacksSameType((ItemStack)item2, (ItemStack)EnderStorageConfig.getPersonalItem()) && !owner.getFrequency().hasOwner()) {
                owner.setFreq(owner.getFrequency().copy().setOwner(player));
                if (!player.m_150110_().f_35937_) {
                    item2.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
        } else if (hit.subHit >= 1 && hit.subHit <= 3 && !(item = player.m_150109_().m_36056_()).m_41619_() && (dye = EnumColour.fromDyeStack((ItemStack)item)) != null) {
            EnumColour[] colours = new EnumColour[]{null, null, null};
            if (colours[hit.subHit - 1] == dye) {
                return InteractionResult.FAIL;
            }
            colours[hit.subHit - 1] = dye;
            owner.setFreq(owner.getFrequency().copy().set(colours));
            if (!player.m_150110_().f_35937_) {
                item.m_41774_(1);
            }
            return InteractionResult.FAIL;
        }
        return !player.m_6047_() && owner.activate(player, hit.subHit, hand) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof TileFrequencyOwner) {
            ((TileFrequencyOwner)tile).onNeighborChange(fromPos);
        }
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof TileFrequencyOwner) {
            ((TileFrequencyOwner)tile).onPlaced(placer);
        }
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof TileFrequencyOwner) {
            return ((TileFrequencyOwner)tile).getLightValue();
        }
        return 0;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        BlockEntity tile = world.m_7702_(pos);
        return tile instanceof TileFrequencyOwner && ((TileFrequencyOwner)tile).redstoneInteraction();
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        BlockEntity tile = world.m_7702_(pos);
        return tile instanceof TileFrequencyOwner ? ((TileFrequencyOwner)tile).comparatorInput() : 0;
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation direction) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof TileFrequencyOwner) {
            ((TileFrequencyOwner)tile).rotate();
        }
        return state;
    }

    public boolean m_8133_(BlockState state, Level worldIn, BlockPos pos, int eventID, int eventParam) {
        super.m_8133_(state, worldIn, pos, eventID, eventParam);
        BlockEntity tileentity = worldIn.m_7702_(pos);
        return tileentity != null && tileentity.m_7531_(eventID, eventParam);
    }
}

