/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.sodiumextra.mixin.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import me.flashyreese.mods.sodiumextra.client.SodiumExtraClientMod;
import me.flashyreese.mods.sodiumextra.client.gui.SodiumExtraGameOptions;
import me.flashyreese.mods.sodiumextra.mixin.gui.MinecraftClientAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ForgeGui.class})
public abstract class MixinInGameHud
extends Gui {
    public MixinInGameHud(Minecraft client, ItemRenderer itemRenderer) {
        super(client, itemRenderer);
    }

    @Inject(method={"renderHUDText"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;defaultBlendFunc()V", shift=At.Shift.AFTER)})
    public void render(int width, int height, PoseStack matrices, CallbackInfo callbackInfo) {
        if (!this.f_92986_.f_91066_.f_92063_) {
            if (SodiumExtraClientMod.options().extraSettings.showFps && SodiumExtraClientMod.options().extraSettings.showCoords) {
                this.renderFPS(matrices);
                this.renderCoords(matrices);
            } else if (SodiumExtraClientMod.options().extraSettings.showFps) {
                this.renderFPS(matrices);
            } else if (SodiumExtraClientMod.options().extraSettings.showCoords) {
                this.renderCoords(matrices);
            }
            if (!SodiumExtraClientMod.options().renderSettings.lightUpdates) {
                this.renderLightUpdatesWarning(matrices);
            }
        }
    }

    private void renderFPS(PoseStack matrices) {
        int x;
        int currentFPS = MinecraftClientAccessor.getCurrentFPS();
        MutableComponent text = Component.m_237110_((String)"sodium-extra.overlay.fps", (Object[])new Object[]{currentFPS});
        if (SodiumExtraClientMod.options().extraSettings.showFPSExtended) {
            text = Component.m_237113_((String)String.format("%s %s", text.getString(), Component.m_237110_((String)"sodium-extra.overlay.fps_extended", (Object[])new Object[]{SodiumExtraClientMod.getClientTickHandler().getHighestFps(), SodiumExtraClientMod.getClientTickHandler().getAverageFps(), SodiumExtraClientMod.getClientTickHandler().getLowestFps()}).getString()));
        }
        this.drawString(matrices, (Component)text, x, switch (SodiumExtraClientMod.options().extraSettings.overlayCorner) {
            case SodiumExtraGameOptions.OverlayCorner.TOP_LEFT -> {
                x = 2;
                yield 2;
            }
            case SodiumExtraGameOptions.OverlayCorner.TOP_RIGHT -> {
                x = this.f_92977_ - this.f_92986_.f_91062_.m_92852_((FormattedText)text) - 2;
                yield 2;
            }
            case SodiumExtraGameOptions.OverlayCorner.BOTTOM_LEFT -> {
                x = 2;
                Objects.requireNonNull(this.f_92986_.f_91062_);
                yield this.f_92978_ - 9 - 2;
            }
            case SodiumExtraGameOptions.OverlayCorner.BOTTOM_RIGHT -> {
                x = this.f_92977_ - this.f_92986_.f_91062_.m_92852_((FormattedText)text) - 2;
                Objects.requireNonNull(this.f_92986_.f_91062_);
                yield this.f_92978_ - 9 - 2;
            }
            default -> throw new IllegalStateException("Unexpected value: " + SodiumExtraClientMod.options().extraSettings.overlayCorner);
        });
    }

    private void renderCoords(PoseStack matrices) {
        int x;
        if (this.f_92986_.f_91074_ == null) {
            return;
        }
        if (this.f_92986_.m_91299_()) {
            return;
        }
        Vec3 pos = this.f_92986_.f_91074_.m_20182_();
        MutableComponent text = Component.m_237110_((String)"sodium-extra.overlay.coordinates", (Object[])new Object[]{String.format("%.2f", pos.f_82479_), String.format("%.2f", pos.f_82480_), String.format("%.2f", pos.f_82481_)});
        this.drawString(matrices, (Component)text, x, switch (SodiumExtraClientMod.options().extraSettings.overlayCorner) {
            case SodiumExtraGameOptions.OverlayCorner.TOP_LEFT -> {
                x = 2;
                yield 12;
            }
            case SodiumExtraGameOptions.OverlayCorner.TOP_RIGHT -> {
                x = this.f_92977_ - this.f_92986_.f_91062_.m_92852_((FormattedText)text) - 2;
                yield 12;
            }
            case SodiumExtraGameOptions.OverlayCorner.BOTTOM_LEFT -> {
                x = 2;
                Objects.requireNonNull(this.f_92986_.f_91062_);
                yield this.f_92978_ - 9 - 12;
            }
            case SodiumExtraGameOptions.OverlayCorner.BOTTOM_RIGHT -> {
                x = this.f_92977_ - this.f_92986_.f_91062_.m_92852_((FormattedText)text) - 2;
                Objects.requireNonNull(this.f_92986_.f_91062_);
                yield this.f_92978_ - 9 - 12;
            }
            default -> throw new IllegalStateException("Unexpected value: " + SodiumExtraClientMod.options().extraSettings.overlayCorner);
        });
    }

    private void renderLightUpdatesWarning(PoseStack matrices) {
        int x;
        MutableComponent text = Component.m_237115_((String)"sodium-extra.overlay.light_updates");
        this.drawString(matrices, (Component)text, x, switch (SodiumExtraClientMod.options().extraSettings.overlayCorner) {
            case SodiumExtraGameOptions.OverlayCorner.TOP_LEFT -> {
                x = 2;
                yield 22;
            }
            case SodiumExtraGameOptions.OverlayCorner.TOP_RIGHT -> {
                x = this.f_92977_ - this.f_92986_.f_91062_.m_92852_((FormattedText)text) - 2;
                yield 22;
            }
            case SodiumExtraGameOptions.OverlayCorner.BOTTOM_LEFT -> {
                x = 2;
                Objects.requireNonNull(this.f_92986_.f_91062_);
                yield this.f_92978_ - 9 - 22;
            }
            case SodiumExtraGameOptions.OverlayCorner.BOTTOM_RIGHT -> {
                x = this.f_92977_ - this.f_92986_.f_91062_.m_92852_((FormattedText)text) - 2;
                Objects.requireNonNull(this.f_92986_.f_91062_);
                yield this.f_92978_ - 9 - 22;
            }
            default -> throw new IllegalStateException("Unexpected value: " + SodiumExtraClientMod.options().extraSettings.overlayCorner);
        });
    }

    private void drawString(PoseStack matrices, Component text, int x, int y) {
        if (SodiumExtraClientMod.options().extraSettings.textContrast == SodiumExtraGameOptions.TextContrast.NONE) {
            this.f_92986_.f_91062_.m_92889_(matrices, text, (float)x, (float)y, -1);
        } else if (SodiumExtraClientMod.options().extraSettings.textContrast == SodiumExtraGameOptions.TextContrast.BACKGROUND) {
            int n = x + this.f_92986_.f_91062_.m_92852_((FormattedText)text) + 1;
            Objects.requireNonNull(this.f_92986_.f_91062_);
            GuiComponent.m_93172_((PoseStack)matrices, (int)(x - 1), (int)(y - 1), (int)n, (int)(y + 9), (int)-1873784752);
            this.f_92986_.f_91062_.m_92889_(matrices, text, (float)x, (float)y, -1);
        } else if (SodiumExtraClientMod.options().extraSettings.textContrast == SodiumExtraGameOptions.TextContrast.SHADOW) {
            this.f_92986_.f_91062_.m_92763_(matrices, text, (float)x, (float)y, -1);
        }
    }
}

